/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.rafts;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.ConfigurationService;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.data.Alert;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.data.KeyValueDataList;
import org.lsst.ccs.bus.data.RunMode;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.bus.states.PhaseState;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.config.ConfigurationBulkChangeHandler;
import org.lsst.ccs.daq.utilities.FitsHeaderKeywordData;
import org.lsst.ccs.daq.utilities.FitsService;
import org.lsst.ccs.description.ComponentLookup;
import org.lsst.ccs.description.ComponentNode;
import org.lsst.ccs.drivers.reb.Aspic;
import org.lsst.ccs.drivers.reb.BaseSet;
import org.lsst.ccs.drivers.reb.BoardDacs;
import org.lsst.ccs.drivers.reb.ClientFactory;
import org.lsst.ccs.drivers.reb.ImageClient;
import org.lsst.ccs.drivers.reb.ImageMetadata;
import org.lsst.ccs.drivers.reb.PowerAdcs;
import org.lsst.ccs.drivers.reb.REBException;
import org.lsst.ccs.drivers.reb.RegClient;
import org.lsst.ccs.drivers.reb.Sequencer;
import org.lsst.ccs.drivers.reb.SlowAdcs;
import org.lsst.ccs.drivers.reb.StatusSet;
import org.lsst.ccs.drivers.reb.TempAdcs;
import org.lsst.ccs.drivers.reb.TempRtds;
import org.lsst.ccs.framework.ClearAlertHandler;
import org.lsst.ccs.monitor.Channel;
import org.lsst.ccs.monitor.Control;
import org.lsst.ccs.monitor.Device;
import org.lsst.ccs.services.AgentStateService;
import org.lsst.ccs.services.alert.AlertService;
import org.lsst.ccs.subsystem.common.ErrorUtils;
import org.lsst.ccs.subsystem.rafts.AspicControl;
import org.lsst.ccs.subsystem.rafts.BiasControl;
import org.lsst.ccs.subsystem.rafts.DacControl;
import org.lsst.ccs.subsystem.rafts.GlobalProc;
import org.lsst.ccs.subsystem.rafts.ImageProc;
import org.lsst.ccs.subsystem.rafts.SequencerProc;
import org.lsst.ccs.subsystem.rafts.alerts.RaftAlert;
import org.lsst.ccs.subsystem.rafts.config.ASPIC;
import org.lsst.ccs.subsystem.rafts.config.BiasDACS;
import org.lsst.ccs.subsystem.rafts.config.REB;
import org.lsst.ccs.subsystem.rafts.data.ImageData;
import org.lsst.ccs.subsystem.rafts.data.RaftException;
import org.lsst.ccs.subsystem.rafts.data.RegisterData;
import org.lsst.ccs.subsystem.rafts.data.StatusData;
import org.lsst.ccs.subsystem.rafts.states.HVBiasState;
import org.lsst.ccs.subsystem.rafts.states.RebDeviceState;
import org.lsst.ccs.subsystem.rafts.states.RebValidationState;
import org.lsst.ccs.utilities.ccd.CCDType;
import org.lsst.ccs.utilities.ccd.Reb;
import org.lsst.ccs.utilities.taitime.CCSTimeStamp;

public class REBDevice
extends Device
implements ClearAlertHandler,
ConfigurationBulkChangeHandler {
    private static final String SERIAL_NUM = "serialNum";
    public static final String RAFTS = "Rafts";
    public static final String RAFTS_LIMITS = "RaftsLimits";
    public static final String RAFTS_POWER = "RaftsPower";
    public static final int TYPE_BD_TEMP = 0;
    public static final int TYPE_BD_POWER = 1;
    public static final int TYPE_RTD = 2;
    public static final int TYPE_ASP_TEMP = 3;
    public static final int TYPE_BIAS_VOLT = 4;
    public static final int TYPE_CCD_CURR = 5;
    public static final int TYPE_CR_VOLT = 6;
    public static final int TYPE_HEATER = 7;
    public static final int TYPE_HV_SWITCH = 8;
    public static final int CHAN_TOTAL_POWER = -1;
    public static final int CHAN_HTR_VOLTS = 0;
    public static final int CHAN_HTR_POWER = 1;
    public static final int NUM_HTR_CHANS = 2;
    public static final int CHAN_RTD_INT_TEMP = 4;
    public static final int CHAN_RTD_INT_VOLT = 5;
    public static final int NUM_RTD_CHANS = 6;
    static final int REB_NUM_MASK = 3;
    static final int RAFT_NUM_MASK = 63;
    static final int RAFT_NUM_SHIFT = 2;
    static final int POWER_ON_DELAY = 200;
    static final int POWER_OFF_DELAY = 50;
    static final int DAC_LIMIT = 4095;
    static final double DAC_CONV = 819.0;
    static final double HTR_CONV = 409.5;
    static final double HTR_CONV_R5 = 409.5;
    static final double HEATER_OHMS = 14.5;
    static final double HTR_LEAD_OHMS = 0.3;
    static final int ADC_PCLK_L = 0;
    static final int ADC_PCLK_U = 1;
    static final int ADC_SCLK_L = 2;
    static final int ADC_SCLK_U = 3;
    static final int ADC_RG_L = 4;
    static final int ADC_RG_U = 5;
    static final int ADC_GD_0 = 6;
    static final int ADC_OD_0 = 7;
    static final int ADC_OG_0 = 8;
    static final int ADC_RD_0 = 9;
    static final int NUM_WREB_ADCS = 10;
    static final int ADC_GD_1 = 10;
    static final int ADC_OD_1 = 11;
    static final int ADC_OG_1 = 12;
    static final int ADC_RD_1 = 13;
    static final int NUM_GREB_ADCS = 14;
    static final int ADC_GD_2 = 14;
    static final int ADC_OD_2 = 15;
    static final int ADC_OG_2 = 16;
    static final int ADC_RD_2 = 17;
    static final int NUM_SREB_ADCS = 18;
    private static final Map<String, Integer> hdwTypeMap = new HashMap<String, Integer>();
    private static final Map<String, Integer> typeMap;
    private static final int[] adcChans;
    private static final String[] adcNames;
    private static final int seqClockLines = 4080;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private ConfigurationService sce;
    @LookupField(strategy=LookupField.Strategy.TOP)
    private Subsystem subsys;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AlertService alertService;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentStateService stateService;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private GlobalProc globalProc;
    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    private FitsService fitsService;
    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    private final Map<String, Channel> childChannels = new HashMap<String, Channel>();
    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    private final Map<String, Control> controlsMap = new LinkedHashMap<String, Control>();
    @ConfigurationParameter(name="serialNum", category="Rafts")
    private long serialNum;
    @ConfigurationParameter(category="Rafts", isFinal=true)
    private int id = -1;
    @ConfigurationParameter(category="Rafts", isFinal=true)
    private boolean useScienceCCD = false;
    @ConfigurationParameter(category="Rafts", description="Disables the RTD derived CCD type check.")
    private boolean disableRTDHardwareCheck = false;
    boolean processImages = true;
    @ConfigurationParameter(category="RaftsPower", description="Maximum OFF_State ODI (A) per CCD", units="Amps")
    private double odiQmax;
    @ConfigurationParameter(category="RaftsPower", description="Minimum ON_State ODI (A) per CCD", units="Amps")
    private double odiAmin;
    @ConfigurationParameter(category="RaftsPower", description="Maximum OFF_State CLKLI (A) per REB", units="Amps")
    private double clkliQmax;
    @ConfigurationParameter(category="RaftsPower", description="Minimum ON_State CLKLI (A) per REB", units="Amps")
    private double clkliAmin;
    @ConfigurationParameter(category="RaftsPower", description="Maximum OFF_State CLKHI (A) per REB", units="Amps")
    private double clkhiQmax;
    @ConfigurationParameter(category="RaftsPower", description="Minimum ON_State CLKHI (A) per REB", units="Amps")
    private double clkhiAmin;
    private String hdwType = "daq";
    private String ifcName;
    private int rebType = 0;
    private int[] dataSegmentMap = null;
    private static final Logger LOG;
    private final BaseSet bss = new BaseSet();
    private final StatusSet sts = new StatusSet(this.bss);
    private final TempAdcs tmp = new TempAdcs(this.bss);
    private final PowerAdcs pwr = new PowerAdcs(this.bss);
    private final SlowAdcs slow = new SlowAdcs(this.bss);
    private final TempRtds rtd = new TempRtds(this.bss);
    private final BoardDacs dac = new BoardDacs(this.bss);
    private final Aspic asp = new Aspic(this.bss);
    private final Sequencer seq = new Sequencer(this.bss);
    private final ImageClient imc = new ImageClient((RegClient)this.bss);
    private final BiasControl[] biases = new BiasControl[3];
    private final AspicControl[] aspics = new AspicControl[6];
    private ImageProc img;
    private final SequencerProc sqp = new SequencerProc(this.bss);
    private DacControl dacCtrl;
    private final Map<Integer, String> sadcChannelMap = new HashMap<Integer, String>();
    private final Map<Integer, String> pwrChannelMap = new HashMap<Integer, String>();
    private long hwSerialNum = 0L;
    private boolean serialNumValid = false;
    protected int hdwTypeI;
    protected int configCcdMask;
    protected int realCcdMask;
    protected int hwVersion;
    private int maxTemp;
    private int maxPower;
    private int maxAtemp;
    private int maxCcdI;
    private int numTemp;
    private int numPower;
    private int numAtemp;
    private int numCrVolt;
    private int numRtd;
    private boolean dacRaw;
    private boolean biasRaw;
    private double[] tempValues;
    private double[] powerValues;
    private double[] atempValues;
    private final double[] heaterValues = new double[2];
    private int errorCount;
    private int dacLoadDelay = 0;
    private int dacClearDelay = 0;
    private Boolean useFullPath;
    private CCDType ccdType = null;
    private CCDType hwCcdType = null;
    private Reb rebGeometry;
    private int exceptionCount = 0;
    private String exceptionText;
    private static final Map<String, Integer> rsetNames;

    public void build() {
        super.build();
        ComponentLookup lookupService = this.subsys.getComponentLookup();
        ComponentNode rebNode = lookupService.getComponentNodeForObject((Object)this);
        if (this.processImages) {
            this.img = new ImageProc(this.imc);
            ComponentNode imageProcNode = new ComponentNode("imageProc", (Object)this.img);
            lookupService.addComponentNodeToLookup(rebNode, imageProcNode);
            if (this.dataSegmentMap != null) {
                this.img.setDataSegmentMap(this.dataSegmentMap);
            }
            if (this.fitsService == null) {
                LOG.log(Level.WARNING, "No fits service for {0} is defined in groovy. For now using internal instance.", this.name);
                FitsService fitsSrvc = new FitsService();
                ComponentNode fitsServiceNode = new ComponentNode(this.name + ".FitsService", (Object)fitsSrvc);
                lookupService.addComponentNodeToLookup(rebNode, fitsServiceNode);
                fitsSrvc.setHeaderFilesList(Arrays.asList("primary", "extended", "Fits_primary_header.spec:primary"));
            }
        } else {
            LOG.log(Level.INFO, "No images will be processed by this device: {0}", this.name);
        }
    }

    public void setRebGeometry(Reb reb) {
        this.rebGeometry = reb;
        if (this.img != null) {
            this.img.setRebGeometry(reb);
        }
        this.setCcdType(reb.getCCDType());
    }

    public Reb getRebGeometry() {
        return this.rebGeometry;
    }

    public void validateBulkChange(Map<String, Object> params) {
        long sNum = (Long)params.get(SERIAL_NUM);
        if (this.hwSerialNum != 0L) {
            if (sNum != -1L && sNum != this.hwSerialNum) {
                String msg = "Configuration has wrong REB s/n: " + sNum + "; " + this.name + " s/n is " + this.hwSerialNum;
                throw new IllegalArgumentException(msg);
            }
            LOG.log(Level.INFO, "Configured {0} s/n ({1}) is valid", new Object[]{this.name, sNum});
            this.serialNumValid = true;
            this.stateService.updateAgentComponentState((Object)this, new Enum[]{RebValidationState.VALID});
        }
    }

    @Command(type=Command.CommandType.QUERY, description="Get the REB ID")
    public int getId() {
        return this.id;
    }

    @Command(type=Command.CommandType.QUERY, description="Get the network interface name")
    public String getIfcName() {
        return this.ifcName;
    }

    @Command(type=Command.CommandType.QUERY, description="Get the mask of CCDs being used")
    public int getCcdMask() {
        return this.realCcdMask;
    }

    public void setCcdType(CCDType ccdType) {
        LOG.log(Level.INFO, "setCcdType to {0} for {1}", new Object[]{ccdType, this.name});
        this.ccdType = ccdType;
        this.dacLoadDelay = ccdType == null ? 0 : 200;
        this.dacClearDelay = ccdType == null ? 0 : 50;
    }

    @Command(type=Command.CommandType.QUERY, description="Get the type of CCDs being used")
    public CCDType getCcdType() {
        return this.ccdType;
    }

    @Command(type=Command.CommandType.QUERY, description="Get the hardware type of CCDs being used")
    public CCDType getHwCcdType() {
        return this.hwCcdType;
    }

    @Command(type=Command.CommandType.ACTION, description="Set whether a WREB is using a science CCD")
    public void setScienceCCD(@Argument(description="Whether a science CCD") boolean useScience) {
        this.rtd.setScienceCCD(useScience);
    }

    public void setClientFactory(ClientFactory factory) {
        if (factory != null) {
            this.bss.setClientFactory(factory);
            this.imc.setClientFactory(factory);
        }
    }

    @Command(type=Command.CommandType.QUERY, description="Gets the REB type")
    public int getRebType() {
        return this.rebType;
    }

    @Command(type=Command.CommandType.QUERY, description="Gets the REB number")
    public int getRebNumber() {
        return this.id & 3;
    }

    @Command(type=Command.CommandType.QUERY, description="Gets the raft number")
    public int getRaftNumber() {
        return this.id >> 2 & 0x3F;
    }

    @Command(type=Command.CommandType.QUERY, description="Gets the hardware type")
    public int getHdwType() {
        return this.hdwTypeI;
    }

    @Command(type=Command.CommandType.QUERY, description="Get the hardware version")
    public int getHwVersion() {
        return this.hwVersion;
    }

    @Command(type=Command.CommandType.QUERY, description="Get the serial number")
    public long getSerialNumber() {
        return this.hwSerialNum;
    }

    public boolean isSerialNumValid() {
        return this.serialNumValid;
    }

    public ClearAlertHandler.ClearAlertCode canClearAlert(Alert alert, AlertState alertState) {
        if (alert.getAlertId().equals(RaftAlert.REB_NOT_CONNECTED.getAlertId())) {
            return ClearAlertHandler.ClearAlertCode.CLEAR_ALERT;
        }
        return ClearAlertHandler.ClearAlertCode.UNKNOWN_ALERT;
    }

    private void addToChannelMap(Map map, int hwChan, String chName) {
        if (this.useFullPath == null) {
            String fpProperty = this.subsys.getAgentInfo().getAgentProperty("org.lsst.ccs.use.full.paths", "false");
            this.useFullPath = "true".equals(fpProperty.toLowerCase());
        }
        if (this.useFullPath.booleanValue()) {
            Channel chan = this.childChannels.get(chName);
            if (chan == null) {
                chan = this.mon.getChannel(chName);
            }
            map.put(hwChan, chan.getPath());
        } else {
            map.put(hwChan, chName);
        }
    }

    protected void initDevice() {
        Integer type;
        String partition;
        this.stateService.registerState(RebDeviceState.class, "Reb Device ONLINE/OFFLINE State", (Object)this);
        this.stateService.registerState(RebValidationState.class, "Reb Device Validation State", (Object)this);
        this.stateService.registerState(HVBiasState.class, "High Voltage Bias ON/OFF State", (Object)this);
        this.stateService.updateAgentComponentState((Object)this, new Enum[]{RebDeviceState.OFFLINE, RebValidationState.UNKNOWN, HVBiasState.UNKNOWN});
        if (this.id < 0) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"id", (String)"has not been specified");
        }
        if ((partition = this.globalProc.getPartition()) != null && !partition.isEmpty()) {
            this.ifcName = partition;
        }
        if (this.ifcName == null) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"ifcName", (String)"has not been specified");
        }
        if ((type = hdwTypeMap.get(this.hdwType.toUpperCase())) == null) {
            ErrorUtils.reportConfigError((Logger)LOG, (String)this.name, (String)"hdwType", (String)"is invalid");
        }
        this.hdwTypeI = type;
        this.imc.setRebId("reb-" + this.id);
        if (this.img != null) {
            this.img.configure(null);
        }
        int biasMask = 0;
        int aspMask = 0;
        int aspicMask = 0;
        for (Control ctrl : this.controlsMap.values()) {
            if (ctrl instanceof BiasControl) {
                biasMask |= 1 << ctrl.getHwChan();
                continue;
            }
            if (!(ctrl instanceof AspicControl)) continue;
            aspMask |= 1 << ctrl.getHwChan();
        }
        int j = 0;
        while (j < 3) {
            int pair = aspMask & 3;
            if (pair != 0) {
                if (pair == 3) {
                    aspicMask |= 1 << j;
                } else {
                    LOG.log(Level.SEVERE, "Unpaired configuration for {0} ASPIC {1} ignored", new Object[]{this.name, 2 * j + pair - 1});
                }
            }
            ++j;
            aspMask >>= 2;
        }
        if (biasMask != 0 && biasMask != aspicMask) {
            LOG.log(Level.WARNING, "{0} ASPIC and bias configurations don't match", this.name);
        }
        this.configCcdMask = biasMask | aspicMask;
        for (Control ctrl : this.controlsMap.values()) {
            if (ctrl instanceof DacControl) {
                this.dacCtrl = (DacControl)ctrl;
                continue;
            }
            if (ctrl instanceof BiasControl) {
                if ((1 << ctrl.getHwChan() & this.configCcdMask) == 0) continue;
                this.biases[ctrl.getHwChan()] = (BiasControl)ctrl;
                continue;
            }
            if (!(ctrl instanceof AspicControl) || (1 << ctrl.getHwChan() / 2 & this.configCcdMask) == 0) continue;
            this.aspics[ctrl.getHwChan()] = (AspicControl)ctrl;
        }
        this.bss.setDefaultRebType(0);
        try {
            this.realCcdMask = this.configCcdMask & (1 << this.bss.getNumStrips()) - 1;
        }
        catch (REBException e) {
            LOG.log(Level.SEVERE, "Error getting expected {0} CCD count: {1}", new Object[]{this.name, e});
        }
        this.fullName = this.name;
    }

    protected void initialize() {
        try {
            int j;
            this.bss.open(this.hdwTypeI, this.id, this.ifcName);
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.bss.disable();
            this.bss.setTime();
            this.bss.enable();
            this.rebType = this.bss.getRebType();
            this.hwVersion = this.bss.getHwVersion();
            this.maxTemp = this.tmp.getNumRegs();
            this.maxPower = this.pwr.getNumRegs();
            this.maxAtemp = this.slow.getNumAspicTemps();
            this.maxCcdI = this.slow.getNumCcdCurrents();
            this.numRtd = 0;
            this.numCrVolt = 0;
            this.numAtemp = 0;
            this.numPower = 0;
            this.numTemp = 0;
            this.tempValues = new double[this.maxTemp];
            this.powerValues = new double[this.maxPower];
            this.atempValues = new double[this.maxAtemp];
            this.realCcdMask = this.configCcdMask & (1 << this.bss.getNumStrips()) - 1;
            if (this.img != null) {
                this.img.setCcdMask(this.realCcdMask);
                this.img.setNumRebCcds(this.bss.getNumStrips());
                this.img.setDataInversion(this.bss.getRebType() == 0);
            }
            if (this.dacCtrl != null && !this.dacCtrl.checkConfig()) {
                this.dacCtrl = null;
            }
            this.dacRaw = this.dacCtrl != null ? this.dacCtrl.isRaw() : false;
            this.biasRaw = false;
            for (j = 0; j < this.biases.length; ++j) {
                BiasControl bias = this.biases[j];
                if (bias != null && !bias.checkConfig()) {
                    bias = null;
                }
                if (bias != null) {
                    this.biasRaw = bias.isRaw();
                }
                this.biases[j] = bias;
            }
            for (j = 0; j < this.aspics.length; ++j) {
                AspicControl aspic = this.aspics[j];
                if (aspic != null && !aspic.checkConfig()) {
                    aspic = null;
                }
                this.aspics[j] = aspic;
            }
            try {
                this.hwSerialNum = this.bss.getRebSerial();
            }
            catch (REBException e) {
                LOG.log(Level.SEVERE, "Error reading {0} serial number", this.name);
                this.hwSerialNum = -1L;
            }
            boolean bl = this.serialNumValid = this.serialNum == -1L || this.serialNum == this.hwSerialNum;
            if (!this.serialNumValid) {
                this.stateService.updateAgentComponentState((Object)this, new Enum[]{RebValidationState.INVALID});
                LOG.log(Level.SEVERE, "{0} s/n ({1}) doesn''t match configuration value ({2})", new Object[]{this.name, this.hwSerialNum, this.serialNum});
            } else {
                this.stateService.updateAgentComponentState((Object)this, new Enum[]{RebValidationState.VALID});
            }
            this.rtd.initialize();
            try {
                Thread.sleep(this.globalProc.getSleepAfterRtdInitialize());
            }
            catch (InterruptedException e) {
                LOG.log(Level.SEVERE, "Thread.sleep(100) interrupted at rtd.initialize() for {0}", this.name);
            }
            if (!this.disableRTDHardwareCheck) {
                try {
                    int type = this.rtd.getCCDType();
                    Object object = type == 2 ? CCDType.getCCDType((String)"e2v") : (this.hwCcdType = type == 1 ? CCDType.getCCDType((String)"itl") : null);
                    if (RunMode.isSimulation()) {
                        this.hwCcdType = CCDType.getCCDType((String)this.ccdType.getName());
                    }
                    LOG.log(Level.INFO, "found hwCcdType {0} for {1}", new Object[]{this.hwCcdType, this.name});
                    CCDType manufacturerType = CCDType.getCCDType((String)this.ccdType.getManufacturer());
                    if (this.hwCcdType == null || !this.hwCcdType.equals((Object)manufacturerType)) {
                        throw new RuntimeException("CCD Hardware type " + this.hwCcdType + " is inconsistent with configured CCD Type " + manufacturerType);
                    }
                }
                catch (REBException e) {
                    LOG.log(Level.SEVERE, "Error getting CCD type for" + this.name, e);
                    this.hwCcdType = null;
                }
            }
            this.rtd.setScienceCCD(this.useScienceCCD);
            this.errorCount = 0;
            this.initSensors();
            this.imc.open(this.hdwTypeI, this.id, this.ifcName);
            if (this.stateService.isInState((Enum)PhaseState.OPERATIONAL)) {
                try {
                    boolean CCDsPowerState = this.getCCDsPowerState();
                    if (CCDsPowerState) {
                        LOG.log(Level.INFO, "getCCDsPowerState() for {0} found CCDs are ON ", this.name);
                    } else {
                        LOG.log(Level.INFO, "getCCDsPowerState() for {0} found CCDs are OFF", this.name);
                    }
                }
                catch (RaftException e) {
                    LOG.log(Level.SEVERE, "Error getting CCDsPowerState for " + this.name, e);
                }
                try {
                    if (this.sqp.isRunning()) {
                        LOG.log(Level.INFO, "Sequencer is running for {0}", this.name);
                    } else {
                        LOG.log(Level.INFO, "Sequencer is idle for {0}", this.name);
                    }
                }
                catch (REBException e) {
                    LOG.log(Level.SEVERE, "Failed to determine sequencer state for " + this.name, e);
                }
            }
            this.setOnline(true);
            this.logExceptionCount();
            LOG.log(Level.INFO, "Connected to {0}", this.name);
            LOG.log(Level.INFO, String.format("%s has firmware version: 0x%x", this.name, this.hwVersion));
            LOG.log(Level.INFO, String.format("%s has serialNumber: %d", this.name, this.hwSerialNum));
            if (this.inited) {
                this.alertService.raiseAlert(RaftAlert.REB_NOT_CONNECTED.getAlert(), AlertState.NOMINAL, this.name + " is connected");
            }
            this.exceptionCount = 0;
        }
        catch (REBException e) {
            String text = e.getMessage();
            if (this.exceptionCount == 0 || !this.exceptionText.equals(text)) {
                this.logExceptionCount();
                LOG.log(Level.SEVERE, "Error connecting to {0}: {1}", new Object[]{this.name, e});
                if (this.exceptionCount == 0) {
                    this.close("could not connect");
                }
                this.exceptionCount = 0;
                this.exceptionText = text;
            }
            ++this.exceptionCount;
        }
        this.inited = true;
    }

    protected void close() {
        this.close("was disconnected");
    }

    private void close(String alertText) {
        try {
            this.rebType = -1;
            this.hwVersion = 0;
            this.hwSerialNum = 0L;
            this.hwCcdType = null;
            this.bss.close();
        }
        catch (REBException rEBException) {
            // empty catch block
        }
        try {
            this.imc.close();
        }
        catch (REBException rEBException) {
            // empty catch block
        }
        if (alertText != null) {
            this.alertService.raiseAlert(RaftAlert.REB_NOT_CONNECTED.getAlert(), AlertState.ALARM, this.name + " " + alertText);
        }
    }

    private Integer convertTypeStrToInt(String typeStr) throws Exception {
        Integer iType = typeMap.get(typeStr.toUpperCase());
        if (iType == null) {
            ErrorUtils.reportChannelError((Logger)LOG, (String)this.name, (String)"channel type", (Object)typeStr);
        }
        return iType;
    }

    protected int[] checkChannel(String name, int hwChan, String type, String subtype) throws Exception {
        Integer iType = this.convertTypeStrToInt(type);
        return new int[]{iType, 0};
    }

    protected void initChannel(String name, int id, int hwChan, int type, int subtype) {
        try {
            boolean chanOk;
            if (type == 4 || type == 6) {
                chanOk = this.slow.testChannel(hwChan);
                if (chanOk) {
                    this.addToChannelMap(this.sadcChannelMap, hwChan, name);
                }
            } else {
                int maxChan = type == 0 ? this.maxTemp : (type == 1 ? this.maxPower : (type == 3 ? this.maxAtemp : (type == 5 ? this.maxCcdI : (type == 2 ? 6 : (type == 7 ? 2 : (type == 8 ? 1 : 0))))));
                boolean bl = chanOk = (hwChan >= 0 || type == 1) && hwChan < maxChan;
                if (chanOk && type == 1 && hwChan >= 0) {
                    this.addToChannelMap(this.pwrChannelMap, hwChan, name);
                }
            }
            if (!chanOk) {
                ErrorUtils.reportChannelError((Logger)LOG, (String)name, (String)"hw channel number", (Object)hwChan);
            }
            switch (type) {
                case 0: {
                    ++this.numTemp;
                    break;
                }
                case 1: {
                    ++this.numPower;
                    break;
                }
                case 3: {
                    ++this.numAtemp;
                    break;
                }
                case 6: {
                    ++this.numCrVolt;
                    break;
                }
                case 2: {
                    ++this.numRtd;
                }
            }
        }
        catch (Exception e) {
            this.dropChannel(id);
        }
    }

    protected String getGroupForChannel(Channel ch) {
        try {
            String typeStr = ch.getTypeStr();
            int type = this.convertTypeStrToInt(typeStr);
            switch (type) {
                case 0: {
                    return ChannelGroup.rebTemp.name();
                }
                case 1: {
                    return ChannelGroup.boardPower.name();
                }
                case 3: {
                    return ChannelGroup.aspicTemp.name();
                }
                case 6: {
                    return ChannelGroup.crVolt.name();
                }
            }
            return null;
        }
        catch (Exception e) {
            throw new RuntimeException("Problem fetching group information for channel " + ch.getName(), e);
        }
    }

    protected void readChannelGroup(String group) {
        try {
            ChannelGroup g = ChannelGroup.valueOf(group);
            if (!this.online) {
                return;
            }
            String item = "";
            try {
                switch (g) {
                    case aspicTemp: {
                        if (this.numAtemp <= 0) break;
                        item = "aspic temperatures";
                        this.atempValues = this.slow.readAspicTemps(0, this.maxAtemp);
                        break;
                    }
                    case crVolt: {
                        if (this.numCrVolt <= 0) break;
                        item = "CCD voltages";
                        this.slow.fetchVoltages();
                        break;
                    }
                    case boardPower: {
                        if (this.numPower <= 0) break;
                        try {
                            this.powerValues = this.pwr.readAdcs();
                            break;
                        }
                        catch (REBException e) {
                            if (e.getMessage().contains("Completion wait")) {
                                for (int j = 0; j < this.powerValues.length; ++j) {
                                    this.powerValues[j] = Double.NaN;
                                }
                                break;
                            }
                            item = "board power";
                            throw e;
                        }
                    }
                    case rebTemp: {
                        if (this.numTemp <= 0) break;
                        try {
                            this.tempValues = this.tmp.readAdcs();
                            break;
                        }
                        catch (REBException e) {
                            if (e.getMessage().contains("Completion wait")) {
                                for (int j = 0; j < this.tempValues.length; ++j) {
                                    this.tempValues[j] = Double.NaN;
                                }
                                break;
                            }
                            item = "board temperatures";
                            throw e;
                        }
                    }
                    default: {
                        throw new RuntimeException("Implementation is missing for group: " + (Object)((Object)g));
                    }
                }
                this.errorCount = 0;
            }
            catch (REBException e) {
                LOG.log(Level.SEVERE, "Error reading {0} {1}: {2}", new Object[]{this.name, item, e.getMessage()});
                this.checkErrorCount(e.getMessage());
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Could not read channles for group: " + group, e);
        }
    }

    protected void readChannelGroup() {
        for (ChannelGroup g : ChannelGroup.values()) {
            this.readChannelGroup(g.name());
        }
    }

    protected double readChannel(int hwChan, int type) {
        double value = Double.NaN;
        if (this.online) {
            String item = "";
            try {
                switch (type) {
                    case 5: {
                        item = "CCD current";
                        value = this.slow.readCurrent(hwChan);
                        this.errorCount = 0;
                        break;
                    }
                    case 4: 
                    case 6: {
                        item = "CCD voltage";
                        value = this.slow.readVoltage(hwChan);
                        this.errorCount = 0;
                        break;
                    }
                    case 2: {
                        item = "RTD";
                        value = hwChan < 4 ? this.rtd.readTemperature(hwChan) : (hwChan == 4 ? this.rtd.readIntTemperature() : this.rtd.readIntVoltage());
                        this.errorCount = 0;
                        break;
                    }
                    case 8: {
                        HVBiasState newState;
                        item = "HV bias switch";
                        value = this.bss.isBackBiasOn() ? 1.0 : 0.0;
                        HVBiasState hVBiasState = newState = value > 0.0 ? HVBiasState.ON : HVBiasState.OFF;
                        if (!this.stateService.isComponentInState(this.getName(), (Enum)newState)) {
                            this.stateService.updateAgentComponentState((Object)this, new Enum[]{newState});
                        }
                        this.errorCount = 0;
                        break;
                    }
                    case 1: {
                        if (hwChan >= 0) {
                            value = this.powerValues[hwChan];
                            break;
                        }
                        value = 0.0;
                        for (int j = 0; j < this.powerValues.length; j += 2) {
                            value += this.powerValues[j] * this.powerValues[j + 1];
                        }
                        value += this.heaterValues[1];
                        break;
                    }
                    case 0: {
                        value = this.tempValues[hwChan];
                        break;
                    }
                    case 3: {
                        value = this.atempValues[hwChan];
                        break;
                    }
                    case 7: {
                        value = this.heaterValues[hwChan];
                    }
                }
            }
            catch (REBException e) {
                LOG.log(Level.SEVERE, "Error reading {0} {1}: {2}", new Object[]{this.name, item, e.getMessage()});
                this.checkErrorCount(e.getMessage());
            }
        }
        return value;
    }

    public double readChannelNow(int hwChan, int type) {
        double value = Double.NaN;
        if (this.online) {
            String item = "";
            try {
                switch (type) {
                    case 0: {
                        item = "board temperature";
                        value = this.tmp.readAdc(hwChan);
                        this.errorCount = 0;
                        break;
                    }
                    case 1: {
                        item = "board power";
                        value = this.pwr.readAdc(hwChan);
                        this.errorCount = 0;
                        break;
                    }
                    case 3: {
                        item = "aspic temperature";
                        value = this.slow.readAspicTemp(hwChan / 2, hwChan % 2);
                        this.errorCount = 0;
                        break;
                    }
                    case 6: {
                        item = "CCD voltage";
                        value = this.slow.readVoltageNow(hwChan);
                        this.errorCount = 0;
                        break;
                    }
                    default: {
                        value = super.readChannelNow(hwChan, type);
                        break;
                    }
                }
            }
            catch (REBException e) {
                LOG.log(Level.SEVERE, "Error reading {0} {1}: {2}", new Object[]{this.name, item, e.getMessage()});
                this.checkErrorCount(e.getMessage());
            }
        }
        return value;
    }

    public double[] readPowerAdcs() throws RaftException {
        try {
            return this.pwr.readAdcs();
        }
        catch (REBException e) {
            throw new RaftException(e.getMessage());
        }
    }

    public double[] readPowerAdcs(List<AdcData> dataList) throws RaftException {
        CCSTimeStamp tstamp = CCSTimeStamp.currentTime();
        double[] values = this.readPowerAdcs();
        if (dataList != null) {
            for (int chan = 0; chan < values.length; ++chan) {
                dataList.add(new AdcData(0, chan, values[chan], tstamp));
            }
        }
        return values;
    }

    public double[] readSlowAdcs(List<AdcData> dataList) throws RaftException {
        int adcType;
        int nAdc = this.rebType == 0 ? 18 : (this.rebType == 1 ? 14 : (this.rebType == 2 ? 10 : 0));
        double[] data = new double[nAdc];
        if (nAdc == 0) {
            return data;
        }
        int n = adcType = this.rebType == 0 ? 4 : 6;
        if (this.rebType != 0) {
            try {
                this.slow.fetchVoltages();
            }
            catch (REBException e) {
                throw new RaftException(e.getMessage());
            }
        }
        for (int adc = 0; adc < nAdc; ++adc) {
            data[adc] = this.readChannel(adcChans[adc], adcType);
            if (dataList == null) continue;
            dataList.add(new AdcData(1, adcChans[adc], data[adc], null));
        }
        return data;
    }

    public void readAllAdcs(List<AdcData> dataList) throws RaftException {
        this.readSlowAdcs(dataList);
        this.readPowerAdcs(dataList);
    }

    public static String getAdcName(int adc) {
        return adcNames[adc];
    }

    public int readSeqIdleState() throws RaftException {
        try {
            return this.seq.readIdleState();
        }
        catch (REBException e) {
            throw new RaftException(e.getMessage());
        }
    }

    public void writeSeqIdleState(int value) throws RaftException {
        try {
            this.seq.writeIdleState(value);
        }
        catch (REBException e) {
            throw new RaftException(e.getMessage());
        }
    }

    @Command(type=Command.CommandType.ACTION, description="Sets the REB configuration data")
    public void setREBConfig(@Argument(name="reb", description="REB configuration data") REB reb) throws RaftException {
        this.dacCtrl.setConfig(reb.getDacs());
        BiasDACS[] biasConfig = reb.getBiases();
        for (int j = 0; j < biasConfig.length; ++j) {
            BiasControl bias = this.biases[j];
            if (bias == null) continue;
            bias.setConfig(biasConfig[j]);
        }
        ASPIC[] aspicConfig = reb.getAspics();
        for (int j = 0; j < aspicConfig.length; ++j) {
            AspicControl aspic = this.aspics[j];
            if (aspic == null) continue;
            aspic.setConfig(aspicConfig[j]);
        }
    }

    @Command(type=Command.CommandType.QUERY, description="Gets the REB configuration data")
    public REB getREBConfig() {
        REB reb = new REB();
        reb.setId(this.id);
        reb.setIfcName(this.ifcName);
        reb.setCcdMask(this.realCcdMask);
        reb.setMaxCcdMask(this.realCcdMask);
        reb.setDacVersion(DacControl.getHwVersion(this.dac));
        reb.setDacRaw(this.dacRaw);
        reb.setBiasVersion(BiasControl.getHwVersion(this.dac));
        reb.setBiasRaw(this.biasRaw);
        reb.setAspicVersion(AspicControl.getHwVersion(this.asp));
        this.dacCtrl.getConfig(reb.getDacs());
        BiasDACS[] biasConfig = reb.getBiases();
        for (int j = 0; j < this.biases.length; ++j) {
            BiasControl bias = this.biases[j];
            if (bias == null) continue;
            biasConfig[j] = bias.getConfig();
        }
        ASPIC[] aspicConfig = reb.getAspics();
        for (int j = 0; j < this.aspics.length; ++j) {
            AspicControl aspic = this.aspics[j];
            if (aspic == null) continue;
            aspicConfig[j] = aspic.getConfig();
        }
        return reb;
    }

    @Command(type=Command.CommandType.CONFIGURATION, description="Set TM for all ASPICs on this REB")
    public void setAllAspicTM(boolean tm) {
        this.setAllAspic("tm", tm ? 1 : 0);
    }

    @Command(type=Command.CommandType.CONFIGURATION, description="Set gain for all ASPICs on this REB")
    public void setAllAspicGain(int gain) {
        this.setAllAspic("gain", gain);
    }

    @Command(type=Command.CommandType.CONFIGURATION, description="Set RC for all ASPICs on this REB")
    public void setAllAspicRc(int rc) {
        this.setAllAspic("rc", rc);
    }

    private void setAllAspic(String parmName, int val) {
        for (AspicControl aspic : this.aspics) {
            if (aspic == null) continue;
            this.subsys.getComponentConfigurationEnvironment((Object)aspic).submitChange(parmName, (Object)val);
        }
        this.sce.commitBulkChange();
    }

    @Command(type=Command.CommandType.ACTION, description="Perform CCD power on/off sequence")
    public void powerCCDs(@Argument(description="Whether to power on") boolean on) throws RaftException {
        if (on) {
            this.powerCCDsOn();
        } else {
            this.powerCCDsOff();
        }
    }

    @Command(type=Command.CommandType.ACTION, description="Perform CCD power on sequence")
    public void powerCCDsOn() throws RaftException {
        RaftException re = null;
        boolean all = true;
        boolean check = true;
        boolean odStep = true;
        boolean powerState = true;
        boolean underMask = false;
        ArrayList<AdcData> adcDataList = new ArrayList<AdcData>();
        this.readAllAdcs(adcDataList);
        try {
            if (this.sqp.isRunning()) {
                this.publishAllAdcData(adcDataList);
                throw new RaftException("Sequencer is running, it must be off to powerCCDsOn()");
            }
        }
        catch (REBException e) {
            throw new RaftException(e.getMessage());
        }
        try {
            powerState = this.getCCDsPowerState(adcDataList);
        }
        catch (RaftException e) {
            try {
                this.powerCCDsOff(adcDataList);
            }
            catch (RaftException raftException) {
                // empty catch block
            }
            this.publishAllAdcData(adcDataList);
            LOG.severe(String.format("powerCCDsOn() FAILED for %s", this.name));
            throw new RaftException(e.getMessage());
        }
        if (powerState) {
            this.publishAllAdcData(adcDataList);
            throw new RaftException("CCDs are already on, command aborted");
        }
        try {
            if (this.isITLManufacturedCCD()) {
                this.loadDacs(all, check, adcDataList);
                this.loadBiasDacs(all, check, odStep, adcDataList);
            } else {
                this.loadBiasDacs(all, check, odStep, adcDataList);
                this.loadDacs(all, check, adcDataList);
            }
        }
        catch (RaftException e) {
            re = e;
            try {
                this.powerCCDsOff(adcDataList);
            }
            catch (RaftException raftException) {
                // empty catch block
            }
        }
        this.publishAllAdcData(adcDataList);
        if (re != null) {
            throw re;
        }
        LOG.info(String.format("powerCCDsOn() success for %s", this.name));
    }

    @Command(type=Command.CommandType.ACTION, description="Perform CCD power off sequence")
    public void powerCCDsOff() throws RaftException {
        ArrayList<AdcData> adcDataList = new ArrayList<AdcData>();
        this.powerCCDsOff(adcDataList);
    }

    private void powerCCDsOff(List<AdcData> adcDataList) throws RaftException {
        boolean backBiasState = true;
        try {
            backBiasState = this.bss.isBackBiasOn();
        }
        catch (REBException e) {
            LOG.log(Level.SEVERE, "Error checking back bias for " + this.name, e);
        }
        this.setBackBias(false);
        if (backBiasState) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                LOG.log(Level.SEVERE, "Thread.sleep(100) interrupted after setBackBias(false) for " + this.name, e);
            }
        }
        if (this.isITLManufacturedCCD()) {
            this.clearBiasDacs(adcDataList);
            this.clearDacs(adcDataList);
        } else {
            this.clearDacs(adcDataList);
            this.clearBiasDacs(adcDataList);
        }
        this.publishAllAdcData(adcDataList);
        LOG.info(String.format("powerCCDsOff() finished for %s", this.name));
    }

    @Command(type=Command.CommandType.ACTION, description="Set CCD Clock lines to low state")
    public void setCCDClocksLow() throws RaftException {
        int seqState = this.readSeqIdleState();
        this.writeSeqIdleState(seqState & 0xFFFFF00F);
        LOG.info(String.format("setCCDClocksLow() finished for %s", this.name));
    }

    @Command(type=Command.CommandType.ACTION, description="Perform Test of CCD power state")
    public boolean getCCDsPowerState() throws RaftException {
        ArrayList<AdcData> adcDataList = new ArrayList<AdcData>();
        boolean result = this.getCCDsPowerState(adcDataList);
        this.publishAllAdcData(adcDataList);
        return result;
    }

    private boolean getCCDsPowerState(List<AdcData> adcDataList) throws RaftException {
        int nccds;
        int CCDsPowerState = -1;
        int onCnt = 0;
        int offCnt = 0;
        int testCntTot = 0;
        StringBuilder fcause = new StringBuilder();
        Object re = null;
        boolean seqLoaded = true;
        boolean failed = false;
        boolean testFailed = false;
        try {
            seqLoaded = this.sqp.isRunning() ? true : this.readSeqIdleState() != 0;
        }
        catch (REBException e) {
            throw new RaftException(e.getMessage());
        }
        double[] adcValues = this.readSlowAdcs(adcDataList);
        double[] curPower = this.readPowerAdcs(adcDataList);
        int n = this.rebType == 0 ? 3 : (this.rebType == 1 ? 2 : (nccds = this.rebType == 2 ? 1 : 0));
        int underSet = this.rebType == 0 ? 511 : (this.rebType == 1 ? 63 : (this.rebType == 2 ? 7 : 65535));
        try {
            int underMask = this.dac.getUnders();
            ++testCntTot;
            if (underMask == underSet) {
                LOG.info(String.format("%s: firmware protected biases test as OFF: 0x%x => %s", this.name, underMask, this.dac.getUndersString()));
                ++offCnt;
            } else if (underMask == 0) {
                LOG.info(String.format("%s: firmware protected biases test as ON: 0x%x => %s", this.name, underMask, this.dac.getUndersString()));
                ++onCnt;
            } else {
                LOG.warning(String.format("%s: firmware protection biases in mixed state: 0x%x => %s", this.name, underMask, this.dac.getUndersString()));
                LOG.severe(String.format("%s: CCDs in mixed or UNDEFINED power state", this.name));
                fcause.append(String.format("\n  %s: firmware protection biases in UNDEFINED state: 0x%x => %s", this.name, underMask, this.dac.getUndersString()));
                failed = true;
                testFailed = true;
            }
        }
        catch (REBException e) {
            fcause.append(String.format("\n  Could not get state of %s protection register: getUnders() FAILED\n", this.name));
            fcause.append(String.format("\n  %s\n", e.getMessage()));
            failed = true;
            testFailed = true;
        }
        LOG.info(String.format("Test %d: firmware protection %s", testCntTot, testFailed ? "FAILED" : "PASSED"));
        testFailed = false;
        ++testCntTot;
        if (curPower[7] < (double)nccds * this.odiQmax) {
            LOG.info(String.format("ODI current is nominal for CCDs OFF State: %.2f mA", curPower[7] * 1000.0));
            ++offCnt;
        } else if (curPower[7] > (double)nccds * this.odiAmin) {
            LOG.info(String.format("ODI current is nominal for CCDs ON State: %.2f mA", curPower[7] * 1000.0));
            ++onCnt;
        } else {
            LOG.severe(String.format("%s: CCDs in mixed or undefined power state: %.2f < (ODI = %.2f) < %.2f", this.name, (double)nccds * this.odiQmax * 1000.0, curPower[7] * 1000.0, (double)nccds * this.odiAmin * 1000.0));
            fcause.append(String.format("\n  %s: ODI current NOT in ON or OFF range", this.name));
            failed = true;
            testFailed = true;
        }
        LOG.info(String.format("Test %d: REB ODI current test %s", testCntTot, testFailed ? "FAILED" : "PASSED"));
        if (this.rebType == 0) {
            testFailed = false;
            ++testCntTot;
            if (curPower[9] < this.clkliQmax) {
                LOG.info(String.format("CLKLI current is nominal for CCDs OFF State %.2f mA", curPower[9] * 1000.0));
                ++offCnt;
            } else if (curPower[9] > this.clkliAmin) {
                LOG.info(String.format("CLKLI current is nominal for CCDs ON State %.2f mA", curPower[9] * 1000.0));
                ++onCnt;
            } else {
                LOG.severe(String.format("%s: CCDs in mixed or undefined power state: %.2f < (CLKLI = %.2f) < %.2f", this.name, this.clkliQmax * 1000.0, curPower[9] * 1000.0, this.clkliAmin * 1000.0));
                fcause.append(String.format("\n  %s: CLKLI current NOT in ON or OFF range", this.name));
                failed = true;
                testFailed = true;
            }
            LOG.info(String.format("Test %d: REB CLKLI current test %s", testCntTot, testFailed ? "FAILED" : "PASSED"));
            testFailed = false;
            ++testCntTot;
            if (curPower[5] < this.clkhiQmax) {
                LOG.info(String.format("CLKHI current is nominal for CCDs OFF State %.2f mA", curPower[5] * 1000.0));
                ++offCnt;
            } else if (curPower[5] > this.clkhiAmin) {
                LOG.info(String.format("CLKHI current is nominal for CCDs ON State %.2f mA", curPower[5] * 1000.0));
                ++onCnt;
            } else {
                LOG.severe(String.format("%s: CCDs in mixed or undefined power state: %.2f < (CLKHI = %.2f) < %.2f", this.name, this.clkhiQmax * 1000.0, curPower[5] * 1000.0, this.clkhiAmin * 1000.0));
                fcause.append(String.format("\n  %s: CLKHI current NOT in ON or OFF range", this.name));
                failed = true;
                testFailed = true;
            }
            LOG.info(String.format("Test %d: REB CLKHI current test %s", testCntTot, testFailed ? "FAILED" : "PASSED"));
        }
        testFailed = false;
        for (BiasControl bias : this.biases) {
            if (bias == null) continue;
            ++testCntTot;
            int biasDacState = bias.getBiasDacsPowerState(adcDataList, fcause);
            if (biasDacState == 0) {
                ++offCnt;
            } else if (biasDacState == 1) {
                ++onCnt;
            } else {
                LOG.severe(String.format("%s: CCDs Bias voltage test FAILED", this.name));
                fcause.append(String.format("\n  %s: CCDs Bias voltage test FAILED", this.name));
                failed = true;
                testFailed = true;
            }
            LOG.info(String.format("Test %d: Bias level test %s", testCntTot, testFailed ? "FAILED" : "PASSED"));
        }
        testFailed = false;
        ++testCntTot;
        double uClockDacOffset = seqLoaded ? 0.9 : 0.0;
        int clockDacState = this.dacCtrl.getClockDacsPowerState(adcDataList, fcause, uClockDacOffset);
        if (clockDacState == 0) {
            ++offCnt;
        } else if (clockDacState == 1) {
            ++onCnt;
        } else {
            LOG.severe(String.format("%s: CCDs clock voltage test FAILED", this.name));
            fcause.append(String.format("\n  %s: CCDs clock voltage test FAILED", this.name));
            failed = true;
            testFailed = true;
        }
        LOG.info(String.format("Test %d: Clock rails test %s", testCntTot, testFailed ? "FAILED" : "PASSED"));
        if (onCnt == testCntTot) {
            CCDsPowerState = 1;
        } else if (offCnt == testCntTot) {
            CCDsPowerState = 0;
        } else {
            LOG.severe(String.format("%s: getCCDsPowerState() FAILED: %d(%d) ON(OFF) of %d tests passed", this.name, onCnt, offCnt, testCntTot));
            fcause.append(String.format("\n  %s: getCCDsPowerState() FAILED: %d(%d) ON(OFF) of %d tests passed", this.name, onCnt, offCnt, testCntTot));
            failed = true;
        }
        if (failed) {
            LOG.severe(fcause.toString());
            throw new RaftException(fcause.toString());
        }
        return CCDsPowerState == 1;
    }

    @Command(type=Command.CommandType.ACTION, description="Perform CCD shorts test")
    public void testCCDShorts() throws RaftException {
        ArrayList<AdcData> adcDataList = new ArrayList<AdcData>();
        Object re = null;
        boolean failed = false;
        boolean powerState = true;
        int seqState = 0;
        try {
            if (this.sqp.isRunning()) {
                this.publishAllAdcData(adcDataList);
                throw new RaftException("Sequencer is running, it must be off to testCCDShorts()");
            }
            seqState = this.readSeqIdleState();
        }
        catch (REBException e) {
            throw new RaftException(e.getMessage());
        }
        try {
            powerState = this.getCCDsPowerState(adcDataList);
        }
        catch (RaftException e) {
            try {
                this.powerCCDsOff(adcDataList);
            }
            catch (RaftException raftException) {
                // empty catch block
            }
            this.publishAllAdcData(adcDataList);
            LOG.severe(String.format("testCCDShorts() FAILED for %s", this.name));
            throw new RaftException(e.getMessage());
        }
        if (powerState) {
            LOG.severe("testCCDShorts() called with CCDs on, aborting...");
            throw new RaftException("CCDs are on, testCCDShorts() aborted");
        }
        this.powerCCDsOff(adcDataList);
        this.writeSeqIdleState(seqState & 0xFFFFF00F);
        LOG.info(String.format("%s lowering sequencer clocks for shorts test: 0x%x --> 0x%x", this.name, seqState, this.readSeqIdleState()));
        try {
            Thread.sleep(200L);
        }
        catch (InterruptedException e) {
            LOG.log(Level.SEVERE, "Thread.sleep(200) interrupted after lowering sequencer clocks for " + this.name, e);
        }
        StringBuilder fcause = new StringBuilder();
        for (BiasControl bias : this.biases) {
            if (bias == null) continue;
            failed |= bias.testShorts(adcDataList, fcause);
            this.publishAllAdcData(adcDataList);
        }
        failed |= this.dacCtrl.testShorts(adcDataList, fcause);
        LOG.info(String.format("%s restoring sequencer clocks after shorts test: 0x%x --> 0x%x", this.name, this.readSeqIdleState(), seqState));
        this.writeSeqIdleState(seqState);
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException e) {
            LOG.log(Level.SEVERE, "Thread.sleep(100) interrupted after restoring sequencer clocks for " + this.name, e);
        }
        this.publishAllAdcData(adcDataList);
        if (failed) {
            throw new RaftException(this.name + " shorts test FAILED" + fcause.toString());
        }
        LOG.info("testCCDShorts() finished successfully");
    }

    private void publishAllAdcData(List<AdcData> adcDataList) {
        KeyValueDataList dataList = new KeyValueDataList();
        for (AdcData adcData : adcDataList) {
            String chanName = (adcData.type == 0 ? this.pwrChannelMap : this.sadcChannelMap).get(adcData.hwChan);
            if (chanName == null) continue;
            double conv = adcData.type == 0 && (adcData.hwChan & 1) != 0 ? 1000.0 : 1.0;
            dataList.addData(chanName, (Serializable)Double.valueOf(conv * adcData.value), adcData.timeStamp);
        }
        if (!dataList.getListOfKeyValueData().isEmpty()) {
            this.subsys.publishSubsystemDataOnStatusBus((KeyValueData)dataList);
        }
        adcDataList.clear();
    }

    @Command(type=Command.CommandType.ACTION, description="Loads configured DAC values")
    public int loadDacs(@Argument(description="Whether all DACs are loaded, or only changed ones") boolean all) throws RaftException {
        boolean powerState = true;
        ArrayList<AdcData> adcDataList = new ArrayList<AdcData>();
        this.readAllAdcs(adcDataList);
        try {
            powerState = this.getCCDsPowerState(adcDataList);
        }
        catch (RaftException e) {
            try {
                this.powerCCDsOff(adcDataList);
            }
            catch (RaftException raftException) {
                // empty catch block
            }
            this.publishAllAdcData(adcDataList);
            LOG.severe(String.format("loadDacs() FAILED for %s", this.name));
            throw new RaftException(e.getMessage());
        }
        this.publishAllAdcData(adcDataList);
        if (!powerState) {
            throw new RaftException("CCDs must be ON to use loadDacs() command, command aborted");
        }
        return this.loadDacs(all, false);
    }

    private int loadDacs(boolean all, boolean check) throws RaftException {
        ArrayList<AdcData> adcDataList = new ArrayList<AdcData>();
        int count = all ? this.dacCtrl.loadConfig(this.dacLoadDelay, check, adcDataList) : this.dacCtrl.loadChanged(this.dacLoadDelay, check, adcDataList);
        LOG.log(Level.INFO, "Loaded {0} {1} DACs", new Object[]{count, this.name});
        this.publishAllAdcData(adcDataList);
        return count;
    }

    private int loadDacs(boolean all, boolean check, List<AdcData> adcDataList) throws RaftException {
        int count = all ? this.dacCtrl.loadConfig(this.dacLoadDelay, check, adcDataList) : this.dacCtrl.loadChanged(this.dacLoadDelay, check, adcDataList);
        LOG.log(Level.INFO, "Loaded {0} {1} DACs", new Object[]{count, this.name});
        this.publishAllAdcData(adcDataList);
        return count;
    }

    private void clearDacs(List<AdcData> adcDataList) throws RaftException {
        this.dacCtrl.clear(this.dacClearDelay, adcDataList);
    }

    @Command(type=Command.CommandType.ACTION, description="Loads configured bias DAC values")
    public int loadBiasDacs(@Argument(description="Whether all DACs are loaded, or only changed ones") boolean all) throws RaftException {
        boolean powerState = true;
        ArrayList<AdcData> adcDataList = new ArrayList<AdcData>();
        this.readAllAdcs(adcDataList);
        try {
            powerState = this.getCCDsPowerState(adcDataList);
        }
        catch (RaftException e) {
            try {
                this.powerCCDsOff(adcDataList);
            }
            catch (RaftException raftException) {
                // empty catch block
            }
            this.publishAllAdcData(adcDataList);
            LOG.severe(String.format("loadBiasDacs() FAILED for %s", this.name));
            throw new RaftException(e.getMessage());
        }
        this.publishAllAdcData(adcDataList);
        if (!powerState) {
            throw new RaftException("CCDs must be ON to use loadBiasDacs command, command aborted");
        }
        return this.loadBiasDacs(all, false);
    }

    private int loadBiasDacs(boolean all, boolean check) throws RaftException {
        return this.loadBiasDacs(all, check, false);
    }

    private int loadBiasDacs(boolean all, boolean check, boolean odStep) throws RaftException {
        boolean count = false;
        ArrayList<AdcData> adcDataList = new ArrayList<AdcData>();
        return this.loadBiasDacs(all, check, false, adcDataList);
    }

    private int loadBiasDacs(boolean all, boolean check, boolean odStep, List<AdcData> adcDataList) throws RaftException {
        int count = 0;
        for (BiasControl bias : this.biases) {
            if (bias == null) continue;
            count += all ? bias.load(this.dacLoadDelay, check, odStep, adcDataList) : bias.loadChanged(this.dacLoadDelay, check, odStep, adcDataList);
            this.publishAllAdcData(adcDataList);
        }
        LOG.log(Level.INFO, "Loaded {0} {1} bias DACs", new Object[]{count, this.name});
        return count;
    }

    private void clearBiasDacs(List<AdcData> adcDataList) throws RaftException {
        for (BiasControl bias : this.biases) {
            if (bias == null) continue;
            bias.clear(this.dacClearDelay, adcDataList);
        }
    }

    @Command(type=Command.CommandType.ACTION, description="Load configuration data to the ASPICs")
    public int loadAspics(boolean all) throws Exception {
        int count = 0;
        for (AspicControl aspic : this.aspics) {
            if (aspic == null) continue;
            count += all ? aspic.load() : aspic.loadChanged();
        }
        LOG.log(Level.INFO, "Loaded {0} {1} ASPICs", new Object[]{count, this.name});
        return count;
    }

    @Command(type=Command.CommandType.ACTION, description="Reset the ASPICs")
    public int resetAspics() throws Exception {
        int count = 0;
        int mask = 0;
        for (AspicControl aspic : this.aspics) {
            int strip;
            if (aspic == null || (mask & 1 << (strip = aspic.getHwChan() / 2)) != 0) continue;
            count += aspic.reset();
            mask |= 1 << strip;
        }
        LOG.log(Level.INFO, "Reset {0} {1} ASPICs", new Object[]{count, this.name});
        return count;
    }

    @Command(type=Command.CommandType.ACTION, description="Check loaded ASPIC configuration")
    public int checkAspics() throws Exception {
        int mask = 0;
        int index = 0;
        for (AspicControl aspic : this.aspics) {
            if (aspic == null) continue;
            mask |= aspic.check() << index;
            index += 4;
        }
        return mask;
    }

    @Command(type=Command.CommandType.QUERY, description="Get the back bias on state")
    public boolean isBackBiasOn() throws RaftException {
        try {
            return this.bss.isBackBiasOn();
        }
        catch (REBException e) {
            LOG.log(Level.SEVERE, "Error getting back bias for" + this.name, e);
            return false;
        }
    }

    @Command(type=Command.CommandType.ACTION, description="Turn back bias on or off")
    public void setBackBias(@Argument(description="The on state") boolean value) throws RaftException {
        try {
            this.bss.setBackBias(value);
        }
        catch (REBException e) {
            throw new RaftException(e.getMessage());
        }
    }

    @Command(type=Command.CommandType.ACTION, description="Set heater voltage")
    public void setHeater(@Argument(description="Heater number") int heater, @Argument(description="The voltage") double volts) throws RaftException {
        double amps = volts / 14.8;
        this.heaterValues[0] = volts;
        this.heaterValues[1] = amps * amps * 14.5;
        int value = (int)((this.dac.getVersion() == 6 ? 409.5 : 409.5) * volts);
        try {
            this.dac.set(heater == 0 ? 18 : 21, value < 0 ? 0 : (value > 4095 ? 4095 : value), true);
        }
        catch (REBException e) {
            throw new RaftException(e.getMessage());
        }
    }

    @Command(type=Command.CommandType.ACTION, description="Set heater power")
    public void setHeaterPower(@Argument(description="Heater number") int heater, @Argument(description="The power value") double power) throws RaftException {
        this.setHeater(heater, 14.8 * Math.sqrt(power / 14.5));
    }

    @Command(type=Command.CommandType.ACTION, description="Sets the time base to the current system time")
    public void setTime() throws RaftException {
        try {
            this.bss.disable();
            this.bss.setTime();
            this.bss.enable();
        }
        catch (REBException e) {
            throw new RaftException(e.getMessage());
        }
    }

    @Command(type=Command.CommandType.QUERY, description="Gets the time base as Unix time")
    public long getTime() throws RaftException {
        try {
            return this.bss.getTime();
        }
        catch (REBException e) {
            return 0L;
        }
    }

    @Command(type=Command.CommandType.QUERY, description="Gets a trigger time as Unix time")
    public long getTime(@Argument(name="regset", description="Register set name") String rSet) throws RaftException {
        Integer regSet = rsetNames.get(rSet.toLowerCase());
        if (regSet == null) {
            throw new RaftException("Invalid register set name");
        }
        try {
            return this.bss.getTriggerTime(regSet.intValue());
        }
        catch (REBException e) {
            return 0L;
        }
    }

    @Command(type=Command.CommandType.ACTION, description="Sets the FITS file test conditions")
    public void setFitsConditions(@Argument(description="Filter name") String filter, @Argument(description="The temperature") double temperature, @Argument(description="The wavelength") double wavelength) {
        FitsHeaderKeywordData data = new FitsHeaderKeywordData(this.rebGeometry.getUniqueId());
        data.addHeaderKeywordValue("primary", "FilterName", (Serializable)((Object)filter), true);
        data.addHeaderKeywordValue("primary", "TemperatureSetPoint", (Serializable)Double.valueOf(temperature), true);
        data.addHeaderKeywordValue("primary", "MonochromatorWavelength", (Serializable)Double.valueOf(wavelength), true);
        this.subsys.publishSubsystemDataOnStatusBus(data.getKeyValueData());
    }

    @Command(type=Command.CommandType.QUERY, description="Get the DAQ metadata for the current image")
    public ImageMetadata getImageMetadata() throws RaftException {
        if (this.img == null) {
            throw new RuntimeException("This REB Device is not configured to process images");
        }
        return this.img.getImageMetadata();
    }

    @Command(type=Command.CommandType.QUERY, description="Gets a portion of the current image")
    public ImageData getImage(@Argument(description="Offset to the pixel data") int offset, @Argument(description="Number of pixels") int count) throws RaftException {
        if (this.img == null) {
            throw new RuntimeException("This REB Device is not configured to process images");
        }
        return this.img.getImage(0, offset, count);
    }

    @Command(type=Command.CommandType.QUERY, description="Gets a portion of the current image")
    public ImageData getImage(@Argument(description="CCD number") int ccd, @Argument(description="Offset to the pixel data") int offset, @Argument(description="Number of pixels") int count) throws RaftException {
        if (this.img == null) {
            throw new RuntimeException("This REB Device is not configured to process images");
        }
        return this.img.getImage(ccd, offset, count);
    }

    @Command(type=Command.CommandType.ACTION, description="Resets the front end")
    public void resetFrontEnd() throws RaftException {
        try {
            this.bss.reset(0);
            this.bss.enable();
            this.bss.setTime();
        }
        catch (REBException e) {
            throw new RaftException(e.getMessage());
        }
    }

    @Command(type=Command.CommandType.QUERY, description="Gets the contents of REB registers")
    public RegisterData getRegister(@Argument(description="Address of the first register") int address, @Argument(description="Number of registers to read") int count) throws RaftException {
        int[] values = new int[count];
        try {
            this.bss.read(address, values);
        }
        catch (REBException e) {
            throw new RaftException(e.getMessage());
        }
        return new RegisterData(address, count, values);
    }

    @Command(type=Command.CommandType.ACTION, description="Sets the contents of REB registers")
    public void setRegister(@Argument(description="Address of the first register") int address, @Argument(description="Values to write") int[] values) throws RaftException {
        try {
            this.bss.write(address, values);
        }
        catch (REBException e) {
            throw new RaftException(e.getMessage());
        }
    }

    @Command(type=Command.CommandType.QUERY, description="Gets the REB status block")
    public StatusData getRebStatus() throws RaftException {
        try {
            return new StatusData(this.sts.readStatus());
        }
        catch (REBException e) {
            return null;
        }
    }

    BoardDacs getBoardDacs() {
        return this.dac;
    }

    Aspic getAspic() {
        return this.asp;
    }

    public ImageProc getImageProc() {
        return this.img;
    }

    public SequencerProc getSequencer() {
        return this.sqp;
    }

    double getTempValue(int hwChan) {
        return this.online ? this.tempValues[hwChan] : 0.0;
    }

    double getPowerValue(int hwChan) {
        return this.online ? this.powerValues[hwChan] : 0.0;
    }

    @Command(simulation=true)
    public void simulateDisconnection() {
        this.setOnline(false);
    }

    private void checkErrorCount(String excpnText) {
        if (++this.errorCount > 4) {
            this.exceptionText = excpnText;
            this.exceptionCount = 1;
            this.setOnline(false);
        }
    }

    private void logExceptionCount() {
        if (this.exceptionCount > 1) {
            LOG.log(Level.INFO, "Previous {0} exception occurred {1} times", new Object[]{this.name, this.exceptionCount});
        }
    }

    protected void setOnline(boolean online) {
        super.setOnline(online);
        if (this.isOnline()) {
            this.stateService.updateAgentComponentState((Object)this, new Enum[]{RebDeviceState.ONLINE});
        } else {
            this.stateService.updateAgentComponentState((Object)this, new Enum[]{RebDeviceState.OFFLINE, RebValidationState.UNKNOWN, HVBiasState.UNKNOWN});
        }
    }

    boolean isITLManufacturedCCD() {
        return "itl".equalsIgnoreCase(this.getCcdType().getManufacturer());
    }

    static {
        hdwTypeMap.put("DAQ", 6);
        hdwTypeMap.put("DAQ0", 0);
        hdwTypeMap.put("DAQ1", 1);
        hdwTypeMap.put("DAQ2", 2);
        hdwTypeMap.put("DAQ4", 5);
        hdwTypeMap.put("PCI", 4);
        hdwTypeMap.put("PCI0", 3);
        hdwTypeMap.put("PCI1", 4);
        typeMap = new HashMap<String, Integer>();
        typeMap.put("TEMP", 0);
        typeMap.put("POWER", 1);
        typeMap.put("RTD", 2);
        typeMap.put("ATEMP", 3);
        typeMap.put("BIAS", 4);
        typeMap.put("CURR", 5);
        typeMap.put("CRVOLT", 6);
        typeMap.put("HEATER", 7);
        typeMap.put("HVSWCH", 8);
        adcChans = new int[18];
        REBDevice.adcChans[0] = 26;
        REBDevice.adcChans[1] = 27;
        REBDevice.adcChans[2] = 20;
        REBDevice.adcChans[3] = 21;
        REBDevice.adcChans[4] = 22;
        REBDevice.adcChans[5] = 23;
        REBDevice.adcChans[6] = 3;
        REBDevice.adcChans[7] = 0;
        REBDevice.adcChans[9] = 2;
        REBDevice.adcChans[8] = 1;
        REBDevice.adcChans[10] = 7;
        REBDevice.adcChans[11] = 4;
        REBDevice.adcChans[13] = 6;
        REBDevice.adcChans[12] = 5;
        REBDevice.adcChans[14] = 11;
        REBDevice.adcChans[15] = 8;
        REBDevice.adcChans[17] = 10;
        REBDevice.adcChans[16] = 9;
        adcNames = new String[18];
        REBDevice.adcNames[0] = "PclkLow";
        REBDevice.adcNames[1] = "PclkHigh";
        REBDevice.adcNames[2] = "SclkLow";
        REBDevice.adcNames[3] = "SclkHigh";
        REBDevice.adcNames[4] = "RGLow";
        REBDevice.adcNames[5] = "RGHigh";
        REBDevice.adcNames[6] = "GD0";
        REBDevice.adcNames[7] = "OD0";
        REBDevice.adcNames[8] = "OG0";
        REBDevice.adcNames[9] = "RD0";
        REBDevice.adcNames[10] = "GD1";
        REBDevice.adcNames[11] = "OD1";
        REBDevice.adcNames[12] = "OG1";
        REBDevice.adcNames[13] = "RD1";
        REBDevice.adcNames[14] = "GD2";
        REBDevice.adcNames[15] = "OD2";
        REBDevice.adcNames[16] = "OG2";
        REBDevice.adcNames[17] = "RD2";
        LOG = Logger.getLogger(REBDevice.class.getName());
        rsetNames = new HashMap<String, Integer>();
        rsetNames.put("stat", 0);
        rsetNames.put("time", 1);
        rsetNames.put("seq", 2);
        rsetNames.put("tadc", 4);
        rsetNames.put("padc", 3);
    }

    private static enum ChannelGroup {
        rebTemp,
        aspicTemp,
        boardPower,
        crVolt;

    }

    public static class AdcData {
        static final int TYPE_POWER = 0;
        static final int TYPE_SLOW = 1;
        final int type;
        final int hwChan;
        final double value;
        final CCSTimeStamp timeStamp;

        public AdcData(int type, int hwChan, double value, CCSTimeStamp timeStamp) {
            this.type = type;
            this.hwChan = hwChan;
            this.value = value;
            this.timeStamp = timeStamp == null ? CCSTimeStamp.currentTime() : timeStamp;
        }
    }
}

