/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.focalplane;

import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.imagenaming.ImageName;
import org.lsst.ccs.subsystem.focalplane.WebHooksConfig;

class WebHooks {
    private final WebHooksConfig config;
    private final ExecutorService executor;
    private static final Logger LOG = Logger.getLogger(WebHooks.class.getName());
    private static final Duration connectTimeout = Duration.ofSeconds(10L);

    WebHooks(ExecutorService executor, WebHooksConfig config) {
        this.config = config;
        this.executor = executor;
    }

    Future<List<Integer>> notifyNewImage(ImageName imageName) {
        return this.executor.submit(() -> {
            ArrayList<Integer> result = new ArrayList<Integer>();
            for (URL url : this.config.getURLS()) {
                try {
                    URLConnection conn = url.openConnection();
                    if (conn instanceof HttpURLConnection) {
                        HttpURLConnection http = (HttpURLConnection)conn;
                        http.setDoOutput(true);
                        http.addRequestProperty("Content-Type", "application/json");
                        http.addRequestProperty("User-Agent", "CCS focal-plane subsystem");
                        http.setRequestMethod("POST");
                        http.setConnectTimeout((int)connectTimeout.toMillis());
                        http.setReadTimeout((int)connectTimeout.toMillis());
                        http.connect();
                        try {
                            try (OutputStream out = http.getOutputStream();){
                                String json = "{\"image\":\"" + imageName + "\"}";
                                out.write(json.getBytes(StandardCharsets.UTF_8));
                            }
                            http.getInputStream().close();
                            result.add(http.getResponseCode());
                            continue;
                        }
                        finally {
                            http.disconnect();
                            continue;
                        }
                    }
                    throw new IOException("Invalid URL: " + url);
                }
                catch (IOException x) {
                    LOG.log(Level.WARNING, x, () -> String.format("Failed to invoke webhook at %s", url));
                    result.add(-99);
                }
            }
            return result;
        });
    }

    public static void main(String[] args) throws MalformedURLException, InterruptedException, ExecutionException {
        ExecutorService executor = Executors.newFixedThreadPool(1);
        WebHooksConfig config = new WebHooksConfig(new URL("https://tonyj321.requestcatcher.com/test"));
        WebHooks wh = new WebHooks(executor, config);
        Future<List<Integer>> notifyNewImage = wh.notifyNewImage(new ImageName("MC_C_20200621_000001"));
        System.out.println(notifyNewImage.get());
        executor.shutdown();
        executor.awaitTermination(30L, TimeUnit.SECONDS);
    }
}

