package org.lsst.ccs.subsystem.focalplane;

import org.lsst.ccs.imagenaming.ImageName;
import org.lsst.ccs.subsystem.focalplane.data.ImageMetaDataEvent;
import org.lsst.ccs.utilities.taitime.CCSTimeStamp;

/**
 * This class collects all of the data needed to send the focal-plane
 * ImageMetaDataEvent
 *
 * @author tonyj
 */
public class ImageMetaDataEventSender {

    private ImageName imageName;
    private double darkTime;
    // FIXME: Currently daqTag is not set. This should be obtained when the image is triggered,
    // but that functionality is not currently available from the REB driver.
    private String daqTag = "";
    private CCSTimeStamp lastClearTime;
    private CCSTimeStamp integrationStartTime;
    private CCSTimeStamp integrationEndTime;
    private final FocalPlaneSubsystem subsys;

    ImageMetaDataEventSender(FocalPlaneSubsystem subsys) {
        this.subsys = subsys;
    }
    
    void start(ImageName imageName) {
        this.imageName = imageName;
    }
    
    void send() {
        ImageMetaDataEvent event = new ImageMetaDataEvent(imageName, darkTime, daqTag, lastClearTime, integrationStartTime, integrationEndTime);
        subsys.sendEvent(ImageMetaDataEvent.EVENT_KEY, event);
    }

    void setDarkTime(double darkTime) {
        this.darkTime = darkTime;
    }

    void setClearTime(CCSTimeStamp lastClear) {
        this.lastClearTime = lastClear;
    }

    void setIntegrationStartTime(CCSTimeStamp startTime) {
        this.integrationStartTime = startTime;
    }

    void setObservationEndTime(CCSTimeStamp endTime) {
        this.integrationEndTime = endTime;
    }

}
