/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.focalplane;

import java.io.File;
import java.util.Map;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.config.ConfigurationBulkChangeHandler;

public class FocalPlaneConfig
implements ConfigurationBulkChangeHandler {
    @ConfigurationParameter(category="FitsHandling")
    private String FITSRootDirectory = System.getProperty("java.io.tmpdir");
    @ConfigurationParameter(category="FitsHandling")
    private String FITSDirectoryPattern = "${imageDate}/${imageName}";
    @ConfigurationParameter(category="FitsHandling")
    private String FITSFilePattern = "${imageName}_${raftName}_S${sensorLoc}.fits";
    @ConfigurationParameter(category="FitsHandling")
    private boolean FITSAutoSave = true;

    public String getFITSRootDirectory() {
        return this.FITSRootDirectory;
    }

    public String getFITSDirectoryPattern() {
        return this.FITSDirectoryPattern;
    }

    public String getFITSFilePattern() {
        return this.FITSFilePattern;
    }

    public boolean isFITSAutoSave() {
        return this.FITSAutoSave;
    }

    public void validateBulkChange(Map<String, Object> parametersView) {
        String dir = parametersView.get("FITSRootDirectory").toString();
        File dirFile = new File(dir);
        dirFile.mkdirs();
        if (!dirFile.isDirectory()) {
            throw new IllegalArgumentException("FITSRootDirectory: Not a directory");
        }
        if (!dirFile.canWrite()) {
            throw new IllegalArgumentException("FITSRootDirectory: Not writable");
        }
    }
}

