/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.focalplane;

import java.io.File;
import java.sql.SQLException;
import java.util.HashMap;
import org.junit.Assert;
import org.junit.Test;
import org.lsst.ccs.imagenaming.ImageName;
import org.lsst.ccs.subsystem.focalplane.AbortableCountDownLatch;
import org.lsst.ccs.subsystem.focalplane.ImageDatabase;
import org.lsst.ccs.subsystem.focalplane.ImageDatabaseService;
import org.lsst.ccs.subsystem.imagehandling.data.FileList;
import org.lsst.ccs.utilities.location.LocationSet;

public class ImageDatabaseTest {
    private String createConnection() {
        return "jdbc:h2:mem:test;MODE=MYSQL";
    }

    @Test
    public void testImageDatabase() throws SQLException {
        ImageDatabaseService idbs = ImageDatabaseService.testInstance((String)this.createConnection());
        try (ImageDatabase idb = idbs.getImageDatabase();){
            HashMap<String, Double> metaMap = new HashMap<String, Double>();
            metaMap.put("ExposureTime", 15.0);
            idb.addMetaData(metaMap);
            ImageName in = new ImageName("MC_C_20190610_001309");
            FileList fitsFiles = new FileList();
            AbortableCountDownLatch fitsFileCountDown = new AbortableCountDownLatch(1);
            idb.ingest(in, fitsFiles, fitsFileCountDown);
            fitsFiles.add((Object)new File("/abc"));
            fitsFileCountDown.countDown();
        }
    }

    @Test
    public void testRaftMaskFromLocations() {
        LocationSet locations = LocationSet.of((String[])new String[]{"R22,R44"});
        int raftMask = ImageDatabase.raftsMaskFromLocations((LocationSet)locations);
        Assert.assertEquals((long)0x1001000L, (long)raftMask);
    }
}

