package org.lsst.ccs.subsystem.focalplane;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

/**
 *
 * @author tonyj
 */
class AbortableCountDownLatch extends CountDownLatch {
    
    protected Exception abortException = null;

    public AbortableCountDownLatch(int size) {
        super(size);
    }

    /**
     * Unblocks all threads waiting on this latch and cause them to receive
     * an AbortedException. If the latch has already counted all the way
     * down, this method does nothing.
     */
    public void abort(Exception x) {
        if (getCount() == 0) {
            return;
        }
        this.abortException = x;
        while (getCount() > 0) {
            countDown();
        }
    }

    @Override
    public boolean await(long timeout, TimeUnit unit) throws InterruptedException {
        final boolean rtrn = super.await(timeout, unit);
        if (abortException != null) {
            throw new AbortedException(abortException);
        }
        return rtrn;
    }

    @Override
    public void await() throws InterruptedException {
        super.await();
        if (abortException != null) {
            throw new AbortedException(abortException);
        }
    }

    public static class AbortedException extends InterruptedException {

        public AbortedException(Exception cause) {
            super("Aborted due to exception");
            super.initCause(cause);
        }
    }
    
}
