/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.focalplane;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.monitor.Channel;
import org.lsst.ccs.monitor.DerivedChannel;

class RebTotalPower
extends DerivedChannel {
    private static final Logger LOG = Logger.getLogger(RebTotalPower.class.getName());
    @LookupField(strategy=LookupField.Strategy.TREE, pathFilter="(R\\d\\d)/(Reb\\d|Reb[WG])/Power")
    private List<Channel> rebPowerChannels = new ArrayList<Channel>();

    RebTotalPower() {
    }

    public void init() {
        LOG.log(Level.INFO, "Total Power calculation will use the power information from {0} rebs", new Object[]{this.rebPowerChannels.size()});
    }

    public double evaluateDerivedValue() {
        return this.calculateRebTotalPower();
    }

    double calculateRebTotalPower() {
        double totalPower = 0.0;
        for (Channel rebPowerChannel : this.rebPowerChannels) {
            double rebPower = rebPowerChannel.getValue();
            if (Double.isNaN(rebPower)) continue;
            totalPower += rebPower;
        }
        return totalPower;
    }
}

