/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.common;

import java.io.Serializable;
import java.time.Duration;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.services.AgentPeriodicTaskService;
import org.lsst.ccs.services.AgentPropertiesService;
import org.lsst.ccs.subsystem.common.data.BasicState;

public class BasicMain
extends Subsystem
implements HasLifecycle {
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentPropertiesService propertiesService;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentPeriodicTaskService periodicTaskService;
    private final String agentType;

    public BasicMain(String agentName, String agentType) {
        super(agentName, AgentInfo.AgentType.WORKER);
        this.agentType = agentType;
    }

    public void postInit() {
        this.propertiesService.setAgentProperty(this.agentType, ((Object)((Object)this)).getClass().getCanonicalName());
    }

    @Command(type=Command.CommandType.ACTION, description="Set the update period")
    public void setUpdatePeriod(@Argument(name="period", description="The tick period (msecs)") int period) {
        this.setTickPeriod(period);
        this.publishState();
    }

    @Command(type=Command.CommandType.QUERY, description="Get the full state")
    public BasicState getFullState() {
        return new BasicState(this.getTickPeriod());
    }

    private void setTickPeriod(long period) {
        this.periodicTaskService.setPeriodicTaskPeriod("monitor-publish", Duration.ofMillis(period));
    }

    private int getTickPeriod() {
        return (int)this.periodicTaskService.getPeriodicTaskPeriod("monitor-publish").toMillis();
    }

    private void publishState() {
        this.publishSubsystemDataOnStatusBus(new KeyValueData("BasicState", (Serializable)new BasicState(this.getTickPeriod())));
    }
}

