/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.focalplane;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.Agent;
import org.lsst.ccs.ConfigurationListener;
import org.lsst.ccs.ConfigurationService;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.data.AgentCategory;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.data.DataProviderInfo;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.description.ComponentLookup;
import org.lsst.ccs.description.ComponentNode;
import org.lsst.ccs.drivers.reb.REBException;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.imagenaming.service.ImageNameService;
import org.lsst.ccs.messaging.AgentPresenceListener;
import org.lsst.ccs.services.AgentCommandDictionaryService;
import org.lsst.ccs.services.AgentPropertiesService;
import org.lsst.ccs.services.AgentStateService;
import org.lsst.ccs.services.DataProviderDictionaryService;
import org.lsst.ccs.services.alert.AlertService;
import org.lsst.ccs.subsystem.common.actions.RebPowerAction;
import org.lsst.ccs.subsystem.common.focalplane.data.HasFocalPlaneData;
import org.lsst.ccs.subsystem.focalplane.CCDHardwareIdConfiguration;
import org.lsst.ccs.subsystem.focalplane.ConfigListener;
import org.lsst.ccs.subsystem.focalplane.FirmwareVersion;
import org.lsst.ccs.subsystem.focalplane.FocalPlaneCommands;
import org.lsst.ccs.subsystem.focalplane.FocalPlaneMetaDataCommands;
import org.lsst.ccs.subsystem.focalplane.HardwareIdConfiguration;
import org.lsst.ccs.subsystem.focalplane.ImageMessageHandling;
import org.lsst.ccs.subsystem.focalplane.LSE71Commands;
import org.lsst.ccs.subsystem.focalplane.ScriptingCommands;
import org.lsst.ccs.subsystem.focalplane.SequencerConfig;
import org.lsst.ccs.subsystem.focalplane.Sequencers;
import org.lsst.ccs.subsystem.focalplane.data.FocalPlaneDataGroup;
import org.lsst.ccs.subsystem.focalplane.states.FocalPlaneState;
import org.lsst.ccs.subsystem.rafts.GlobalProc;
import org.lsst.ccs.subsystem.rafts.REBDevice;
import org.lsst.ccs.subsystem.rafts.data.RaftException;
import org.lsst.ccs.subsystem.rafts.states.RebDeviceState;
import org.lsst.ccs.subsystem.rafts.states.RebValidationState;
import org.lsst.ccs.utilities.ccd.CCD;
import org.lsst.ccs.utilities.ccd.FocalPlane;
import org.lsst.ccs.utilities.ccd.Raft;
import org.lsst.ccs.utilities.ccd.Reb;

public class FocalPlaneSubsystem
extends Subsystem
implements HasLifecycle {
    @LookupField(strategy=LookupField.Strategy.DESCENDANTS)
    private final Map<String, REBDevice> rebDevices = new LinkedHashMap<String, REBDevice>();
    private Sequencers sequencers;
    private final FocalPlane focalPlaneGeometry;
    private ImageMessageHandling imageMessageHandling;
    private static final Logger LOG = Logger.getLogger(FocalPlaneSubsystem.class.getName());
    @LookupField(strategy=LookupField.Strategy.TREE)
    private GlobalProc globalProc;
    @LookupField(strategy=LookupField.Strategy.TREE)
    DataProviderDictionaryService dictionaryService;
    @LookupField(strategy=LookupField.Strategy.DESCENDANTS)
    private SequencerConfig sequencerConfig;
    @LookupField(strategy=LookupField.Strategy.DESCENDANTS)
    private ImageNameService imageNameService;
    @LookupField(strategy=LookupField.Strategy.DESCENDANTS)
    private ImageMessageHandling ImageMessageHandling;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentStateService agentStateService;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AlertService agentAlertService;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private ConfigurationService configService;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private Agent agent;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentPropertiesService agentPropertiesService;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentCommandDictionaryService agentCommandDictionaryService;
    private ComponentLookup lookupService;
    private long lastClear;

    public FocalPlaneSubsystem(FocalPlane geometry) {
        super("fp", AgentInfo.AgentType.WORKER);
        this.focalPlaneGeometry = geometry;
        this.getAgentInfo().getAgentProperties().setProperty("org.lsst.ccs.use.full.paths", "true");
    }

    public void build() {
        this.agentPropertiesService.setAgentProperty(HasFocalPlaneData.AGENT_PROPERTY, HasFocalPlaneData.generatePropertyValue(FocalPlaneDataGroup.class));
        this.agentPropertiesService.setAgentProperty("agentCategory", AgentCategory.FOCAL_PLANE.name());
        this.agentPropertiesService.setAgentProperty(RebPowerAction.class.getCanonicalName(), "uses");
        this.lookupService = this.agent.getComponentLookup();
        ComponentNode thisComponent = this.lookupService.getComponentNodeForObject((Object)this);
        this.imageMessageHandling = new ImageMessageHandling();
        ComponentNode imageMessageHandlingNode = new ComponentNode("imageMessageHandling", (Object)this.imageMessageHandling);
        this.lookupService.addComponentNodeToLookup(thisComponent, imageMessageHandlingNode);
        for (Raft r : this.focalPlaneGeometry.getChildrenList()) {
            ComponentNode raftNode = new ComponentNode(r.getName(), (Object)new HardwareIdConfiguration());
            this.lookupService.addComponentNodeToLookup(thisComponent, raftNode);
            for (Reb reb : r.getRebs()) {
                String rebName = r.getName() + "/" + reb.getName();
                ComponentNode rebHardwareNode = new ComponentNode(reb.getName() + "_hardware", (Object)new HardwareIdConfiguration());
                this.lookupService.addComponentNodeToLookup(raftNode, rebHardwareNode);
                ComponentNode rebComponent = this.lookupService.getNodeByPath(rebName);
                for (CCD ccd : reb.getCCDs()) {
                    String sensorName = ccd.getName();
                    ComponentNode sensorNode = new ComponentNode(sensorName, (Object)new CCDHardwareIdConfiguration());
                    this.lookupService.addComponentNodeToLookup(rebComponent, sensorNode);
                }
            }
        }
        this.agentStateService.registerState(FocalPlaneState.class, "The state of the Focal Plane", (Object)this);
    }

    public void postInit() {
        this.sequencers = new Sequencers(this, this.sequencerConfig);
        this.agentStateService.updateAgentState(new Enum[]{FocalPlaneState.NEEDS_CLEAR});
        this.rebDevices.forEach((rebName, device) -> {
            Reb reb = this.focalPlaneGeometry.getReb(rebName);
            device.setRebGeometry(reb);
            this.sequencers.add(reb, device.getSequencer());
        });
        this.agentStateService.addStateChangeListener((device, newState, oldState) -> {
            if (newState == RebValidationState.VALID) {
                REBDevice rebDevice = (REBDevice)device;
                String path = this.lookupService.getNameOfComponent(device);
                try {
                    FirmwareVersion version = new FirmwareVersion(rebDevice.getHwVersion());
                    LOG.log(Level.INFO, "Disabled LAM for firmware {0}", version);
                    try {
                        rebDevice.setRegister(23, new int[]{0});
                    }
                    catch (RaftException x) {
                        LOG.log(Level.SEVERE, "Could not disable LAM for " + rebDevice.getName(), x);
                    }
                    this.sequencers.load(this.focalPlaneGeometry.getReb(path), version);
                    Integer result = rebDevice.loadAspics(true);
                    LOG.log(Level.INFO, "Loaded aspics for {0} result {1}", new Object[]{rebDevice.getName(), result});
                }
                catch (Exception x) {
                    LOG.log(Level.WARNING, "Exception while loading ASPICS", x);
                }
            }
        }, new Class[]{RebDeviceState.class, RebValidationState.class});
        this.agentCommandDictionaryService.addCommandSetToObject((Object)new LSE71Commands(this), (Object)"");
        this.agentCommandDictionaryService.addCommandSetToObject((Object)new ScriptingCommands(this), (Object)"");
        this.agentCommandDictionaryService.addCommandSetToObject((Object)new FocalPlaneCommands(this), (Object)"");
        FocalPlaneMetaDataCommands metaDataCommands = new FocalPlaneMetaDataCommands((Agent)this, this.ImageMessageHandling);
        this.agentCommandDictionaryService.addCommandSetToObject((Object)metaDataCommands, (Object)"");
        this.agentStateService.addStateChangeListener((changedObj, newState, oldState) -> {
            if (newState == FocalPlaneState.QUIESCENT && (oldState == FocalPlaneState.CLEARING || oldState == FocalPlaneState.READING_OUT)) {
                this.lastClear = System.currentTimeMillis();
            } else if (newState == FocalPlaneState.READING_OUT) {
                double darkTime = (double)(System.currentTimeMillis() - this.lastClear) / 1000.0;
                LOG.log(Level.INFO, "Setting darktime to {0}", darkTime);
                metaDataCommands.setHeaderKeyword("DarkTime", Double.valueOf(darkTime));
            }
        }, new Class[]{FocalPlaneState.class});
        this.getMessagingAccess().getAgentPresenceManager().addAgentPresenceListener(new AgentPresenceListener(){

            public void connected(AgentInfo ... agents) {
                for (AgentInfo ai : agents) {
                    if (!ai.getAgentProperty("agentCategory", "").equals(AgentCategory.POWER.name())) continue;
                    LOG.log(Level.INFO, "Publishing raised alert summary for {0}", new Object[]{ai.getName()});
                    FocalPlaneSubsystem.this.getScheduler().execute(() -> FocalPlaneSubsystem.this.agentAlertService.publishRaisedAlertSummary());
                    break;
                }
            }
        });
    }

    public void preStart() {
        for (DataProviderInfo data : this.dictionaryService.getDataProviderDictionary().getDataProviderInfos()) {
            FocalPlaneDataGroup dataGroup = FocalPlaneDataGroup.findFocalPlaneDataGroup((DataProviderInfo)data);
            if (dataGroup == null) continue;
            dataGroup.addAttributesToDataInfo(data);
        }
    }

    public void postStart() {
        this.configService.addConfigurationListener((ConfigurationListener)new ConfigListener(this));
        this.loadSequencers();
    }

    void loadSequencers() {
        try {
            this.sequencers.load();
        }
        catch (REBException | RaftException x) {
            throw new RuntimeException("Error configuring sequencers", x);
        }
    }

    void loadASPICS() {
        for (REBDevice device : this.rebDevices.values()) {
            if (!device.isOnline() || !device.isSerialNumValid()) continue;
            try {
                Integer result = device.loadAspics(true);
                LOG.log(Level.INFO, "Loaded aspics for {0} result {1}", new Object[]{device.getFullName(), result});
            }
            catch (Exception ex) {
                LOG.log(Level.SEVERE, "Error while loading ASPICS", ex);
            }
        }
    }

    boolean isRebOnlineAndValid(Reb reb) {
        return this.stateService.isComponentInState(reb.getFullName(), (Enum)RebValidationState.VALID);
    }

    public Sequencers getSequencers() {
        return this.sequencers;
    }

    GlobalProc getGlobalProc() {
        return this.globalProc;
    }

    ImageNameService getImageNameService() {
        return this.imageNameService;
    }

    ImageMessageHandling getImageMessageHandling() {
        return this.imageMessageHandling;
    }

    Map<String, REBDevice> getRebDevices() {
        return this.rebDevices;
    }

    void loadSequencerParameters() {
        this.sequencers.loadSequencerParameters();
    }
}

