/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.focalplane;

import java.io.File;
import java.io.IOException;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.subsystem.focalplane.FocalPlaneConfig;
import org.lsst.ccs.subsystem.focalplane.FocalPlaneSubsystem;
import org.lsst.ccs.subsystem.focalplane.ScriptingCommands;
import org.lsst.ccs.subsystem.rafts.ImageProc;
import org.lsst.ccs.subsystem.rafts.data.RaftException;

class ImageHandling {
    private static final Logger LOG = Logger.getLogger(ImageHandling.class.getName());
    private final FocalPlaneSubsystem subsys;
    private final FocalPlaneConfig focalPlaneConfig;
    private AbortableCountDownLatch fitsFileCountDown;
    private AbortableCountDownLatch imageCountDown;
    private int nImageProc;
    private final ScriptingCommands.FileList fitsFiles = new ScriptingCommands.FileList();

    public ImageHandling(FocalPlaneSubsystem subsys, FocalPlaneConfig focalPlaneConfig) {
        this.subsys = subsys;
        this.focalPlaneConfig = focalPlaneConfig;
    }

    void addImageProc(ImageProc imageProc) {
        imageProc.addImageListener((proc, image) -> {
            try {
                this.imageCountDown.countDown();
                if (this.focalPlaneConfig.isFITSAutoSave()) {
                    proc.setFitsFileNamePattern(this.focalPlaneConfig.getFITSFilePattern());
                    List files = proc.saveFitsImage(this.focalPlaneConfig.getFITSRootDirectory() + File.separator + this.focalPlaneConfig.getFITSDirectoryPattern(), null, true);
                    LOG.log(Level.INFO, "Saved fits files {0}", files);
                    this.fitsFiles.addAll(files);
                    this.fitsFileCountDown.countDown();
                }
            }
            catch (IOException | RaftException ex) {
                LOG.log(Level.SEVERE, "Error saving fits file ", ex);
                this.imageCountDown.abort((Exception)ex);
                this.fitsFileCountDown.abort((Exception)ex);
            }
        });
        ++this.nImageProc;
    }

    void clearWait() {
        this.imageCountDown = new AbortableCountDownLatch(this.nImageProc);
        this.fitsFileCountDown = new AbortableCountDownLatch(this.nImageProc);
        this.fitsFiles.clear();
    }

    ScriptingCommands.FileList waitForFITSFiles(Duration timeout) throws InterruptedException, TimeoutException {
        if (this.fitsFileCountDown.await(timeout.toMillis(), TimeUnit.MILLISECONDS)) {
            return this.fitsFiles;
        }
        throw new TimeoutException("Timed out while waiting for FITS files");
    }

    void waitForImages(Duration timeout) throws TimeoutException, InterruptedException {
        if (!this.imageCountDown.await(timeout.toMillis(), TimeUnit.MILLISECONDS)) {
            throw new TimeoutException("Timed out while waiting for images");
        }
    }

    private static class AbortableCountDownLatch
    extends CountDownLatch {
        protected Exception abortException = null;

        public AbortableCountDownLatch(int count) {
            super(count);
        }

        public void abort(Exception x) {
            if (this.getCount() == 0L) {
                return;
            }
            this.abortException = x;
            while (this.getCount() > 0L) {
                this.countDown();
            }
        }

        @Override
        public boolean await(long timeout, TimeUnit unit) throws InterruptedException {
            boolean rtrn = super.await(timeout, unit);
            if (this.abortException != null) {
                throw new AbortedException(this.abortException);
            }
            return rtrn;
        }

        @Override
        public void await() throws InterruptedException {
            super.await();
            if (this.abortException != null) {
                throw new AbortedException(this.abortException);
            }
        }

        public static class AbortedException
        extends InterruptedException {
            public AbortedException(Exception cause) {
                super("Aborted due to exception");
                super.initCause(cause);
            }
        }
    }
}

