/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.utilities.dsp;

import java.util.Arrays;
import org.lsst.ccs.utilities.dsp.DigitalFilter;

public class BoxCarFilter
implements DigitalFilter {
    private static final long serialVersionUID = 6387011792246109318L;
    int flushed = -1;
    int sz;
    double[] history;
    double current;
    int ip;
    int n;

    public BoxCarFilter(int sz) {
        this.sz = sz;
        this.history = new double[sz];
        this.current = 0.0;
        this.n = 0;
    }

    @Override
    public void reset() {
        Arrays.fill(this.history, 0.0);
        this.ip = 0;
        this.current = 0.0;
        this.n = 0;
    }

    @Override
    public int getDelay() {
        return this.sz / 2;
    }

    @Override
    public double apply(double signal) {
        if (this.sz == 0) {
            return signal;
        }
        ++this.ip;
        if (this.ip >= this.sz) {
            this.ip = 0;
        }
        ++this.n;
        int used = this.n;
        if (used > this.sz) {
            used = this.sz;
        }
        if (this.n > this.sz) {
            this.current -= this.history[this.ip];
        }
        this.history[this.ip] = signal;
        this.current += signal;
        return this.current / (double)used;
    }

    @Override
    public double flush() {
        if (this.flushed == -1) {
            this.flushed = this.sz;
        }
        ++this.ip;
        if (this.ip >= this.sz) {
            this.ip = 0;
        }
        this.current -= this.history[this.ip];
        --this.flushed;
        if (this.flushed == 0) {
            throw new IllegalStateException();
        }
        System.out.println("flushed " + this.flushed + " " + this.history[this.ip] + " " + this.current / (double)this.flushed);
        return this.current / (double)this.flushed;
    }

    @Override
    public double freqResp(double freq) {
        return 0.0;
    }

    @Override
    public int getOrder() {
        return this.sz;
    }

    @Override
    public Object clone() {
        try {
            BoxCarFilter f = (BoxCarFilter)super.clone();
            f.history = new double[this.sz];
            return f;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public static void main(String[] args) {
        int i;
        int sz = 25;
        int n = 200;
        double[] result = new double[n];
        BoxCarFilter f = new BoxCarFilter(sz);
        int d = f.getDelay();
        for (i = 0; i < d; ++i) {
            f.apply(i);
        }
        for (i = 0; i < n - d; ++i) {
            result[i] = f.apply(i + d);
        }
        for (i = n - d; i < n; ++i) {
            result[i] = f.flush();
        }
        for (i = 0; i < n; ++i) {
            System.out.println(i + "   " + result[i]);
        }
    }
}

