/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.rafts;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.lsst.ccs.AlertService;
import org.lsst.ccs.ConfigurationService;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.data.Alert;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.bus.states.PhaseState;
import org.lsst.ccs.command.annotations.Argument;
import org.lsst.ccs.command.annotations.Command;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;
import org.lsst.ccs.commons.annotations.ConfigurationParameterChanger;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.config.ConfigurationBulkChangeHandler;
import org.lsst.ccs.daq.utilities.FitsHeaderKeywordData;
import org.lsst.ccs.daq.utilities.FitsService;
import org.lsst.ccs.description.ComponentLookup;
import org.lsst.ccs.description.ComponentNode;
import org.lsst.ccs.drivers.commons.DriverException;
import org.lsst.ccs.drivers.reb.Aspic;
import org.lsst.ccs.drivers.reb.BaseSet;
import org.lsst.ccs.drivers.reb.BoardDacs;
import org.lsst.ccs.drivers.reb.Cabac;
import org.lsst.ccs.drivers.reb.ClientFactory;
import org.lsst.ccs.drivers.reb.ImageClient;
import org.lsst.ccs.drivers.reb.ImageMetadata;
import org.lsst.ccs.drivers.reb.PowerAdcs;
import org.lsst.ccs.drivers.reb.REBException;
import org.lsst.ccs.drivers.reb.RegClient;
import org.lsst.ccs.drivers.reb.SlowAdcs;
import org.lsst.ccs.drivers.reb.StatusSet;
import org.lsst.ccs.drivers.reb.TempAdcs;
import org.lsst.ccs.drivers.reb.TempRtds;
import org.lsst.ccs.framework.ClearAlertHandler;
import org.lsst.ccs.monitor.Control;
import org.lsst.ccs.monitor.Device;
import org.lsst.ccs.monitor.MonitorLogUtils;
import org.lsst.ccs.services.AgentStateService;
import org.lsst.ccs.subsystem.rafts.AspicControl;
import org.lsst.ccs.subsystem.rafts.BiasControl;
import org.lsst.ccs.subsystem.rafts.CabacControl;
import org.lsst.ccs.subsystem.rafts.DacControl;
import org.lsst.ccs.subsystem.rafts.ImageProc;
import org.lsst.ccs.subsystem.rafts.SequencerProc;
import org.lsst.ccs.subsystem.rafts.alerts.RaftAlert;
import org.lsst.ccs.subsystem.rafts.config.ASPIC;
import org.lsst.ccs.subsystem.rafts.config.BiasDACS;
import org.lsst.ccs.subsystem.rafts.config.CABAC;
import org.lsst.ccs.subsystem.rafts.config.REB;
import org.lsst.ccs.subsystem.rafts.data.CcdType;
import org.lsst.ccs.subsystem.rafts.data.ImageData;
import org.lsst.ccs.subsystem.rafts.data.RaftException;
import org.lsst.ccs.subsystem.rafts.data.RegisterData;
import org.lsst.ccs.subsystem.rafts.data.StatusData;
import org.lsst.ccs.subsystem.rafts.states.RebDeviceState;
import org.lsst.ccs.subsystem.rafts.states.RebValidationState;
import org.lsst.ccs.utilities.logging.Logger;

public class REBDevice
extends Device
implements ClearAlertHandler,
ConfigurationBulkChangeHandler {
    private static final String SERIAL_NUM = "serialNum";
    public static final String RAFTS = "Rafts";
    public static final String RAFTS_LIMITS = "RaftsLimits";
    public static final int TYPE_BD_TEMP = 0;
    public static final int TYPE_BD_POWER = 1;
    public static final int TYPE_RTD = 2;
    public static final int TYPE_ASP_TEMP = 3;
    public static final int TYPE_BIAS_VOLT = 4;
    public static final int TYPE_CCD_CURR = 5;
    public static final int TYPE_CR_VOLT = 6;
    public static final int TYPE_HEATER = 7;
    public static final int TYPE_HV_SWITCH = 8;
    public static final int CHAN_TOTAL_POWER = -1;
    public static final int CHAN_HTR_VOLTS = 0;
    public static final int CHAN_HTR_POWER = 1;
    public static final int NUM_HTR_CHANS = 2;
    public static final int CHAN_RTD_INT_TEMP = 4;
    public static final int CHAN_RTD_INT_VOLT = 5;
    public static final int NUM_RTD_CHANS = 6;
    static final int REB_NUM_MASK = 3;
    static final int RAFT_NUM_MASK = 63;
    static final int RAFT_NUM_SHIFT = 2;
    static final int POWER_ON_DELAY = 200;
    static final int POWER_OFF_DELAY = 50;
    static final int DAC_LIMIT = 4095;
    static final double DAC_CONV = 819.0;
    static final double HTR_CONV = 409.5;
    static final double HTR_CONV_R5 = 409.5;
    static final double HEATER_OHMS = 14.5;
    static final double HTR_LEAD_OHMS = 0.3;
    private static final Map<String, Integer> hdwTypeMap = new HashMap<String, Integer>();
    private static final Map<String, Integer> typeMap;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private ConfigurationService sce;
    @LookupField(strategy=LookupField.Strategy.TOP)
    private Subsystem subsys;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AlertService alertService;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private AgentStateService stateService;
    @LookupField(strategy=LookupField.Strategy.CHILDREN)
    private FitsService fitsService;
    @ConfigurationParameter(name="serialNum", category="Rafts")
    private long serialNum;
    @ConfigurationParameter(category="Rafts", isFinal=true)
    private int id;
    @ConfigurationParameter(category="Rafts", isFinal=true)
    private String ifcName;
    protected CcdType ccdType = CcdType.NONE;
    private String hdwType = "daq2";
    private ClientFactory clientFactory = null;
    private int rebType = 0;
    private int ccdMask = 0;
    private int[] dataSegmentMap = null;
    private final Logger sLog = Logger.getLogger((String)((Object)((Object)this)).getClass().getPackage().getName());
    private final BaseSet bss = new BaseSet();
    private final StatusSet sts = new StatusSet(this.bss);
    private final TempAdcs tmp = new TempAdcs(this.bss);
    private final PowerAdcs pwr = new PowerAdcs(this.bss);
    private final SlowAdcs slow = new SlowAdcs(this.bss);
    private final TempRtds rtd = new TempRtds(this.bss);
    private final BoardDacs dac = new BoardDacs(this.bss);
    private final Aspic asp = new Aspic(this.bss);
    private final Cabac cbc = new Cabac(this.bss);
    private final ImageClient imc;
    private final BiasControl[] biases = new BiasControl[3];
    private final AspicControl[] aspics = new AspicControl[6];
    private final CabacControl[] cabacs = new CabacControl[6];
    private ImageProc img;
    private final SequencerProc seq = new SequencerProc(this.bss);
    private DacControl dacCtrl;
    private long hwSerialNum = 0L;
    private boolean serialNumValid = false;
    protected int hdwTypeI;
    protected int configCcdMask;
    protected int realCcdMask;
    protected int hwVersion;
    private int maxTemp;
    private int maxPower;
    private int maxAtemp;
    private int maxCcdI;
    private int numTemp;
    private int numPower;
    private int numAtemp;
    private int numCrVolt;
    private int numRtd;
    private boolean dacRaw;
    private boolean biasRaw;
    private double[] tempValues;
    private double[] powerValues;
    private double[] atempValues;
    private final double[] heaterValues = new double[2];
    private double heaterVolts;
    private int errorCount;
    private int dacLoadDelay = 0;
    private int dacClearDelay = 0;
    private static final Map<String, Integer> rsetNames;

    public REBDevice(int id, String ifcName, int ccdMask) {
        this("DAQ0", id, ifcName, ccdMask);
    }

    public REBDevice(String hdwType, int id, String ifcName, int ccdMask) {
        this(hdwType, id, ifcName, ccdMask, null);
    }

    public REBDevice(String hdwType, int id, String ifcName, int ccdMask, ClientFactory clientFactory) {
        this.imc = new ImageClient((RegClient)this.bss, "reb-" + id);
        this.img = new ImageProc(this.imc);
        if (clientFactory != null) {
            this.bss.setClientFactory(clientFactory);
            this.imc.setClientFactory(clientFactory);
            this.clientFactory = clientFactory;
        }
        this.setHdwType(hdwType);
        this.id = id;
        this.ifcName = ifcName;
        this.ccdMask = ccdMask;
    }

    public void build() {
        super.build();
        ComponentLookup lookupService = this.subsys.getComponentLookup();
        ComponentNode rebNode = lookupService.getComponentNodeForObject((Object)this);
        this.img = new ImageProc(this.imc);
        ComponentNode imageProcNode = new ComponentNode(rebNode, "imageProc", (Object)this.img);
        lookupService.addComponentNodeToLookup(rebNode, imageProcNode);
        this.img.setCcdMask(this.ccdMask);
        if (this.dataSegmentMap != null) {
            this.img.setDataSegmentMap(this.dataSegmentMap);
        }
        if (this.fitsService == null) {
            this.sLog.warn((Object)"No fits service is defined in groovy. For now using internal instance.");
            FitsService fitsSrvc = new FitsService();
            ComponentNode fitsServiceNode = new ComponentNode(rebNode, rebNode + "_fitsService", (Object)fitsSrvc);
            lookupService.addComponentNodeToLookup(rebNode, fitsServiceNode);
            fitsSrvc.setHeaderFilesList(Arrays.asList("primary", "extended", "Fits_primary_header.spec:primary"));
        }
    }

    @ConfigurationParameterChanger
    public final void setHdwType(String hdwType) {
        this.hdwType = hdwType;
        Integer type = hdwTypeMap.get(hdwType.toUpperCase());
        if (type == null) {
            MonitorLogUtils.reportConfigError((Logger)this.sLog, (String)this.name, (String)"hdwType", (String)"is invalid");
        }
        this.hdwTypeI = type;
    }

    public void validateBulkChange(Map<String, Object> params) {
        long sNum = (Long)params.get(SERIAL_NUM);
        if (this.hwSerialNum != 0L) {
            if (sNum != -1L && sNum != this.hwSerialNum) {
                ((AgentStateService)this.subsys.getAgentService(AgentStateService.class)).updateAgentComponentState((Object)this, new Enum[]{RebValidationState.INVALID});
                String msg = "Configuration has wrong REB s/n: " + sNum + ". " + this.fullName + " s/n is " + this.hwSerialNum;
                throw new IllegalArgumentException(msg);
            }
            this.serialNumValid = true;
            ((AgentStateService)this.subsys.getAgentService(AgentStateService.class)).updateAgentComponentState((Object)this, new Enum[]{RebValidationState.VALID});
        }
    }

    @Command(type=Command.CommandType.QUERY, description="Get the REB ID")
    public int getId() {
        return this.id;
    }

    @Command(type=Command.CommandType.QUERY, description="Get the network interface name")
    public String getIfcName() {
        return this.ifcName;
    }

    @Command(type=Command.CommandType.QUERY, description="Get the mask of CCDs being used")
    public int getCcdMask() {
        return this.realCcdMask;
    }

    public void setCcdType(CcdType ccdType) {
        this.ccdType = ccdType;
        this.dacLoadDelay = ccdType == CcdType.NONE ? 0 : 200;
        this.dacClearDelay = ccdType == CcdType.NONE ? 0 : 50;
    }

    @Command(type=Command.CommandType.QUERY, description="Get the type of CCDs being used")
    public CcdType getCcdType() {
        return this.ccdType;
    }

    public void setClientFactory(ClientFactory factory) {
        if (factory != null) {
            this.bss.setClientFactory(factory);
            this.imc.setClientFactory(factory);
        }
    }

    @Command(type=Command.CommandType.QUERY, description="Gets the REB type")
    public int getRebType() {
        return this.rebType;
    }

    @Command(type=Command.CommandType.QUERY, description="Gets the REB number")
    public int getRebNumber() {
        return this.id & 3;
    }

    @Command(type=Command.CommandType.QUERY, description="Gets the raft number")
    public int getRaftNumber() {
        return this.id >> 2 & 0x3F;
    }

    @Command(type=Command.CommandType.QUERY, description="Gets the hardware type")
    public int getHdwType() {
        return this.hdwTypeI;
    }

    @Command(type=Command.CommandType.QUERY, description="Get the hardware version")
    public int getHwVersion() {
        return this.hwVersion;
    }

    @Command(type=Command.CommandType.QUERY, description="Get the serial number")
    public long getSerialNumber() {
        return this.hwSerialNum;
    }

    public boolean isSerialNumValid() {
        return this.serialNumValid;
    }

    public ClearAlertHandler.ClearAlertCode canClearAlert(Alert alert) {
        if (alert.getAlertId().equals(RaftAlert.REB_NOT_CONNECTED.getAlertId())) {
            return ClearAlertHandler.ClearAlertCode.CLEAR_ALERT;
        }
        return ClearAlertHandler.ClearAlertCode.UNKWNOWN_ALERT;
    }

    protected void initDevice() {
        ((AgentStateService)this.subsys.getAgentService(AgentStateService.class)).registerState(RebDeviceState.class, "Reb Device ONLINE/OFFLINE State", (Object)this);
        ((AgentStateService)this.subsys.getAgentService(AgentStateService.class)).registerState(RebValidationState.class, "Reb Device Validation State", (Object)this);
        ((AgentStateService)this.subsys.getAgentService(AgentStateService.class)).updateAgentComponentState((Object)this, new Enum[]{RebDeviceState.OFFLINE});
        ((AgentStateService)this.subsys.getAgentService(AgentStateService.class)).updateAgentComponentState((Object)this, new Enum[]{RebValidationState.UNKNWONW});
        this.setClientFactory(this.clientFactory);
        this.img.configure(this.log);
        Integer type = hdwTypeMap.get(this.hdwType.toUpperCase());
        if (type == null) {
            MonitorLogUtils.reportConfigError((Logger)this.sLog, (String)this.name, (String)"hdwType", (String)"is invalid");
        }
        this.hdwTypeI = type;
        int biasMask = 0;
        int aspMask = 0;
        int aspicMask = 0;
        int cabMask = 0;
        int cabacMask = 0;
        for (Control ctrl : this.ctlChans.values()) {
            if (ctrl instanceof BiasControl) {
                biasMask |= 1 << ctrl.getHwChan();
                continue;
            }
            if (ctrl instanceof AspicControl) {
                aspMask |= 1 << ctrl.getHwChan();
                continue;
            }
            if (!(ctrl instanceof CabacControl)) continue;
            cabMask |= 1 << ctrl.getHwChan();
        }
        int j = 0;
        while (j < 3) {
            int pair = aspMask & 3;
            if (pair != 0) {
                if (pair == 3) {
                    aspicMask |= 1 << j;
                } else {
                    this.sLog.error((Object)("Unpaired configuration for ASPIC " + (2 * j + pair - 1) + " ignored"));
                }
            }
            ++j;
            aspMask >>= 2;
        }
        j = 0;
        while (j < 3) {
            int pair = cabMask & 3;
            if (pair != 0) {
                if (pair == 3) {
                    cabacMask |= 1 << j;
                } else {
                    this.sLog.error((Object)("Unpaired configuration for CABAC " + (2 * j + pair - 1) + " ignored"));
                }
            }
            ++j;
            cabMask >>= 2;
        }
        if (cabacMask != 0 && biasMask != 0) {
            this.sLog.error((Object)"Both bias and CABAC configurations defined");
        }
        if (cabacMask == 0 && biasMask == 0) {
            this.sLog.warning((Object)"No bias or CABAC configuration defined");
        }
        if (cabacMask != 0 && cabacMask != aspicMask) {
            this.sLog.warning((Object)"ASPIC and CABAC configurations don't match");
        }
        if (biasMask != 0 && biasMask != aspicMask) {
            this.sLog.warning((Object)"ASPIC and bias configurations don't match");
        }
        this.configCcdMask = biasMask | aspicMask | cabacMask;
        for (Control ctrl : this.ctlChans.values()) {
            if (ctrl instanceof DacControl) {
                this.dacCtrl = (DacControl)ctrl;
                continue;
            }
            if (ctrl instanceof BiasControl) {
                if ((1 << ctrl.getHwChan() & this.configCcdMask) == 0) continue;
                this.biases[ctrl.getHwChan()] = (BiasControl)ctrl;
                continue;
            }
            if (ctrl instanceof AspicControl) {
                if ((1 << ctrl.getHwChan() / 2 & this.configCcdMask) == 0) continue;
                this.aspics[ctrl.getHwChan()] = (AspicControl)ctrl;
                continue;
            }
            if (!(ctrl instanceof CabacControl) || (1 << ctrl.getHwChan() / 2 & this.configCcdMask) == 0) continue;
            this.cabacs[ctrl.getHwChan()] = (CabacControl)ctrl;
        }
        this.bss.setDefaultRebType(0);
        try {
            this.realCcdMask = this.configCcdMask & (1 << this.bss.getNumStrips()) - 1;
        }
        catch (REBException e) {
            this.sLog.error((Object)("Error getting expected CCD count: " + (Object)((Object)e)));
        }
        this.fullName = "REB " + this.id + (this.ifcName != null ? " (" + this.ifcName + ")" : "");
    }

    protected void initialize() {
        try {
            int j;
            this.bss.open(this.hdwTypeI, this.id, this.ifcName);
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.bss.disable();
            this.bss.setTime();
            this.bss.enable();
            this.rebType = this.bss.getRebType();
            this.hwVersion = this.bss.getHwVersion();
            this.maxTemp = this.tmp.getNumRegs();
            this.maxPower = this.pwr.getNumRegs();
            this.maxAtemp = this.slow.getNumAspicTemps();
            this.maxCcdI = this.slow.getNumCcdCurrents();
            this.numRtd = 0;
            this.numCrVolt = 0;
            this.numAtemp = 0;
            this.numPower = 0;
            this.numTemp = 0;
            this.tempValues = new double[this.maxTemp];
            this.powerValues = new double[this.maxPower];
            this.atempValues = new double[this.maxAtemp];
            this.realCcdMask = this.configCcdMask & (1 << this.bss.getNumStrips()) - 1;
            this.img.setCcdMask(this.realCcdMask);
            this.img.setNumRebCcds(this.bss.getNumStrips());
            this.img.setDataInversion(this.bss.getRebType() == 0);
            this.img.enableScan(this.seq.isScanEnabled());
            if (this.dacCtrl != null && !this.dacCtrl.checkConfig()) {
                this.dacCtrl = null;
            }
            this.dacRaw = this.dacCtrl != null ? this.dacCtrl.isRaw() : false;
            this.biasRaw = false;
            for (j = 0; j < this.biases.length; ++j) {
                BiasControl bias = this.biases[j];
                if (bias != null && !bias.checkConfig()) {
                    bias = null;
                }
                if (bias != null) {
                    this.biasRaw = bias.isRaw();
                }
                this.biases[j] = bias;
            }
            for (j = 0; j < this.aspics.length; ++j) {
                AspicControl aspic = this.aspics[j];
                if (aspic != null && !aspic.checkConfig()) {
                    aspic = null;
                }
                this.aspics[j] = aspic;
            }
            for (j = 0; j < this.cabacs.length; ++j) {
                CabacControl cabac = this.cabacs[j];
                if (cabac != null && !cabac.checkConfig()) {
                    cabac = null;
                }
                this.cabacs[j] = cabac;
            }
            try {
                this.hwSerialNum = this.bss.getRebSerial();
            }
            catch (REBException e) {
                this.sLog.error((Object)"Error reading serial number");
                this.hwSerialNum = -1L;
            }
            boolean bl = this.serialNumValid = this.serialNum == -1L || this.serialNum == this.hwSerialNum;
            if (!this.serialNumValid) {
                ((AgentStateService)this.subsys.getAgentService(AgentStateService.class)).updateAgentComponentState((Object)this, new Enum[]{RebValidationState.INVALID});
                this.sLog.error((Object)(this.name + " s/n (" + this.hwSerialNum + ") doesn't match configuration value (" + this.serialNum + ")"));
            } else {
                ((AgentStateService)this.subsys.getAgentService(AgentStateService.class)).updateAgentComponentState((Object)this, new Enum[]{RebValidationState.VALID});
            }
            this.errorCount = 0;
            this.initSensors();
            if (this.numRtd > 0) {
                this.rtd.initialize();
            }
            this.imc.open(this.hdwTypeI, this.id, this.ifcName);
            if (this.stateService.isInState((Enum)PhaseState.OPERATIONAL)) {
                this.publishCCDControllerSerialNumber();
            }
            this.setOnline(true);
            this.sLog.info((Object)("Connected to " + this.fullName));
            if (this.inited) {
                this.alertService.raiseAlert(RaftAlert.REB_NOT_CONNECTED.getAlert(), AlertState.NOMINAL, this.fullName + " is connected");
            }
        }
        catch (REBException e) {
            if (!this.inited) {
                this.sLog.error((Object)("Error connecting to " + this.fullName + ": " + (Object)((Object)e)));
                this.close("could not connect");
            }
            this.close(null);
        }
        this.inited = true;
    }

    public void postStart() {
        this.publishCCDControllerSerialNumber();
    }

    private void publishCCDControllerSerialNumber() {
        FitsHeaderKeywordData data = new FitsHeaderKeywordData(this.img.getRebGeometry().getUniqueId());
        data.addHeaderKeywordValue("primary", "CCDControllerSerial", (Serializable)((Object)String.format("%012x", this.hwSerialNum)), true);
        this.subsys.publishSubsystemDataOnStatusBus(data.getKeyValueData());
    }

    protected void close() {
        this.close("was disconnected");
    }

    private void close(String alertText) {
        try {
            this.rebType = -1;
            this.hwVersion = 0;
            this.hwSerialNum = 0L;
            this.bss.close();
        }
        catch (REBException rEBException) {
            // empty catch block
        }
        try {
            this.imc.close();
        }
        catch (REBException rEBException) {
            // empty catch block
        }
        if (alertText != null) {
            this.alertService.raiseAlert(RaftAlert.REB_NOT_CONNECTED.getAlert(), AlertState.ALARM, this.fullName + " " + alertText);
        }
    }

    protected int[] checkChannel(String name, int hwChan, String type, String subtype) throws Exception {
        Integer iType = typeMap.get(type.toUpperCase());
        if (iType == null) {
            MonitorLogUtils.reportError((Logger)this.sLog, (String)name, (String)"channel type", (Object)type);
        }
        return new int[]{iType, 0};
    }

    protected void initChannel(String name, int id, int hwChan, int type, int subtype) {
        try {
            boolean chanOk;
            if (type == 4 || type == 6) {
                chanOk = this.slow.testChannel(hwChan);
            } else {
                int maxChan = type == 0 ? this.maxTemp : (type == 1 ? this.maxPower : (type == 3 ? this.maxAtemp : (type == 5 ? this.maxCcdI : (type == 2 ? 6 : (type == 7 ? 2 : (type == 8 ? 1 : 0))))));
                boolean bl = chanOk = (hwChan >= 0 || type == 1) && hwChan < maxChan;
            }
            if (!chanOk) {
                MonitorLogUtils.reportError((Logger)this.sLog, (String)name, (String)"hw channel number", (Object)hwChan);
            }
            switch (type) {
                case 0: {
                    ++this.numTemp;
                    break;
                }
                case 1: {
                    ++this.numPower;
                    break;
                }
                case 3: {
                    ++this.numAtemp;
                    break;
                }
                case 6: {
                    ++this.numCrVolt;
                    break;
                }
                case 2: {
                    ++this.numRtd;
                }
            }
        }
        catch (Exception e) {
            this.dropChannel(id);
        }
    }

    protected void readChannelGroup() {
        if (!this.online) {
            return;
        }
        String item = "";
        try {
            int j;
            if (this.numTemp > 0) {
                try {
                    this.tempValues = this.tmp.readAdcs();
                }
                catch (REBException e) {
                    if (e.getMessage().contains("Completion wait")) {
                        for (j = 0; j < this.tempValues.length; ++j) {
                            this.tempValues[j] = Double.NaN;
                        }
                    }
                    item = "board temperatures";
                    throw e;
                }
            }
            if (this.numPower > 0) {
                try {
                    this.powerValues = this.pwr.readAdcs();
                }
                catch (REBException e) {
                    if (e.getMessage().contains("Completion wait")) {
                        for (j = 0; j < this.powerValues.length; ++j) {
                            this.powerValues[j] = Double.NaN;
                        }
                    }
                    item = "board power";
                    throw e;
                }
            }
            if (this.numAtemp > 0) {
                item = "aspic temperatures";
                this.atempValues = this.slow.readAspicTemps(0, this.maxAtemp);
            }
            if (this.numCrVolt > 0) {
                item = "CCD voltages";
                this.slow.fetchVoltages();
            }
            this.errorCount = 0;
        }
        catch (REBException e) {
            this.sLog.error((Object)("Error reading " + item + ": " + e.getMessage()));
            this.checkErrorCount();
        }
        double volts = this.heaterVolts;
        double amps = volts / 14.8;
        this.heaterValues[0] = volts;
        this.heaterValues[1] = amps * amps * 14.5;
    }

    protected double readChannel(int hwChan, int type) {
        double value = super.readChannel(hwChan, type);
        String item = "";
        try {
            switch (type) {
                case 5: {
                    item = "CCD current";
                    value = this.slow.readCurrent(hwChan);
                    this.errorCount = 0;
                    break;
                }
                case 4: 
                case 6: {
                    item = "CCD voltage";
                    value = this.slow.readVoltage(hwChan);
                    this.errorCount = 0;
                    break;
                }
                case 2: {
                    item = "RTD";
                    value = hwChan < 4 ? this.rtd.readTemperature(hwChan) : (hwChan == 4 ? this.rtd.readIntTemperature() : this.rtd.readIntVoltage());
                    this.errorCount = 0;
                    break;
                }
                case 8: {
                    item = "HV bias switch";
                    value = this.bss.isBackBiasOn() ? 1.0 : 0.0;
                    this.errorCount = 0;
                    break;
                }
                case 1: {
                    if (hwChan >= 0) {
                        value = this.powerValues[hwChan];
                        break;
                    }
                    value = 0.0;
                    for (int j = 0; j < this.powerValues.length; j += 2) {
                        value += this.powerValues[j] * this.powerValues[j + 1];
                    }
                    value += this.heaterValues[1];
                    break;
                }
                case 0: {
                    value = this.tempValues[hwChan];
                    break;
                }
                case 3: {
                    value = this.atempValues[hwChan];
                    break;
                }
                case 7: {
                    value = this.heaterValues[hwChan];
                }
            }
        }
        catch (DriverException e) {
            this.sLog.error((Object)("Error reading " + item + ": " + e.getMessage()));
            this.checkErrorCount();
        }
        return value;
    }

    public double readChannelNow(int hwChan, int type) {
        double value = Double.NaN;
        String item = "";
        try {
            switch (type) {
                case 0: {
                    item = "board temperature";
                    value = this.tmp.readAdc(hwChan);
                    this.errorCount = 0;
                    break;
                }
                case 1: {
                    item = "board power";
                    value = this.pwr.readAdc(hwChan);
                    this.errorCount = 0;
                    break;
                }
                case 3: {
                    item = "aspic temperature";
                    value = this.slow.readAspicTemp(hwChan / 2, hwChan % 2);
                    this.errorCount = 0;
                    break;
                }
                case 6: {
                    item = "CCD voltage";
                    value = this.slow.readVoltageNow(hwChan);
                    this.errorCount = 0;
                    break;
                }
                default: {
                    value = super.readChannelNow(hwChan, type);
                    break;
                }
            }
        }
        catch (DriverException e) {
            this.sLog.error((Object)("Error reading " + item + ": " + e.getMessage()));
            this.checkErrorCount();
        }
        return value;
    }

    @Command(type=Command.CommandType.ACTION, description="Sets the REB configuration data")
    public void setREBConfig(@Argument(name="reb", description="REB configuration data") REB reb) {
        this.dacCtrl.setConfig(reb.getDacs());
        BiasDACS[] biasConfig = reb.getBiases();
        for (int j = 0; j < biasConfig.length; ++j) {
            BiasControl bias = this.biases[j];
            if (bias == null) continue;
            bias.setConfig(biasConfig[j]);
        }
        ASPIC[] aspicConfig = reb.getAspics();
        for (int j = 0; j < aspicConfig.length; ++j) {
            AspicControl aspic = this.aspics[j];
            if (aspic == null) continue;
            aspic.setConfig(aspicConfig[j]);
        }
        CABAC[] cabacConfig = reb.getCabacs();
        for (int j = 0; j < cabacConfig.length; ++j) {
            CabacControl cabac = this.cabacs[j];
            if (cabac == null) continue;
            cabac.setConfig(cabacConfig[j]);
        }
    }

    @Command(type=Command.CommandType.QUERY, description="Gets the REB configuration data")
    public REB getREBConfig() {
        REB reb = new REB();
        reb.setId(this.id);
        reb.setIfcName(this.ifcName);
        reb.setCcdMask(this.realCcdMask);
        reb.setMaxCcdMask(this.realCcdMask);
        reb.setDacVersion(DacControl.getHwVersion(this.dac));
        reb.setDacRaw(this.dacRaw);
        reb.setBiasVersion(BiasControl.getHwVersion(this.dac));
        reb.setBiasRaw(this.biasRaw);
        reb.setAspicVersion(AspicControl.getHwVersion(this.asp));
        reb.setCabacVersion(CabacControl.getHwVersion(this.cbc));
        this.dacCtrl.getConfig(reb.getDacs());
        BiasDACS[] biasConfig = reb.getBiases();
        for (int j = 0; j < this.biases.length; ++j) {
            BiasControl bias = this.biases[j];
            if (bias == null) continue;
            biasConfig[j] = bias.getConfig();
        }
        ASPIC[] aspicConfig = reb.getAspics();
        for (int j = 0; j < this.aspics.length; ++j) {
            AspicControl aspic = this.aspics[j];
            if (aspic == null) continue;
            aspicConfig[j] = aspic.getConfig();
        }
        CABAC[] cabacConfig = reb.getCabacs();
        for (int j = 0; j < this.cabacs.length; ++j) {
            CabacControl cabac = this.cabacs[j];
            if (cabac == null) continue;
            cabacConfig[j] = cabac.getConfig();
        }
        return reb;
    }

    @Command(type=Command.CommandType.CONFIGURATION, description="Set TM for all ASPICs on this REB")
    public void setAllAspicTM(boolean tm) {
        this.setAllAspic("tm", tm ? 1 : 0);
    }

    @Deprecated
    @Command(type=Command.CommandType.CONFIGURATION, description="[Deprecated] transversal TM setting for all aspic controls for this reb")
    public void setAllTM(boolean tm) {
        this.setAllAspicTM(tm);
    }

    @Command(type=Command.CommandType.CONFIGURATION, description="Set gain for all ASPICs on this REB")
    public void setAllAspicGain(int gain) {
        this.setAllAspic("gain", gain);
    }

    @Deprecated
    @Command(type=Command.CommandType.CONFIGURATION, description="[Deprecated] transversal Gain setting for all aspic controls for this reb")
    public void setAllGain(int gain) {
        this.setAllAspicGain(gain);
    }

    @Command(type=Command.CommandType.CONFIGURATION, description="Set RC for all ASPICs on this REB")
    public void setAllAspicRc(int rc) {
        this.setAllAspic("rc", rc);
    }

    @Deprecated
    @Command(type=Command.CommandType.CONFIGURATION, description="[Deprecated] transversal Rc setting for all aspic controls for this reb")
    public void setAllRc(int rc) {
        this.setAllAspicRc(rc);
    }

    private void setAllAspic(String parmName, int val) {
        for (AspicControl aspic : this.aspics) {
            this.subsys.getComponentConfigurationEnvironment((Object)aspic).submitChange(parmName, (Object)val);
        }
        this.sce.commitBulkChange();
    }

    @Command(type=Command.CommandType.ACTION, description="Perform CCD power on/off sequence")
    public void powerCCDs(@Argument(description="Whether to power on") boolean on) throws Exception {
        if (on) {
            if (this.ccdType == CcdType.ITL) {
                this.loadDacs(true);
                this.loadBiasDacs(true);
            } else {
                this.loadBiasDacs(true);
                this.loadDacs(true);
            }
        } else {
            this.setBackBias(false);
            if (this.ccdType == CcdType.ITL) {
                this.clearBiasDacs();
                this.clearDacs();
            } else {
                this.clearDacs();
                this.clearBiasDacs();
            }
        }
    }

    @Command(type=Command.CommandType.ACTION, description="Loads configured DAC values")
    public int loadDacs(@Argument(description="Whether all DACs are loaded, or only changed ones") boolean all) throws Exception {
        int count = all ? this.dacCtrl.loadConfig(this.dacLoadDelay) : this.dacCtrl.loadChanged(this.dacLoadDelay);
        this.sLog.info((Object)("Loaded " + count + " " + this.name + " DACs"));
        return count;
    }

    @Command(type=Command.CommandType.ACTION, description="Clear DAC values")
    public void clearDacs() throws Exception {
        this.dacCtrl.clear(this.dacClearDelay);
    }

    @Command(type=Command.CommandType.ACTION, description="Loads configured bias DAC values")
    public int loadBiasDacs(@Argument(description="Whether all DACs are loaded, or only changed ones") boolean all) throws Exception {
        int count = 0;
        for (BiasControl bias : this.biases) {
            if (bias == null) continue;
            count += all ? bias.load(this.dacLoadDelay) : bias.loadChanged(this.dacLoadDelay);
        }
        this.sLog.info((Object)("Loaded " + count + " " + this.name + " bias DACs"));
        return count;
    }

    @Command(type=Command.CommandType.ACTION, description="Clear bias DAC values")
    public void clearBiasDacs() throws Exception {
        for (BiasControl bias : this.biases) {
            if (bias == null) continue;
            bias.clear(this.dacClearDelay);
        }
    }

    @Deprecated
    @Command(type=Command.CommandType.ACTION, description="[Deprecated] Loads configuration data to the CABACs")
    public int loadCabacs() throws Exception {
        int count = 0;
        try {
            if (this.cbc.getVersion() == 0) {
                for (int j = 0; j < this.cabacs.length; j += 2) {
                    if (this.cabacs[j] == null) continue;
                    int[] dataT = new int[22];
                    int[] dataB = new int[22];
                    int k = 0;
                    while (this.cabacs[j].getData(k, dataT) && this.cabacs[j + 1].getData(k, dataB)) {
                        this.cbc.set(0, dataT);
                        this.cbc.set(1, dataB);
                        this.cbc.load(j / 2);
                        ++k;
                    }
                    count += 2;
                }
            } else {
                for (CabacControl cabac : this.cabacs) {
                    if (cabac == null) continue;
                    count += cabac.load();
                }
            }
        }
        catch (REBException e) {
            this.checkTimeout((DriverException)((Object)e));
        }
        this.sLog.info((Object)("Loaded " + count + " " + this.name + " CABACs"));
        return count;
    }

    @Deprecated
    @Command(type=Command.CommandType.QUERY, description="[Deprecated] Checks loaded CABAC configuration data")
    public List<Integer> checkCabacs() throws Exception {
        try {
            ArrayList<Integer> diff = new ArrayList<Integer>();
            for (int j = 0; j < this.cabacs.length; j += 2) {
                if (this.cabacs[j] == null) continue;
                if (this.cbc.getVersion() == 0) {
                    this.cbc.fetch(j / 2);
                    diff.add(this.cabacs[j].compare(this.cbc.get(0)));
                    diff.add(this.cabacs[j + 1].compare(this.cbc.get(1)));
                    continue;
                }
                diff.add(this.cabacs[j].check());
                diff.add(this.cabacs[j + 1].check());
            }
            return diff;
        }
        catch (REBException e) {
            this.checkTimeout((DriverException)((Object)e));
            return null;
        }
    }

    @Deprecated
    @Command(type=Command.CommandType.ACTION, description="[Deprecated] Set the CABAC power enable bits")
    public void setCabacPower(@Argument(description="Enable bits") int enables) throws DriverException {
        this.cbc.setRegulator(enables);
    }

    @Deprecated
    @Command(type=Command.CommandType.QUERY, description="[Deprecated] Get the CABAC power enable bits")
    public int getCabacPower() {
        try {
            return this.cbc.getRegulator();
        }
        catch (DriverException e) {
            return -1;
        }
    }

    @Command(type=Command.CommandType.ACTION, description="Load configuration data to the ASPICs")
    public int loadAspics(boolean all) throws Exception {
        int count = 0;
        for (AspicControl aspic : this.aspics) {
            if (aspic == null) continue;
            count += all ? aspic.load() : aspic.loadChanged();
        }
        this.sLog.info((Object)("Loaded " + count + " " + this.name + " ASPICs"));
        return count;
    }

    @Command(type=Command.CommandType.ACTION, description="Reset the ASPICs")
    public int resetAspics() throws Exception {
        int count = 0;
        int mask = 0;
        for (AspicControl aspic : this.aspics) {
            int strip;
            if (aspic == null || (mask & 1 << (strip = aspic.getHwChan() / 2)) != 0) continue;
            count += aspic.reset();
            mask |= 1 << strip;
        }
        this.sLog.info((Object)("Reset " + count + " " + this.name + " ASPICs"));
        return count;
    }

    @Command(type=Command.CommandType.ACTION, description="Check loaded ASPIC configuration")
    public int checkAspics() throws Exception {
        int mask = 0;
        int index = 0;
        for (AspicControl aspic : this.aspics) {
            if (aspic == null) continue;
            mask |= aspic.check() << index;
            index += 4;
        }
        return mask;
    }

    @Command(type=Command.CommandType.QUERY, description="Get the back bias on state")
    public boolean isBackBiasOn() throws Exception {
        try {
            return this.bss.isBackBiasOn();
        }
        catch (REBException e) {
            this.checkTimeout((DriverException)((Object)e));
            return false;
        }
    }

    @Command(type=Command.CommandType.ACTION, description="Turn back bias on or off")
    public void setBackBias(@Argument(description="The on state") boolean value) throws Exception {
        try {
            this.bss.setBackBias(value);
        }
        catch (REBException e) {
            this.checkTimeout((DriverException)((Object)e));
        }
    }

    @Command(type=Command.CommandType.ACTION, description="Set heater voltage")
    public void setHeater(@Argument(description="Heater number") int heater, @Argument(description="The voltage") double volts) throws Exception {
        this.heaterVolts = volts;
        int value = (int)((this.dac.getVersion() == 6 ? 409.5 : 409.5) * volts);
        try {
            this.dac.set(heater == 0 ? 18 : 21, value < 0 ? 0 : (value > 4095 ? 4095 : value), true);
        }
        catch (REBException e) {
            this.checkTimeout((DriverException)((Object)e));
        }
    }

    @Command(type=Command.CommandType.ACTION, description="Set heater power")
    public void setHeaterPower(@Argument(description="Heater number") int heater, @Argument(description="The power value") double power) throws Exception {
        this.setHeater(heater, 14.8 * Math.sqrt(power / 14.5));
    }

    @Command(type=Command.CommandType.ACTION, description="Sets the time base to the current system time")
    public void setTime() throws Exception {
        try {
            this.bss.disable();
            this.bss.setTime();
            this.bss.enable();
        }
        catch (REBException e) {
            this.checkTimeout((DriverException)((Object)e));
        }
    }

    @Command(type=Command.CommandType.QUERY, description="Gets the time base as Unix time")
    public long getTime() throws Exception {
        try {
            return this.bss.getTime();
        }
        catch (REBException e) {
            this.checkTimeout((DriverException)((Object)e));
            return 0L;
        }
    }

    @Command(type=Command.CommandType.QUERY, description="Gets a trigger time as Unix time")
    public long getTime(@Argument(name="regset", description="Register set name") String rSet) throws Exception {
        Integer regSet = rsetNames.get(rSet.toLowerCase());
        if (regSet == null) {
            throw new RaftException("Invalid register set name");
        }
        try {
            return this.bss.getTriggerTime(regSet.intValue());
        }
        catch (REBException e) {
            this.checkTimeout((DriverException)((Object)e));
            return 0L;
        }
    }

    @Command(type=Command.CommandType.ACTION, description="Sets the FITS file test conditions")
    public void setFitsConditions(@Argument(description="Filter name") String filter, @Argument(description="The temperature") double temperature, @Argument(description="The wavelength") double wavelength) {
        FitsHeaderKeywordData data = new FitsHeaderKeywordData(this.img.getRebGeometry().getUniqueId());
        data.addHeaderKeywordValue("primary", "FilterName", (Serializable)((Object)filter), true);
        data.addHeaderKeywordValue("primary", "TemperatureSetPoint", (Serializable)Double.valueOf(temperature), true);
        data.addHeaderKeywordValue("primary", "MonochromatorWavelength", (Serializable)Double.valueOf(wavelength), true);
        this.subsys.publishSubsystemDataOnStatusBus(data.getKeyValueData());
    }

    @Command(type=Command.CommandType.QUERY, description="Get the DAQ metadata for the current image")
    public ImageMetadata getImageMetadata() throws RaftException {
        return this.img.getImageMetadata();
    }

    @Command(type=Command.CommandType.QUERY, description="Gets a portion of the current image")
    public ImageData getImage(@Argument(description="Offset to the pixel data") int offset, @Argument(description="Number of pixels") int count) throws RaftException {
        return this.img.getImage(0, offset, count);
    }

    @Command(type=Command.CommandType.QUERY, description="Gets a portion of the current image")
    public ImageData getImage(@Argument(description="CCD number") int ccd, @Argument(description="Offset to the pixel data") int offset, @Argument(description="Number of pixels") int count) throws RaftException {
        return this.img.getImage(ccd, offset, count);
    }

    @Command(type=Command.CommandType.ACTION, description="Resets the front end")
    public void resetFrontEnd() throws Exception {
        try {
            this.imc.resetFrontEnd();
            this.bss.enable();
            this.bss.setTime();
        }
        catch (REBException e) {
            this.checkTimeout((DriverException)((Object)e));
        }
    }

    @Command(type=Command.CommandType.QUERY, description="Gets the contents of REB registers")
    public RegisterData getRegister(@Argument(description="Address of the first register") int address, @Argument(description="Number of registers to read") int count) throws Exception {
        int[] values = new int[count];
        try {
            this.bss.read(address, values);
        }
        catch (REBException e) {
            this.checkTimeout((DriverException)((Object)e));
        }
        return new RegisterData(address, count, values);
    }

    @Command(type=Command.CommandType.ACTION, description="Sets the contents of REB registers")
    public void setRegister(@Argument(description="Address of the first register") int address, @Argument(description="Values to write") int[] values) throws Exception {
        try {
            this.bss.write(address, values);
        }
        catch (REBException e) {
            this.checkTimeout((DriverException)((Object)e));
        }
    }

    @Command(type=Command.CommandType.QUERY, description="Gets the REB status block")
    public StatusData getRebStatus() throws Exception {
        try {
            return new StatusData(this.sts.readStatus());
        }
        catch (REBException e) {
            this.checkTimeout((DriverException)((Object)e));
            return null;
        }
    }

    BoardDacs getBoardDacs() {
        return this.dac;
    }

    Aspic getAspic() {
        return this.asp;
    }

    Cabac getCabac() {
        return this.cbc;
    }

    public ImageProc getImageProc() {
        return this.img;
    }

    public SequencerProc getSequencer() {
        return this.seq;
    }

    void checkTimeout(DriverException e) throws Exception {
        this.checkTimeout((Exception)((Object)e), RaftException.class);
    }

    double getTempValue(int hwChan) {
        return this.online ? this.tempValues[hwChan] : 0.0;
    }

    double getPowerValue(int hwChan) {
        return this.online ? this.powerValues[hwChan] : 0.0;
    }

    @Command(simulation=true)
    public void simulateDisconnection() {
        this.setOnline(false);
    }

    private void checkErrorCount() {
        if (++this.errorCount > 4) {
            this.setOnline(false);
        }
    }

    protected void setOnline(boolean online) {
        super.setOnline(online);
        ((AgentStateService)this.subsys.getAgentService(AgentStateService.class)).updateAgentComponentState((Object)this, new Enum[]{this.isOnline() ? RebDeviceState.ONLINE : RebDeviceState.OFFLINE});
    }

    static {
        hdwTypeMap.put("DAQ0", 0);
        hdwTypeMap.put("DAQ1", 1);
        hdwTypeMap.put("DAQ2", 2);
        hdwTypeMap.put("PCI", 3);
        hdwTypeMap.put("PCI0", 3);
        hdwTypeMap.put("PCI1", 4);
        typeMap = new HashMap<String, Integer>();
        typeMap.put("TEMP", 0);
        typeMap.put("POWER", 1);
        typeMap.put("RTD", 2);
        typeMap.put("ATEMP", 3);
        typeMap.put("BIAS", 4);
        typeMap.put("CURR", 5);
        typeMap.put("CRVOLT", 6);
        typeMap.put("HEATER", 7);
        typeMap.put("HVSWCH", 8);
        rsetNames = new HashMap<String, Integer>();
        rsetNames.put("stat", 0);
        rsetNames.put("time", 1);
        rsetNames.put("seq", 2);
        rsetNames.put("tadc", 4);
        rsetNames.put("padc", 3);
    }
}

