/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.focalplane;

import java.io.IOException;
import java.io.InputStream;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;
import org.lsst.ccs.drivers.reb.REBException;
import org.lsst.ccs.subsystem.focalplane.FocalPlaneConfig;
import org.lsst.ccs.subsystem.focalplane.FocalPlaneSubsystem;
import org.lsst.ccs.subsystem.focalplane.LSE71Commands;
import org.lsst.ccs.subsystem.focalplane.states.FocalPlaneState;
import org.lsst.ccs.subsystem.rafts.SequencerProc;
import org.lsst.ccs.subsystem.rafts.data.RaftException;
import org.lsst.ccs.subsystem.rafts.data.SequencerData;
import org.lsst.ccs.subsystem.rafts.fpga.compiler.FPGA2Model;
import org.lsst.ccs.subsystem.rafts.fpga.compiler.FPGA2ModelBuilder;

public class Sequencers {
    private static final Logger LOG = Logger.getLogger(Sequencers.class.getName());
    private static final String CLEAR_MAIN = "Clear";
    private static final String INTEGRATE_MAIN = "Integrate";
    private static final String ROW_SHIFT_R_MAIN = "RowShiftR";
    private static final String ROW_SHIFT_F_MAIN = "RowShiftF";
    private static final String READ_MAIN = "Read";
    private static final String PSEUDO_READ_MAIN = "PsuedoRead";
    private static final String[] MAINS = new String[]{"Clear", "Integrate", "RowShiftR", "RowShiftF", "Read"};
    private static final String CLEAR_COUNT_PARAMETER = "ClearCount";
    private static final String SHIFT_COUNT_PARAMETER = "ShiftCount";
    private static final String[] PARAMETERS = new String[]{"ClearCount", "ShiftCount"};
    private final List<SequencerProc> REBs = new ArrayList<SequencerProc>();
    private String imageName;
    private final FocalPlaneSubsystem subsys;
    private final FocalPlaneConfig focalPlaneConfig;

    Sequencers(FocalPlaneSubsystem subsys, FocalPlaneConfig focalPlaneConfig) {
        this.subsys = subsys;
        this.focalPlaneConfig = focalPlaneConfig;
    }

    void add(SequencerProc seq) {
        this.REBs.add(seq);
    }

    public void clear(int nClears) throws REBException, RaftException {
        this.setMain(CLEAR_MAIN);
        this.setParameter(CLEAR_COUNT_PARAMETER, nClears);
        this.run(false, FocalPlaneState.READING_OUT);
    }

    public void startIntegration(String imageName) throws REBException, RaftException {
        this.imageName = imageName;
        this.setMain(INTEGRATE_MAIN);
        this.run(false, FocalPlaneState.INTEGRATING);
    }

    public void rowShift(int nRows) throws REBException, RaftException {
        if (nRows == 0) {
            return;
        }
        if (nRows > 0) {
            this.setMain(ROW_SHIFT_F_MAIN);
        } else {
            this.setMain(ROW_SHIFT_R_MAIN);
        }
        this.setParameter(SHIFT_COUNT_PARAMETER, Math.abs(nRows));
        this.run(false, FocalPlaneState.ROW_SHIFT);
    }

    public void stop() throws REBException {
        for (SequencerProc reb : this.REBs) {
            reb.sendStop();
        }
    }

    public void endIntegration(LSE71Commands.READOUT_MODE readout) throws REBException, RaftException {
        this.stop();
        this.waitForStop(Duration.ofSeconds(1L));
        switch (readout) {
            case TRUE: {
                this.setMain(READ_MAIN);
                this.run(true, FocalPlaneState.READING_OUT);
                break;
            }
            case PSEUDO: {
                this.setMain(PSEUDO_READ_MAIN);
                this.run(false, FocalPlaneState.READING_OUT);
                break;
            }
        }
    }

    private void setMain(String mainName) throws REBException, RaftException {
        for (SequencerProc reb : this.REBs) {
            reb.setStart(mainName);
        }
    }

    private void setParameter(String parameter, int value) throws REBException, RaftException {
        for (SequencerProc reb : this.REBs) {
            reb.setParameter(parameter, value);
        }
    }

    private void run(boolean acquire, FocalPlaneState stateOnSuccess) throws REBException {
        if (acquire) {
            this.subsys.getGlobalProc().acquireImage(this.imageName);
        } else {
            for (SequencerProc reb : this.REBs) {
                reb.startSequencer();
            }
        }
        this.setState(stateOnSuccess);
        this.doInBackground(() -> {
            try {
                this.waitForStop(Duration.ofMillis(1000000000L));
                this.setState(FocalPlaneState.QUIESCENT);
                LOG.info("Sequencers finished");
            }
            catch (REBException ex) {
                LOG.log(Level.SEVERE, "Error waiting for REBs", ex);
            }
        });
    }

    public void waitForStop(Duration timeout) throws REBException {
        for (SequencerProc reb : this.REBs) {
            reb.waitDone((int)timeout.toMillis());
            int errorAddr = reb.getErrorAddr();
            if (errorAddr == -1) continue;
            LOG.log(Level.SEVERE, "REB error register set {0}", errorAddr);
        }
    }

    private void sanityCheck(FPGA2Model model) throws RaftException, REBException {
        Map mainMap = model.getMainAddresses();
        for (String main : MAINS) {
            if (mainMap.get(main) != null) continue;
            throw new RaftException("Sequencer failed sanity check, missing main " + main);
        }
        List pointers = model.getPointers();
        for (String parameter : PARAMETERS) {
            boolean found = false;
            for (FPGA2Model.PointerInfo pointer : pointers) {
                if (!pointer.getName().equals(parameter)) continue;
                found = true;
                break;
            }
            if (found) continue;
            throw new RaftException("Sequencer failed sanity check, missing parameter " + parameter);
        }
        int[] registers = Sequencers.computeMetaDataRegisters(SequencerData.imageRegNames, model);
        if (this.subsys != null) {
            this.subsys.getGlobalProc().setRegisters(0, registers);
        }
    }

    static int[] computeMetaDataRegisters(String[] metaDataNames, FPGA2Model model) throws RaftException {
        int[] registers = new int[metaDataNames.length];
        Map pointerMap = model.getPointerMap();
        int k = 0;
        block4: for (String metaName : metaDataNames) {
            FPGA2Model.PointerInfo pi = (FPGA2Model.PointerInfo)pointerMap.get(metaName);
            if (pi != null) {
                switch (pi.getKind()) {
                    case REPEAT_FUNCTION: {
                        registers[k++] = pi.getAddress();
                        continue block4;
                    }
                    case REPEAT_SUBROUTINE: {
                        registers[k++] = pi.getAddress();
                        continue block4;
                    }
                    default: {
                        throw new RaftException("Parameter: " + metaName + " is of unsupported type " + pi.getKind());
                    }
                }
            }
            throw new RaftException("Required parameter not defined " + metaName);
        }
        return registers;
    }

    void load() throws RaftException, REBException {
        try {
            InputStream input = BootstrapResourceUtils.getBootstrapResource((String)this.focalPlaneConfig.getSequencer());
            FPGA2ModelBuilder builder = new FPGA2ModelBuilder();
            FPGA2Model model = builder.compileFile(input);
            this.sanityCheck(model);
            for (SequencerProc reb : this.REBs) {
                reb.loadSequencer(model);
            }
        }
        catch (IOException x) {
            RaftException re = new RaftException("Error reading sequencer ");
            re.initCause((Throwable)x);
            throw re;
        }
    }

    private void doInBackground(Runnable run) {
        Thread t = new Thread(run);
        t.setName("Sequencer wait thread");
        t.start();
    }

    private void setState(FocalPlaneState focalPlaneState) {
        if (this.subsys != null) {
            this.subsys.updateAgentState(new Enum[]{focalPlaneState});
        }
    }
}

