/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.focalplane;

import java.io.File;
import java.io.IOException;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.subsystem.focalplane.FocalPlaneConfig;
import org.lsst.ccs.subsystem.focalplane.FocalPlaneSubsystem;
import org.lsst.ccs.subsystem.focalplane.ScriptingCommands;
import org.lsst.ccs.subsystem.rafts.ImageProc;
import org.lsst.ccs.subsystem.rafts.data.RaftException;

class ImageHandling {
    private static final Logger LOG = Logger.getLogger(ImageHandling.class.getName());
    private final FocalPlaneSubsystem subsys;
    private final FocalPlaneConfig focalPlaneConfig;
    private CountDownLatch countDown;
    private int nImageProc;
    private final ScriptingCommands.FileList fitsFiles = new ScriptingCommands.FileList();

    public ImageHandling(FocalPlaneSubsystem subsys, FocalPlaneConfig focalPlaneConfig) {
        this.subsys = subsys;
        this.focalPlaneConfig = focalPlaneConfig;
    }

    void addImageProc(ImageProc imageProc) {
        imageProc.addImageListener((proc, image) -> {
            try {
                if (this.focalPlaneConfig.isFITSAutoSave()) {
                    proc.setFitsFileNamePattern(this.focalPlaneConfig.getFITSFilePattern());
                    List files = proc.saveFitsImage(this.focalPlaneConfig.getFITSRootDirectory() + File.separator + this.focalPlaneConfig.getFITSDirectoryPattern(), null, true);
                    LOG.log(Level.INFO, "Saved fits files {0}", files);
                    this.fitsFiles.addAll(files);
                    this.countDown.countDown();
                }
            }
            catch (IOException | RaftException ex) {
                LOG.log(Level.SEVERE, "Error saving fits file ", ex);
            }
        });
        ++this.nImageProc;
    }

    void clearWait() {
        this.countDown = new CountDownLatch(this.nImageProc);
        this.fitsFiles.clear();
    }

    ScriptingCommands.FileList waitForFITSFiles(Duration timeout) throws InterruptedException, TimeoutException {
        if (this.countDown.await(timeout.toMillis(), TimeUnit.MILLISECONDS)) {
            return this.fitsFiles;
        }
        throw new TimeoutException("Timed out while waiting for FITS files");
    }
}

