/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.focalplane;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.data.AgentCategory;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.data.DataProviderInfo;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.drivers.reb.REBException;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.imagenaming.service.ImageNameService;
import org.lsst.ccs.services.DataProviderDictionaryService;
import org.lsst.ccs.subsystem.focalplane.FocalPlaneConfig;
import org.lsst.ccs.subsystem.focalplane.ImageHandling;
import org.lsst.ccs.subsystem.focalplane.LSE71Commands;
import org.lsst.ccs.subsystem.focalplane.ScriptingCommands;
import org.lsst.ccs.subsystem.focalplane.Sequencers;
import org.lsst.ccs.subsystem.focalplane.data.FocalPlaneDataGroup;
import org.lsst.ccs.subsystem.focalplane.states.FocalPlaneState;
import org.lsst.ccs.subsystem.rafts.GlobalProc;
import org.lsst.ccs.subsystem.rafts.ImageProc;
import org.lsst.ccs.subsystem.rafts.REBDevice;
import org.lsst.ccs.subsystem.rafts.RaftsCommands;
import org.lsst.ccs.subsystem.rafts.data.RaftException;
import org.lsst.ccs.utilities.ccd.FocalPlane;
import org.lsst.ccs.utilities.ccd.Geometry;
import org.lsst.ccs.utilities.ccd.Raft;

public class FocalPlaneSubsystem
extends Subsystem
implements HasLifecycle {
    @LookupField(strategy=LookupField.Strategy.DESCENDANTS)
    private final Map<String, REBDevice> rebDevices = new HashMap<String, REBDevice>();
    private Sequencers sequencers;
    private final Map<String, RaftsCommands> raftsCommands = new HashMap<String, RaftsCommands>();
    private final FocalPlane focalPlaneGeometry;
    private ImageHandling imageHandling;
    @LookupField(strategy=LookupField.Strategy.TREE)
    private GlobalProc globalProc;
    @LookupField(strategy=LookupField.Strategy.TREE)
    DataProviderDictionaryService dictionaryService;
    @LookupField(strategy=LookupField.Strategy.DESCENDANTS)
    private FocalPlaneConfig focalPlaneConfig;
    @LookupField(strategy=LookupField.Strategy.DESCENDANTS)
    private ImageNameService imageNameService;

    public FocalPlaneSubsystem(FocalPlane geometry) {
        super("fp", AgentInfo.AgentType.WORKER);
        this.focalPlaneGeometry = geometry;
    }

    public void build() {
        this.setAgentProperty("org.lsst.ccs.use.full.paths", "true");
        this.setAgentProperty("agentCategory", AgentCategory.FOCAL_PLANE.name());
    }

    public void postInit() {
        this.sequencers = new Sequencers(this, this.focalPlaneConfig);
        this.imageHandling = new ImageHandling(this, this.focalPlaneConfig);
        this.updateAgentState(new Enum[]{FocalPlaneState.NEEDS_CLEAR});
        for (Raft raft : this.focalPlaneGeometry.getChildrenList()) {
            String raftName = raft.getName();
            ArrayList raftRebDevices = new ArrayList();
            this.rebDevices.forEach((rebName, device) -> {
                if (rebName.startsWith(raftName)) {
                    raftRebDevices.add(device);
                    this.sequencers.add(device.getSequencer());
                    ImageProc imageProc = device.getImageProc();
                    imageProc.setPatternProperty("raftName", raftName);
                    this.imageHandling.addImageProc(imageProc);
                }
            });
            RaftsCommands commands = new RaftsCommands((Subsystem)this, raftRebDevices, this.globalProc, (Geometry)raft, null);
            this.raftsCommands.put(raftName, commands);
            this.addCommandsFromObject(commands, raftName);
        }
        this.addCommandsFromObject(new LSE71Commands(this), "");
        this.addCommandsFromObject(new ScriptingCommands(this), "");
    }

    public void preStart() {
        for (DataProviderInfo data : this.dictionaryService.getDataProviderDictionary().getDataProviderInfos()) {
            FocalPlaneDataGroup dataGroup = FocalPlaneDataGroup.findFocalPlanDataGroup(data);
            if (dataGroup == null) continue;
            dataGroup.addAttributesToDataInfo(data);
        }
    }

    public void postStart() {
        try {
            this.sequencers.load();
        }
        catch (REBException | RaftException x) {
            throw new RuntimeException("Error configuring sequencers", x);
        }
    }

    public Sequencers getSequencers() {
        return this.sequencers;
    }

    GlobalProc getGlobalProc() {
        return this.globalProc;
    }

    ImageNameService getImageNameService() {
        return this.imageNameService;
    }

    ImageHandling getImageHandling() {
        return this.imageHandling;
    }
}

