/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.drivers.ascii;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.lsst.ccs.drivers.ascii.Ascii;
import org.lsst.ccs.drivers.commons.DriverConstants;
import org.lsst.ccs.drivers.commons.DriverException;

public class Multidrop {
    private static final Map<String, OpenDesc> openMap = new ConcurrentHashMap<String, OpenDesc>();
    private int defaultBaud = 0;
    private int defaultAddr = 0;
    private OpenDesc desc;
    private int timeout = 1000;
    private Ascii.Terminator cmndTerm = Ascii.Terminator.CRLF;
    private Ascii.Terminator respTerm = Ascii.Terminator.CRLF;
    protected int address;

    public void setOptions(Option option) {
    }

    public void setDefaultBaud(int baud) {
        this.defaultBaud = baud;
    }

    public void setDefaultAddress(int addr) {
        this.defaultAddr = addr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void open(ConnType type, String ident, int baudRate, int dataChar, int addr) throws DriverException {
        if (this.isOpen()) {
            throw new DriverException("Connection already open");
        }
        String key = type.name() + ":" + ident;
        OpenDesc newDesc = openMap.get(key);
        if (newDesc == null) {
            newDesc = new OpenDesc();
            newDesc.asc = new Ascii();
            newDesc.asc.setOptions(Ascii.Option.NO_NET);
            newDesc.asc.setMultidrop();
            openMap.put(key, newDesc);
        }
        OpenDesc openDesc = newDesc;
        synchronized (openDesc) {
            if (newDesc.addresses.size() <= 0) {
                DriverConstants.ConnType cType = type == ConnType.FTDI ? DriverConstants.ConnType.FTDI : DriverConstants.ConnType.SERIAL;
                newDesc.asc.open(cType, ident, baudRate == 0 ? this.defaultBaud : baudRate, dataChar);
                newDesc.asc.setTimeout(this.timeout);
                newDesc.asc.setCommandTerm(this.cmndTerm);
                newDesc.asc.setResponseTerm(this.respTerm);
            }
            int n = this.address = addr < 0 ? this.defaultAddr : addr;
            if (newDesc.addresses.contains(this.address)) {
                throw new DriverException("Device already in use");
            }
            newDesc.addresses.add(this.address);
        }
        this.desc = newDesc;
    }

    public void open(ConnType type, String ident, int baudRate, int addr) throws DriverException {
        this.open(type, ident, baudRate, 0, addr);
    }

    public void open(ConnType type, String ident, int addr) throws DriverException {
        this.open(type, ident, 0, 0, addr);
    }

    public void openSerial(String devcName, int baudRate, int dataChar, int addr) throws DriverException {
        this.open(ConnType.SERIAL, devcName, baudRate, dataChar, addr);
    }

    public void openSerial(String devcName, int baudRate, int addr) throws DriverException {
        this.openSerial(devcName, baudRate, 0, addr);
    }

    public void openSerial(String devcName, int addr) throws DriverException {
        this.openSerial(devcName, 0, addr);
    }

    public void openFtdi(String serialNo, int baudRate, int dataChar, int addr) throws DriverException {
        this.open(ConnType.FTDI, serialNo, baudRate, dataChar, addr);
    }

    public void openFtdi(String serialNo, int baudRate, int addr) throws DriverException {
        this.openFtdi(serialNo, baudRate, 0, addr);
    }

    public void openFtdi(String serialNo, int addr) throws DriverException {
        this.openFtdi(serialNo, 0, addr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close() throws DriverException {
        this.checkOpen();
        try {
            OpenDesc openDesc = this.desc;
            synchronized (openDesc) {
                this.desc.addresses.remove(this.address);
                if (this.desc.addresses.isEmpty()) {
                    this.desc.asc.close();
                }
            }
        }
        finally {
            this.desc = null;
        }
    }

    public boolean closeSilent() {
        try {
            this.close();
            return true;
        }
        catch (DriverException e) {
            return false;
        }
    }

    public boolean isOpen() {
        return this.desc != null;
    }

    public Boolean isDropEcho() {
        return this.desc == null ? null : this.desc.asc.isDropEcho();
    }

    public synchronized void write(String command) throws DriverException {
        this.checkOpen();
        this.desc.asc.write(command);
    }

    public synchronized String read() throws DriverException {
        this.checkOpen();
        return this.desc.asc.read();
    }

    public synchronized String read(String command) throws DriverException {
        this.checkOpen();
        return this.desc.asc.read(command);
    }

    public void writeBytes(byte[] command) throws DriverException {
        this.checkOpen();
        this.desc.asc.writeBytes(command);
    }

    public void writeBytes(byte[] command, int offset, int leng) throws DriverException {
        this.checkOpen();
        this.desc.asc.writeBytes(command, offset, leng);
    }

    public int readBytes(byte[] buff, int offset) throws DriverException {
        this.checkOpen();
        return this.desc.asc.readBytes(buff, offset);
    }

    public int readBytes(byte[] buff, int offset, int leng) throws DriverException {
        this.checkOpen();
        return this.desc.asc.readBytes(buff, offset, leng);
    }

    public synchronized void flush() throws DriverException {
        this.checkOpen();
        this.desc.asc.flush();
    }

    public void setResponseTerm(Ascii.Terminator term) {
        this.respTerm = term;
        if (this.isOpen()) {
            this.desc.asc.setResponseTerm(term);
        }
    }

    public void setCommandTerm(Ascii.Terminator term) {
        this.cmndTerm = term;
        if (this.isOpen()) {
            this.desc.asc.setCommandTerm(term);
        }
    }

    public void setTerminator(Ascii.Terminator term) {
        this.setCommandTerm(term);
        this.setResponseTerm(term);
    }

    public void setTimeout(double time) throws DriverException {
        this.setTimeout((int)(1000.0 * time));
    }

    public synchronized void setTimeout(int time) throws DriverException {
        this.timeout = time;
        if (this.isOpen()) {
            this.desc.asc.setTimeout(this.timeout);
        }
    }

    public int getTimeout() throws DriverException {
        return this.timeout;
    }

    public Object getSyncObject() {
        return this.desc.asc;
    }

    private void checkOpen() throws DriverException {
        if (!this.isOpen()) {
            throw new DriverException("Connection not open");
        }
    }

    public static enum Option {

    }

    public static enum ConnType {
        FTDI,
        SERIAL;

    }

    static class OpenDesc {
        Ascii asc;
        Set<Integer> addresses = new HashSet<Integer>();

        OpenDesc() {
        }
    }
}

