/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.imagehandling.data;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.lsst.ccs.bus.annotations.SkipEncoding;
import org.lsst.ccs.imagenaming.ImageName;
import org.lsst.ccs.subsystem.imagehandling.data.AdditionalFile;

@SkipEncoding
public class ECSVFile
extends AdditionalFile {
    private final List<Column> columns;
    private String delimiter = ",";
    private final String data;
    private Map<String, Serializable> meta;
    private static final long serialVersionUID = 1L;

    public ECSVFile(List<Column> columns, String data, String fileName, String fileType, ImageName obsId) {
        super(fileName, fileType, obsId);
        this.columns = columns;
        this.data = data;
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }

    public void addMetaData(Map<String, Serializable> meta) {
        this.meta = meta;
    }

    @Override
    public void writeFile(OutputStream out) throws IOException {
        LinkedHashMap<String, Object> yaml = new LinkedHashMap<String, Object>();
        LinkedHashMap<String, Object> header = new LinkedHashMap<String, Object>();
        header.put("fileName", this.getFileName());
        header.put("fileType", this.getFileType());
        header.put("obsId", this.getObsId().toString());
        if (this.meta != null) {
            header.putAll(this.meta);
        }
        yaml.put("datatype", this.columns);
        yaml.put("delimiter", this.delimiter);
        yaml.put("meta", header);
        try (PrintStream print = new PrintStream(out);){
            String line;
            print.println("# %ECSV 1.0");
            StringWriter writer = new StringWriter();
            ObjectMapper om = new ObjectMapper((JsonFactory)new YAMLFactory());
            om.writeValue((Writer)writer, yaml);
            writer.close();
            BufferedReader reader = new BufferedReader(new StringReader(writer.toString()));
            while ((line = reader.readLine()) != null) {
                print.print("# ");
                print.println(line);
            }
            print.println(this.columns.stream().map(Column::getName).collect(Collectors.joining(this.delimiter)));
            print.print(this.data);
        }
    }

    public static class Column
    implements Serializable {
        private final String name;
        private final String format;
        private final String datatype;
        private final String description;
        private final String units;
        private static final long serialVersionUID = 1L;

        public Column(String name, String format, String datatype, String description) {
            this(name, format, datatype, description, "unitless");
        }

        public Column(String name, String format, String datatype, String description, String units) {
            this.name = name;
            this.format = format;
            this.datatype = datatype;
            this.description = description;
            this.units = units;
        }

        public String getName() {
            return this.name;
        }

        public String getFormat() {
            return this.format;
        }

        public String getDatatype() {
            return this.datatype;
        }

        public String getDescription() {
            return this.description;
        }

        public String getUnits() {
            return this.units;
        }
    }

    public static class Header {
        private final String fileName;
        private final String fileType;
        private final String obsId;

        public Header(String fileName, String fileType, String obsId) {
            this.fileName = fileName;
            this.fileType = fileType;
            this.obsId = obsId;
        }

        public String getFileName() {
            return this.fileName;
        }

        public String getFileType() {
            return this.fileType;
        }

        public String getObsId() {
            return this.obsId;
        }
    }
}

