/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.rafts.alerts;

import org.lsst.ccs.bus.data.Alert;

public enum RaftAlert {
    ASPICS_TEMPERATURE_TOO_HIGH("AspicsHighTemp", "Alert for Aspics temperture too high"),
    ASPICS_TEMPERATURE_TOO_LOW("AspicsLowTemp", "Alert for Aspics temperture too low"),
    REB_BOARD_TEMPERATURE_TOO_HIGH("RebBoardHighTemp", "Alert for Reb Board temperture too high"),
    REB_BOARD_TEMPERATURE_TOO_LOW("RebBoardLowTemp", "Alert for Reb Board temperture too low"),
    REB_NOT_CONNECTED("RebNotConnected", "Alert raised when a REB is not connected");

    private final String id;
    private final String description;

    private RaftAlert(String id, String description) {
        this.id = id;
        this.description = description;
    }

    public String getAlertId() {
        return this.id;
    }

    public String getDescription() {
        return this.description;
    }

    public Alert getAlert() {
        return this.getAlert(null);
    }

    public Alert getAlert(String path) {
        Object aId = null;
        aId = path != null && !path.isEmpty() ? this.id + "/" + path : this.id;
        return new Alert((String)aId, this.description);
    }
}

