/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.common.ui.focalplane.view;

import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Point;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import org.freehep.swing.popup.HasPopupItems;
import org.lsst.ccs.gconsole.annotations.services.persist.Create;
import org.lsst.ccs.gconsole.base.Console;
import org.lsst.ccs.gconsole.base.filter.AgentChannelsFilter;
import org.lsst.ccs.gconsole.services.persist.Persistable;
import org.lsst.ccs.gconsole.services.persist.PersistenceService;
import org.lsst.ccs.subsystem.common.ui.focalplane.filter.FocalPlaneFilter;
import org.lsst.ccs.subsystem.common.ui.focalplane.view.FocalPlaneView;
import org.lsst.ccs.subsystem.common.ui.focalplane.view.MapView;

public class MultiMapView
implements FocalPlaneView {
    private final Descriptor descriptor;
    private FocalPlaneFilter filter;
    private Page page;
    private ArrayList<MapView> views;

    public MultiMapView() {
        this(1, 1);
    }

    @Create(category="FocalPlaneView", name="Focal plane multi-region map", path="Built-In/Map/Multi-Region", description="A view that contains a grid of focal plane maps.")
    public MultiMapView(int rows, int columns) {
        this.descriptor = new Descriptor();
        this.descriptor.setRows(rows);
        this.descriptor.setColumns(columns);
    }

    public MultiMapView(Descriptor descriptor) {
        this.descriptor = descriptor.clone();
    }

    @Override
    public FocalPlaneFilter getFilter() {
        return this.filter;
    }

    public void setFilter(AgentChannelsFilter filter) {
        this.filter = (FocalPlaneFilter)filter;
    }

    public JComponent getPanel() {
        if (this.page == null) {
            this.page = new Page();
        }
        return this.page;
    }

    public void install() {
        this.getPanel();
        if (this.views != null) {
            for (MapView v : this.views) {
                if (v == null) continue;
                v.install();
            }
        }
    }

    public void uninstall() {
        if (this.views != null) {
            for (MapView v : this.views) {
                if (v == null) continue;
                v.uninstall();
            }
        }
    }

    public Descriptor getDescriptor() {
        return this.descriptor;
    }

    public Descriptor save() {
        Descriptor desc = this.descriptor.clone();
        if (this.views != null) {
            int n = desc.getRows() * desc.getColumns();
            MapView.Descriptor[] vd = new MapView.Descriptor[n];
            for (int i = 0; i < n; ++i) {
                MapView v = this.views.get(i);
                if (v == null) continue;
                vd[i] = (MapView.Descriptor)v.save();
            }
            desc.setViews(vd);
        }
        return desc;
    }

    public static class Descriptor
    extends FocalPlaneView.Descriptor {
        private int rows = 1;
        private int columns = 1;
        private MapView.Descriptor[] views;

        public int getRows() {
            return this.rows;
        }

        public void setRows(int rows) {
            this.rows = rows;
        }

        public int getColumns() {
            return this.columns;
        }

        public void setColumns(int columns) {
            this.columns = columns;
        }

        public MapView.Descriptor[] getViews() {
            return this.views;
        }

        public void setViews(MapView.Descriptor[] views) {
            this.views = views;
        }

        public Descriptor clone() {
            Descriptor desc = (Descriptor)super.clone();
            if (this.views != null) {
                int n = this.views.length;
                desc.views = new MapView.Descriptor[n];
                for (int i = 0; i < n; ++i) {
                    MapView.Descriptor d = this.views[i];
                    desc.views[i] = d == null ? null : d.clone();
                }
            }
            return desc;
        }
    }

    final class Page
    extends JPanel
    implements HasPopupItems {
        Page() {
            this.setLayout(new GridLayout(MultiMapView.this.descriptor.getRows(), MultiMapView.this.descriptor.getColumns(), 10, 5));
            PersistenceService service = (PersistenceService)Console.getConsole().getSingleton(PersistenceService.class);
            MapView.Descriptor[] regionDescriptors = MultiMapView.this.descriptor.getViews();
            int n = MultiMapView.this.descriptor.getRows() * MultiMapView.this.descriptor.getColumns();
            MultiMapView.this.views = new ArrayList(n);
            for (int i = 0; i < n; ++i) {
                MapView.Descriptor regionDesc;
                MapView.Descriptor descriptor = regionDesc = regionDescriptors == null ? null : regionDescriptors[i];
                if (regionDesc == null) {
                    regionDesc = new MapView.Descriptor();
                }
                MapView view = (MapView)service.make((Persistable.Descriptor)regionDesc);
                if (MultiMapView.this.filter != null && view.getFilter() == null) {
                    view.setFilter((AgentChannelsFilter)MultiMapView.this.filter);
                }
                MultiMapView.this.views.add(view);
                this.add(view.getPanel());
            }
        }

        public JPopupMenu modifyPopupMenu(JPopupMenu menu, Component component, Point point) {
            Component c = this.getComponentAt(point);
            if (c instanceof HasPopupItems) {
                ((HasPopupItems)c).modifyPopupMenu(menu, component, point);
            }
            return menu;
        }
    }
}

