/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.plugins.monitor;

import java.awt.BorderLayout;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.function.Function;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.gconsole.base.filter.PageFilter;
import org.lsst.ccs.gconsole.plugins.monitor.AbstractMonitorView;
import org.lsst.ccs.gconsole.plugins.monitor.MonitorDisplay;
import org.lsst.ccs.gconsole.plugins.monitor.TreeView;
import org.lsst.ccs.gconsole.services.aggregator.AgentChannel;
import org.lsst.ccs.gconsole.services.persist.Persistable;

@Deprecated
public class TabbedView
extends AbstractMonitorView {
    private Descriptor descriptor = new Descriptor();
    private final JComponent panel = new JPanel(new BorderLayout());
    private JTabbedPane tabbedPane;
    private final LinkedHashMap<String, AbstractMonitorView> views = new LinkedHashMap();
    private Function<String, AbstractMonitorView> viewFactory = name -> {
        TreeView view = new TreeView();
        if (this.formatter != null) {
            view.setFormatter(this.formatter);
        }
        return view;
    };

    public TabbedView() {
        this.panel.add(new MonitorDisplay.EMPTY());
    }

    public void setTab(String name, AbstractMonitorView view) {
    }

    public void setViewFactory(Function<String, AbstractMonitorView> factory) {
        this.viewFactory = s -> {
            AbstractMonitorView view = (AbstractMonitorView)factory.apply((String)s);
            if (this.formatter != null) {
                view.setFormatter(this.formatter);
            }
            return view;
        };
    }

    @Override
    public JComponent getPanel() {
        return this.panel;
    }

    @Override
    public void addChannels(List<AgentInfo> agents, List<Map.Entry<String, AgentChannel>> channels) {
        LinkedHashMap<String, List> allTabs = new LinkedHashMap<String, List>();
        channels.forEach(e -> {
            String[] ss = this.split((String)e.getKey());
            AgentChannel ch = (AgentChannel)e.getValue();
            ArrayList<AbstractMap.SimpleEntry<String, AgentChannel>> oneTab = (ArrayList<AbstractMap.SimpleEntry<String, AgentChannel>>)allTabs.get(ss[0]);
            if (oneTab == null) {
                oneTab = new ArrayList<AbstractMap.SimpleEntry<String, AgentChannel>>(128);
                allTabs.put(ss[0], oneTab);
            }
            oneTab.add(new AbstractMap.SimpleEntry<String, AgentChannel>(ss[1], ch));
        });
        allTabs.forEach((tab, cc) -> {
            AbstractMonitorView view = this.views.get(tab);
            if (view == null) {
                AbstractMonitorView.Descriptor d;
                TreeMap<String, AbstractMonitorView.Descriptor> m;
                view = this.viewFactory.apply((String)tab);
                if (this.filter != null) {
                    view.setFilter(new PageFilter(this.filter, (String)tab));
                }
                if ((m = this.getDescriptor().getTabs()) != null && (d = m.get(tab)) != null) {
                    view.restore(d);
                }
                this.views.put((String)tab, view);
                switch (this.views.size()) {
                    case 0: {
                        this.tabbedPane = null;
                        this.panel.removeAll();
                        this.panel.add(new MonitorDisplay.EMPTY());
                        break;
                    }
                    case 1: {
                        this.tabbedPane = null;
                        this.panel.removeAll();
                        this.panel.add(view.getPanel());
                        break;
                    }
                    case 2: {
                        this.panel.removeAll();
                        this.tabbedPane = new JTabbedPane();
                        this.views.forEach((name, v) -> this.tabbedPane.add((String)name, v.getPanel()));
                        this.panel.add(this.tabbedPane);
                        break;
                    }
                    default: {
                        this.tabbedPane.add((String)tab, view.getPanel());
                    }
                }
            }
            view.addChannels(agents, (List<Map.Entry<String, AgentChannel>>)cc);
        });
    }

    @Override
    public void removeChannels(List<AgentInfo> agents, List<Map.Entry<String, AgentChannel>> channels) {
        LinkedHashMap<String, List> allTabs = new LinkedHashMap<String, List>();
        channels.forEach(e -> {
            String[] ss = this.split((String)e.getKey());
            AgentChannel ch = (AgentChannel)e.getValue();
            ArrayList<AbstractMap.SimpleEntry<String, AgentChannel>> oneTab = (ArrayList<AbstractMap.SimpleEntry<String, AgentChannel>>)allTabs.get(ss[0]);
            if (oneTab == null) {
                oneTab = new ArrayList<AbstractMap.SimpleEntry<String, AgentChannel>>(128);
                allTabs.put(ss[0], oneTab);
            }
            oneTab.add(new AbstractMap.SimpleEntry<String, AgentChannel>(ss[1], ch));
        });
        allTabs.forEach((tab, cc) -> {
            AbstractMonitorView view = this.views.get(tab);
            if (view != null) {
                view.removeChannels(agents, (List<Map.Entry<String, AgentChannel>>)cc);
                if (view.isEmpty()) {
                    this.views.remove(tab);
                    switch (this.views.size()) {
                        case 0: {
                            this.tabbedPane = null;
                            this.panel.removeAll();
                            this.panel.add(new MonitorDisplay.EMPTY());
                            break;
                        }
                        case 1: {
                            this.tabbedPane = null;
                            this.panel.removeAll();
                            this.panel.add(this.views.values().iterator().next().getPanel());
                            break;
                        }
                        default: {
                            this.tabbedPane.remove(view.getPanel());
                        }
                    }
                }
            }
        });
    }

    @Override
    public void updateChannels(List<Map.Entry<String, Map.Entry<AgentChannel, List<String>>>> channels) {
        LinkedHashMap<String, List> allTabs = new LinkedHashMap<String, List>();
        channels.forEach(e -> {
            String[] ss = this.split((String)e.getKey());
            ArrayList oneTab = (ArrayList)allTabs.get(ss[0]);
            if (oneTab == null) {
                oneTab = new ArrayList(128);
                allTabs.put(ss[0], oneTab);
            }
            oneTab.add(new AbstractMap.SimpleEntry(ss[1], e.getValue()));
        });
        allTabs.forEach((tab, cc) -> {
            AbstractMonitorView view = this.views.get(tab);
            if (view != null) {
                view.updateChannels((List<Map.Entry<String, Map.Entry<AgentChannel, List<String>>>>)cc);
            }
        });
    }

    @Override
    public Descriptor save() {
        Descriptor desc = new Descriptor();
        if (!this.views.isEmpty()) {
            TreeMap<String, AbstractMonitorView.Descriptor> dd = new TreeMap<String, AbstractMonitorView.Descriptor>();
            desc.setTabs(dd);
            for (Map.Entry<String, AbstractMonitorView> e : this.views.entrySet()) {
                dd.put(e.getKey(), e.getValue().save());
            }
        }
        return desc;
    }

    @Override
    public void restore(Persistable.Descriptor descriptor) {
        if (descriptor instanceof Descriptor) {
            this.descriptor = (Descriptor)descriptor;
            TreeMap<String, AbstractMonitorView.Descriptor> dd = this.descriptor.getTabs();
            if (dd != null) {
                for (Map.Entry<String, AbstractMonitorView.Descriptor> e : dd.entrySet()) {
                    AbstractMonitorView v = this.views.get(e.getKey());
                    if (v == null) continue;
                    v.restore(e.getValue());
                }
            }
        }
    }

    @Override
    public Descriptor getDescriptor() {
        return this.descriptor;
    }

    protected String[] split(String displayPath) {
        String[] out = new String[2];
        int i = displayPath.indexOf("//");
        if (i == -1) {
            out[0] = "";
            out[1] = displayPath;
        } else {
            out[0] = displayPath.substring(0, i);
            out[1] = displayPath.substring(i + 2);
        }
        return out;
    }

    public static class Descriptor
    extends AbstractMonitorView.Descriptor {
        private TreeMap<String, AbstractMonitorView.Descriptor> tabs;

        public TreeMap<String, AbstractMonitorView.Descriptor> getTabs() {
            return this.tabs;
        }

        public void setTabs(TreeMap<String, AbstractMonitorView.Descriptor> tabs) {
            this.tabs = tabs;
        }

        @Override
        public Descriptor clone() {
            Descriptor desc = (Descriptor)super.clone();
            if (desc.tabs != null) {
                desc.tabs = new TreeMap<String, AbstractMonitorView.Descriptor>((SortedMap<String, AbstractMonitorView.Descriptor>)desc.tabs);
                desc.tabs.entrySet().forEach(e -> e.setValue(((AbstractMonitorView.Descriptor)e.getValue()).clone()));
            }
            return desc;
        }
    }
}

