/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.base.filter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.lsst.ccs.gconsole.annotations.services.persist.Create;
import org.lsst.ccs.gconsole.annotations.services.persist.Par;
import org.lsst.ccs.gconsole.base.filter.AbstractChannelsFilter;
import org.lsst.ccs.gconsole.services.aggregator.AgentChannel;

public class CoreStates
extends AbstractChannelsFilter {
    public static final String CREATOR_PATH = "Built-In/Special/Core States";
    private final String name;
    private final List<String> agents;
    private final int cutFront = "/states/".length() - 2;
    private final int cutBack = "State".length();
    public static List<String> CHANNELS = Collections.unmodifiableList(Arrays.asList("/states/PhaseState", "/states/OperationalState", "/states/ConfigurationState", "/states/AlertState", "/states/CommandState"));

    @Create(category="AgentChannelsFilter", name="Core States", path="Built-In/Special/Core States", description="Selects core state channels, renames them to shorten the path.")
    public CoreStates(@Par(def="Core states", desc="Filter name.") String name, @Par(def="_null_", desc="List of subsystems accepted by this filter. If null, all subsystems are accepted.") List<String> agents) {
        this.name = name;
        this.agents = agents == null ? null : Collections.unmodifiableList(new ArrayList<String>(agents));
    }

    @Override
    public List<String> getDisplayPaths(AgentChannel channel) {
        String path = channel.getLocalPath();
        String displayPath = channel.getAgentName() + path.substring(this.cutFront, path.length() - this.cutBack);
        return Collections.singletonList(displayPath);
    }

    @Override
    public List<String> getOriginPaths(String displayPath) {
        return Collections.singletonList(displayPath.replaceFirst("/", "/states/") + "State");
    }

    @Override
    public List<String> getOriginChannels() {
        return CHANNELS;
    }

    @Override
    public List<String> getAgents() {
        return this.agents;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public List<String> getFields(boolean compact) {
        return Collections.singletonList("VALUE");
    }
}

