/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.gconsole.services.aggregator;

import java.util.HashMap;
import java.util.Map;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.states.AlertState;
import org.lsst.ccs.bus.states.CommandState;
import org.lsst.ccs.bus.states.ConfigurationState;
import org.lsst.ccs.bus.states.DataProviderState;
import org.lsst.ccs.bus.states.OperationalState;
import org.lsst.ccs.bus.states.PhaseState;
import org.lsst.ccs.gconsole.services.aggregator.AgentChannel;
import org.lsst.ccs.gconsole.services.aggregator.BasicChannel;

public class StateChannel
extends BasicChannel {
    private final Map<String, DataProviderState> value2state;

    public StateChannel(String path, AgentInfo agent, Map<String, Object> attributes, Object value) {
        super(path, agent, attributes, value);
        String localPath;
        switch (localPath = path.substring(path.indexOf("/"))) {
            case "/states/AlertState": {
                this.value2state = new HashMap<String, DataProviderState>(8);
                this.value2state.put(AlertState.NOMINAL.toString(), DataProviderState.NOMINAL);
                this.value2state.put(AlertState.WARNING.toString(), DataProviderState.WARNING);
                this.value2state.put(AlertState.ALARM.toString(), DataProviderState.ALARM);
                break;
            }
            case "/states/ConfigurationState": {
                this.value2state = new HashMap<String, DataProviderState>(8);
                this.value2state.put(ConfigurationState.CONFIGURED.toString(), DataProviderState.NOMINAL);
                this.value2state.put(ConfigurationState.DIRTY.toString(), DataProviderState.WARNING);
                this.value2state.put(ConfigurationState.UNCONFIGURED.toString(), DataProviderState.ALARM);
                break;
            }
            case "/states/OperationalState": {
                this.value2state = new HashMap<String, DataProviderState>(8);
                this.value2state.put(OperationalState.NORMAL.toString(), DataProviderState.NOMINAL);
                this.value2state.put(OperationalState.ENGINEERING_OK.toString(), DataProviderState.WARNING);
                this.value2state.put(OperationalState.ENGINEERING_FAULT.toString(), DataProviderState.ALARM);
                break;
            }
            case "/states/PhaseState": {
                this.value2state = new HashMap<String, DataProviderState>(8);
                this.value2state.put(PhaseState.OPERATIONAL.toString(), DataProviderState.NOMINAL);
                this.value2state.put(PhaseState.INITIALIZING.toString(), DataProviderState.WARNING);
                this.value2state.put(PhaseState.CLOSING.toString(), DataProviderState.WARNING);
                this.value2state.put(PhaseState.OFF_LINE.toString(), DataProviderState.OFF_LINE);
                break;
            }
            case "/states/CommandState": {
                this.value2state = new HashMap<String, DataProviderState>(4);
                this.value2state.put(CommandState.READY.toString(), DataProviderState.NOMINAL);
                this.value2state.put(CommandState.ACTIVE.toString(), DataProviderState.WARNING);
                break;
            }
            default: {
                this.value2state = null;
            }
        }
    }

    @Override
    public synchronized boolean set(Object value) {
        boolean out = super.set(value);
        if (out && this.value2state != null) {
            this.set(AgentChannel.Key.STATE, value == null ? null : this.value2state.get((String)value));
        }
        return out;
    }
}

