/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.messaging.jgroups;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.function.Supplier;
import org.jgroups.Address;
import org.jgroups.conf.ClassConfigurator;
import org.jgroups.stack.AddressGenerator;
import org.jgroups.util.Bits;
import org.jgroups.util.UUID;
import org.lsst.ccs.bus.data.AgentInfo;

public class CCSAddress
extends UUID {
    static final int RANK_RANGE = AgentInfo.AgentType.values().length;
    private long rank;

    public CCSAddress() {
    }

    public CCSAddress(long rank) {
        super(CCSAddress.generateRandomBytes((int)16));
        this.rank = rank;
    }

    public Supplier<? extends CCSAddress> create() {
        return CCSAddress::new;
    }

    public long getRank() {
        return this.rank;
    }

    public void writeTo(DataOutput out) throws IOException {
        super.writeTo(out);
        Bits.writeLong((long)this.rank, (DataOutput)out);
    }

    public void readFrom(DataInput in) throws IOException {
        super.readFrom(in);
        this.rank = Bits.readLong((DataInput)in);
    }

    public int serializedSize() {
        return super.serializedSize() + Bits.size((long)this.rank);
    }

    static {
        ClassConfigurator.add((short)7900, CCSAddress.class);
    }

    public static class Generator
    implements AddressGenerator {
        private final long rank;

        public Generator(AgentInfo agent) {
            long type = RANK_RANGE - agent.getType().ordinal() - 1;
            long time = agent.getAgentStartTime().getUTCInstant().toEpochMilli();
            this.rank = (type <<= 59) | (time &= 0x7FFFFFFL);
        }

        public Generator(long type) {
            type = (long)RANK_RANGE - type - 1L;
            long time = System.currentTimeMillis();
            this.rank = (type <<= 59) | (time &= 0x7FFFFFFL);
        }

        public Address generateAddress() {
            return new CCSAddress(this.rank);
        }
    }
}

