/*
 * Decompiled with CFR 0.152.
 */
package jas.plot;

import jas.plot.HasPopupItems;
import jas.plot.JASPlotMouseListener;
import jas.plot.PlotComponent;
import jas.plot.PrintHelper;
import jas.util.ColorMenu;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.LineBorder;
import javax.swing.colorchooser.ColorSelectionModel;
import javax.swing.colorchooser.DefaultColorSelectionModel;

public abstract class MovableObject
extends PlotComponent
implements HasPopupItems,
JASPlotMouseListener {
    private String prefix;
    private boolean hasBeenResized = false;
    private boolean hasBeenMoved = false;
    private int currentCursor;
    private Point dragOffset;
    private Cursor saveCursor;
    private boolean handlesVisible;
    private static final HandleBorder border = new HandleBorder(Color.blue);
    public static final Color[] bgcolors = new Color[]{null, Color.pink, Color.orange, Color.yellow, Color.green, Color.cyan, new Color(164, 207, 255), new Color(225, 170, 255), new Color(255, 170, 210)};
    public static final String[] bgnames = new String[]{"default", "pink", "light orange", "yellow", "light green", "cyan", "sky blue", "violet", "light magenta"};

    public MovableObject(String prefix) {
        this.prefix = prefix;
        super.setBorder(border);
    }

    protected String getPrefix() {
        return this.prefix;
    }

    public void setMovableObjectBounds(int p1, int p2, int p3, int p4) {
        super.setBounds(p1, p2, p3, p4);
        this.hasBeenMoved = true;
        this.hasBeenResized = true;
    }

    public void setMovableObjectBounds(Rectangle r) {
        super.setBounds(r);
        this.hasBeenMoved = true;
        this.hasBeenResized = true;
    }

    @Override
    public void setBorder(Border newBorder) {
        Border oldBorder = super.getBorder();
        if (oldBorder instanceof CompoundBorder) {
            oldBorder = ((CompoundBorder)oldBorder).getOutsideBorder();
        }
        super.setBorder(newBorder == null ? oldBorder : new CompoundBorder(oldBorder, newBorder));
    }

    @Override
    public int getBorderType() {
        return MovableObject.getBorderType(this.getInsideBorder());
    }

    public Border getInsideBorder() {
        Border oldBorder = super.getBorder();
        if (oldBorder instanceof CompoundBorder) {
            return ((CompoundBorder)oldBorder).getInsideBorder();
        }
        if (oldBorder instanceof HandleBorder) {
            return null;
        }
        return oldBorder;
    }

    @Override
    public void modifyPopupMenu(JPopupMenu menu, Component source) {
        menu.add(new BorderMenu(this.prefix));
        DefaultColorSelectionModel cm = new DefaultColorSelectionModel(){

            @Override
            public Color getSelectedColor() {
                if (!MovableObject.this.isPaintingBackground()) {
                    return null;
                }
                return MovableObject.this.getBackground();
            }

            @Override
            public void setSelectedColor(Color c) {
                MovableObject.this.setBackground(c);
            }
        };
        menu.add(new BackgroundColorMenu(this.prefix, cm));
    }

    final void showHandles() {
        this.handlesVisible = true;
        this.paintBorder(this.getGraphics());
        this.saveCursor = this.getCursor();
        this.currentCursor = 0;
    }

    final void hideHandles() {
        this.handlesVisible = false;
        this.setCursor(this.saveCursor);
        Container p = this.getParent();
        if (p != null) {
            p.repaint();
        }
    }

    @Override
    public final void mouseEventNotify(MouseEvent me) {
        if (this.handlesVisible) {
            if (me.getID() == 504) {
                this.saveCursor = this.getCursor();
            } else if (me.getID() == 505) {
                this.setCursor(this.saveCursor);
            } else if (me.getID() == 501) {
                if (this.currentCursor == 13) {
                    this.dragOffset = me.getPoint();
                }
            } else if (me.getID() == 502) {
                this.dragOffset = null;
            }
        }
    }

    final void mouseMotionEventNotify(MouseEvent me) {
        if (!this.handlesVisible) {
            return;
        }
        if (me.getID() == 506) {
            if (this.currentCursor == 13) {
                Point p = me.getPoint();
                Point x = this.getLocation();
                p.translate(x.x, x.y);
                if (this.dragOffset != null) {
                    p.translate(-this.dragOffset.x, -this.dragOffset.y);
                }
                this.setLocation(p);
                this.hasBeenMoved = true;
            } else {
                Rectangle b = this.getBounds();
                Point p = me.getPoint();
                if (this.currentCursor == 11) {
                    b.width = p.x;
                } else if (this.currentCursor == 10) {
                    b.width -= p.x;
                    b.x += p.x;
                } else if (this.currentCursor == 8) {
                    b.height -= p.y;
                    b.y += p.y;
                } else if (this.currentCursor == 9) {
                    b.height = p.y;
                } else if (this.currentCursor == 7) {
                    b.height -= p.y;
                    b.y += p.y;
                    b.width = p.x;
                } else if (this.currentCursor == 6) {
                    b.height -= p.y;
                    b.y += p.y;
                    b.width -= p.x;
                    b.x += p.x;
                } else if (this.currentCursor == 5) {
                    b.height = p.y;
                    b.width = p.x;
                } else if (this.currentCursor == 4) {
                    b.height = p.y;
                    b.width -= p.x;
                    b.x += p.x;
                } else {
                    return;
                }
                this.hasBeenResized = true;
                this.setBounds(b);
                this.validate();
            }
        } else if (me.getID() == 503) {
            this.currentCursor = border.getCursor(this.getBounds(), me.getPoint());
            ((Component)me.getSource()).setCursor(Cursor.getPredefinedCursor(this.currentCursor));
        }
    }

    public boolean hasBeenResized() {
        return this.hasBeenResized;
    }

    public boolean hasBeenMoved() {
        return this.hasBeenMoved;
    }

    public void restoreDefaultLayout() {
        this.hasBeenResized = false;
        this.hasBeenMoved = false;
    }

    public boolean hasDefaultLayout() {
        return !this.hasBeenMoved() && !this.hasBeenResized();
    }

    public void resizeMovableObject(int w, int h) {
        this.hasBeenResized = true;
        this.setSize(w, h);
    }

    public void moveMovableObject(int x, int y) {
        this.hasBeenMoved = true;
        this.setLocation(x, y);
    }

    @Override
    public void print(Graphics g) {
        try {
            if (System.getProperty("java.version").compareTo("1.3") >= 0) {
                super.print(g);
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    private final class BorderMenu
    extends JMenu {
        BorderMenu(String prefix) {
            super(prefix + " Border");
            this.addItem("None", 0);
            this.addItem("Bevel In", 1);
            this.addItem("Bevel Out", 2);
            this.addItem("Ethched", 3);
            this.addItem("Shadow", 5);
            DefaultColorSelectionModel cm = new DefaultColorSelectionModel(){

                @Override
                public Color getSelectedColor() {
                    Border oldBorder = MovableObject.this.getBorder();
                    if (oldBorder instanceof CompoundBorder) {
                        oldBorder = ((CompoundBorder)oldBorder).getInsideBorder();
                    }
                    if (oldBorder instanceof LineBorder) {
                        return ((LineBorder)oldBorder).getLineColor();
                    }
                    return null;
                }

                @Override
                public void setSelectedColor(Color c) {
                    MovableObject.this.setBorder(BorderFactory.createLineBorder(c));
                }
            };
            this.add(new ColorMenu("Line", cm, false));
        }

        private void addItem(String name, final int btype) {
            JRadioButtonMenuItem i = new JRadioButtonMenuItem(name);
            this.add(i);
            i.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MovableObject.this.setBorderType(btype);
                }
            });
            i.setSelected(MovableObject.this.getBorderType() == btype);
        }
    }

    private final class BackgroundColorMenu
    extends ColorMenu {
        BackgroundColorMenu(String prefix, ColorSelectionModel cm) {
            super(prefix + " Background", cm, bgcolors, bgnames);
        }
    }

    private static final class HandleBorder
    extends AbstractBorder {
        private Color lineColor;
        private static final int thickness = 5;
        private static final Insets insets = new Insets(5, 5, 5, 5);
        private static final int thick2 = 2;
        private static Handle[] handles = new Handle[8];

        HandleBorder(Color color) {
            this.lineColor = color;
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            if (((MovableObject)c).handlesVisible && !PrintHelper.isPrinting()) {
                Color oldColor = g.getColor();
                int xx = x + 2;
                int yy = y + 2;
                int ww = width - 5;
                int hh = height - 5;
                Handle[] h = this.getHandles(xx, yy, ww, hh);
                g.setColor(this.lineColor);
                g.drawRect(xx, yy, ww, hh);
                for (int i = 0; i < h.length; ++i) {
                    g.fillRect(h[i].x, h[i].y, h[i].width, h[i].height);
                }
                g.setColor(oldColor);
            }
        }

        private Handle[] getHandles(int xx, int yy, int ww, int hh) {
            handles[0].set(6, xx, yy);
            handles[1].set(7, xx + ww, yy);
            handles[2].set(5, xx + ww, yy + hh);
            handles[3].set(4, xx, yy + hh);
            handles[4].set(8, xx + ww / 2, yy);
            handles[5].set(9, xx + ww / 2, yy + hh);
            handles[6].set(10, xx, yy + hh / 2);
            handles[7].set(11, xx + ww, yy + hh / 2);
            return handles;
        }

        int getCursor(Rectangle b, Point p) {
            int xx = 2;
            int yy = 2;
            int ww = b.width - 5;
            int hh = b.height - 5;
            Handle[] h = this.getHandles(xx, yy, ww, hh);
            for (int i = 0; i < h.length; ++i) {
                if (!h[i].contains(p)) continue;
                return h[i].getCursor();
            }
            int extra = 3;
            if (p.x <= 5 && p.x >= -1 || p.y <= 5 && p.y >= -1 || p.x >= b.width - 2 - 3 && p.x <= b.width - 2 + 3 || p.y >= b.height - 2 - 3 && p.y <= b.height - 2 + 3) {
                return 13;
            }
            return 0;
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return insets;
        }

        public Color getLineColor() {
            return this.lineColor;
        }

        @Override
        public boolean isBorderOpaque() {
            return false;
        }

        static {
            for (int i = 0; i < handles.length; ++i) {
                HandleBorder.handles[i] = new Handle(5);
            }
        }

        private static final class Handle
        extends Rectangle {
            private int thick2;
            private int type;

            Handle(int size) {
                this.setSize(size - 1, size - 1);
                this.thick2 = size / 2;
            }

            void set(int type, int x, int y) {
                this.setLocation(x - this.thick2, y - this.thick2);
                this.type = type;
            }

            int getCursor() {
                return this.type;
            }
        }
    }
}

