/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.plaf;

import java.awt.Color;
import java.util.logging.Logger;
import javax.swing.UIManager;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.plaf.UIResource;
import org.jdesktop.swingx.plaf.AbstractComponentAddon;
import org.jdesktop.swingx.plaf.DefaultsList;
import org.jdesktop.swingx.plaf.LookAndFeelAddons;
import org.jdesktop.swingx.plaf.SafeBorder;

public class TableAddon
extends AbstractComponentAddon {
    private static final Logger LOG = Logger.getLogger(TableAddon.class.getName());

    public TableAddon() {
        super("JXTable");
    }

    protected void addNimbusDefaults(LookAndFeelAddons addon, DefaultsList defaults) {
        super.addNimbusDefaults(addon, defaults);
        if (Boolean.TRUE.equals(UIManager.get("Nimbus.keepAlternateRowColor"))) {
            return;
        }
        Object value = UIManager.getLookAndFeelDefaults().remove("Table.alternateRowColor");
        if (value instanceof Color) {
            defaults.add((Object)"UIColorHighlighter.stripingBackground", value, false);
        }
    }

    protected void addBasicDefaults(LookAndFeelAddons addon, DefaultsList defaults) {
        super.addBasicDefaults(addon, defaults);
        if (this.isGTK()) {
            this.replaceListTableBorders(addon, defaults);
        }
    }

    private void replaceListTableBorders(LookAndFeelAddons addon, DefaultsList defaults) {
        this.replaceBorder(defaults, "Table.", "focusCellHighlightBorder");
        this.replaceBorder(defaults, "Table.", "focusSelectedCellHighlightBorder");
        this.replaceBorder(defaults, "Table.", "noFocusBorder");
    }

    private void replaceBorder(DefaultsList defaults, String componentPrefix, String borderKey) {
        String key = componentPrefix + borderKey;
        Border border = UIManager.getBorder(componentPrefix + borderKey);
        if (border instanceof AbstractBorder && border instanceof UIResource && border.getClass().getName().contains("ListTable")) {
            border = new SafeBorder((AbstractBorder)border);
            UIManager.getLookAndFeelDefaults().put(key, border);
        }
    }

    private boolean isGTK() {
        return "GTK".equals(UIManager.getLookAndFeel().getID());
    }
}

