/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.function;

import hep.aida.ref.function.FunctionCore;
import jas.hist.Handle;
import java.awt.Cursor;
import org.freehep.util.images.ImageHandler;

public class ExponentialCoreNotNorm
extends FunctionCore {
    protected boolean providesNormalization;

    public ExponentialCoreNotNorm(String str) {
        super(1, 2, new double[]{1.0, 1.0});
        this.setTitle("ExponentialCoreNotNorm::" + str);
        this.providesNormalization = false;
        String[] names = new String[]{"amplitude", "exponent"};
        this.setParameterNames(names);
    }

    public ExponentialCoreNotNorm(String str, double[] pVal) {
        super(1, 2, pVal);
        this.setTitle("ExponentialCoreNotNorm::" + str);
        this.providesNormalization = false;
        String[] names = new String[]{"amplitude", "exponent"};
        this.setParameterNames(names);
    }

    @Override
    public double functionValue(double[] var) {
        return this.p[0] * Math.exp(var[0] * this.p[1]);
    }

    @Override
    public boolean providesGradient() {
        return true;
    }

    @Override
    public double[] gradient(double[] var) {
        double[] tmp = new double[]{0.0};
        return new double[]{this.functionValue(var) * this.p[1]};
    }

    @Override
    public boolean providesParameterGradient() {
        return true;
    }

    @Override
    public double[] parameterGradient(double[] var) {
        double y = this.functionValue(var);
        return new double[]{y / this.p[0], y * var[0]};
    }

    @Override
    public boolean providesNormalization() {
        return this.providesNormalization;
    }

    @Override
    public double normalizationAmplitude(double[] xMin, double[] xMax) {
        throw new UnsupportedOperationException(this.title() + " *****  Can not calculate normalization for a not normalized function");
    }

    @Override
    public Handle[] getHandles(double xLow, double xHigh, double yLow, double yHigh) {
        Handle[] result = new Handle[2];
        double xmin = xLow;
        double xmax = xHigh;
        double ymin = yLow;
        double ymax = yHigh;
        result[0] = new MyHandle(xmin, xmax, ymin, ymax){
            double tmpY;
            {
                this.tmpY = Double.NaN;
            }

            public void moveTo(double x, double y) {
                this.tmpY = y;
                double x0 = this.handle().getX();
                double y0 = this.handle().getY();
                if (y != 0.0) {
                    ExponentialCoreNotNorm.this.p[1] = Math.log(y0 / y) / (x0 - x);
                    ExponentialCoreNotNorm.this.p[0] = y / Math.exp(x * ExponentialCoreNotNorm.this.p[1]);
                } else {
                    ExponentialCoreNotNorm.this.p[0] = 0.0;
                }
                if (!this.isInPlot(x, y)) {
                    this.tmpY = Double.NaN;
                }
                ExponentialCoreNotNorm.this.notifyCoreChanged();
            }

            public double getY() {
                if (Double.isNaN(this.tmpY)) {
                    this.calculateIntersections();
                    this.tmpY = 0.8 * this.y0() + 0.2 * this.y1();
                }
                return this.tmpY;
            }

            public double getX() {
                return Math.log(this.getY() / ExponentialCoreNotNorm.this.p[0]) / ExponentialCoreNotNorm.this.p[1];
            }

            public Cursor cursor() {
                return ImageHandler.getBestCursor((String)"rotateCursor.png", ExponentialCoreNotNorm.class, (int)0, (int)0);
            }
        };
        result[1] = new MyHandle(xmin, xmax, ymin, ymax){
            double tmpY;
            {
                this.tmpY = Double.NaN;
            }

            public void moveTo(double x, double y) {
                this.tmpY = y;
                ExponentialCoreNotNorm.this.p[1] = Math.log(y / ExponentialCoreNotNorm.this.p[0]) / x;
                if (!this.isInPlot(x, y)) {
                    this.tmpY = Double.NaN;
                }
                ExponentialCoreNotNorm.this.notifyCoreChanged();
            }

            public double getY() {
                if (Double.isNaN(this.tmpY)) {
                    this.calculateIntersections();
                    this.tmpY = 0.2 * this.y0() + 0.8 * this.y1();
                }
                return this.tmpY;
            }

            public double getX() {
                return Math.log(this.getY() / ExponentialCoreNotNorm.this.p[0]) / ExponentialCoreNotNorm.this.p[1];
            }

            public Cursor cursor() {
                return ImageHandler.getBestCursor((String)"moveCursor.png", ExponentialCoreNotNorm.class, (int)0, (int)0);
            }
        };
        ((MyHandle)result[0]).setHandle(result[1]);
        return result;
    }

    private abstract class MyHandle
    extends Handle {
        private Handle handle = null;
        double x0;
        double y0;
        double x1;
        double y1;
        double xmin;
        double xmax;
        double ymin;
        double ymax;

        MyHandle(double xmin, double xmax, double ymin, double ymax) {
            this.xmin = xmin;
            this.xmax = xmax;
            this.ymin = ymin;
            this.ymax = ymax;
            this.calculateIntersections();
        }

        void setHandle(Handle handle) {
            this.handle = handle;
        }

        Handle handle() {
            return this.handle;
        }

        boolean isInPlot(double x, double y) {
            if (x > this.xmax || x < this.xmin) {
                return false;
            }
            return !(y > this.ymax) && !(y < this.ymin);
        }

        void calculateIntersections() {
            this.x0 = this.xmin;
            this.y0 = ExponentialCoreNotNorm.this.p[0] * Math.exp(this.x0 * ExponentialCoreNotNorm.this.p[1]);
            if (this.y0 > this.ymax) {
                this.y0 = this.ymax;
            }
            if (this.y0 < this.ymin) {
                this.y0 = this.ymin;
            }
            this.x0 = Math.log(this.y0 / ExponentialCoreNotNorm.this.p[0]) / ExponentialCoreNotNorm.this.p[1];
            this.x1 = this.xmax;
            this.y1 = ExponentialCoreNotNorm.this.p[0] * Math.exp(this.x1 * ExponentialCoreNotNorm.this.p[1]);
            if (this.y1 > this.ymax) {
                this.y1 = this.ymax;
            }
            if (this.y1 < this.ymin) {
                this.y1 = this.ymin;
            }
            this.x1 = Math.log(this.y1 / ExponentialCoreNotNorm.this.p[0]) / ExponentialCoreNotNorm.this.p[1];
        }

        double x0() {
            return this.x0;
        }

        double x1() {
            return this.x1;
        }

        double y0() {
            return this.y0;
        }

        double y1() {
            return this.y1;
        }
    }
}

