/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.common.ui.focalplane.filter;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.data.DataProviderInfo;
import org.lsst.ccs.gconsole.annotations.services.persist.Create;
import org.lsst.ccs.gconsole.annotations.services.persist.Par;
import org.lsst.ccs.gconsole.base.Console;
import org.lsst.ccs.gconsole.services.aggregator.AgentChannel;
import org.lsst.ccs.subsystem.common.focalplane.data.HasFocalPlaneData;
import org.lsst.ccs.subsystem.common.ui.focalplane.Segment;
import org.lsst.ccs.subsystem.common.ui.focalplane.filter.FocalPlaneFilter;

public class GroupAttributeFilter
extends FocalPlaneFilter {
    private static final String KEY = DataProviderInfo.Attribute.DATA_GROUP.getName();
    private final Descriptor descriptor;
    private HashSet<String> groups;

    @Create(category="FocalPlaneFilter", name="Standard data groups", path="Built-In/Standard Groups/One Subsystem", description="Standard pre-defined focal plane data groups determined by the DATA_GROUP attribute.")
    public GroupAttributeFilter(@Par(desc="Subsystem name.") String subsystem) {
        this.descriptor = new Descriptor();
        this.descriptor.setAgent(subsystem);
    }

    public GroupAttributeFilter(Descriptor desc) {
        this.descriptor = desc.clone();
        if (this.descriptor.groups != null) {
            this.groups = new HashSet<String>(Arrays.asList(this.descriptor.groups));
        }
    }

    public String getName() {
        return this.descriptor.getAgent() == null ? super.getName() : this.descriptor.getAgent();
    }

    public List<String> getAgents() {
        return this.descriptor.agent == null ? null : Collections.singletonList(this.descriptor.agent);
    }

    @Override
    public String getDisplayPath(AgentChannel channel) {
        if (this.descriptor.agent != null && !channel.getAgentName().equals(this.descriptor.agent)) {
            return null;
        }
        Object gr = channel.get((Object)KEY);
        if (!(gr instanceof String)) {
            return null;
        }
        String group = (String)gr;
        if (this.groups != null && !this.groups.contains(group)) {
            return null;
        }
        String prefix = Segment.getPathPrefix(channel);
        if (prefix == null || prefix.isEmpty()) {
            return null;
        }
        return prefix + group;
    }

    public List<String> getGroups() {
        if (this.descriptor.groups != null) {
            return Arrays.asList(this.descriptor.groups);
        }
        if (this.descriptor.agent == null) {
            return null;
        }
        AgentInfo info = Console.getConsole().getStatusAggregator().getAgent(this.descriptor.agent);
        if (info == null) {
            return null;
        }
        String prop = info.getAgentProperty(HasFocalPlaneData.AGENT_PROPERTY);
        if (prop == null) {
            return null;
        }
        String[] ss = HasFocalPlaneData.getFocalPlaneDataGroups((String)prop);
        return Arrays.asList(ss);
    }

    @Override
    public Descriptor getDescriptor() {
        return this.descriptor;
    }

    public static class Descriptor
    extends FocalPlaneFilter.Descriptor {
        private String agent;
        private String[] groups;

        public String getAgent() {
            return this.agent;
        }

        public void setAgent(String agent) {
            this.agent = agent;
        }

        public String[] getGroups() {
            return this.groups;
        }

        public void setGroups(String[] groups) {
            this.groups = groups;
        }

        @Override
        public Descriptor clone() {
            return (Descriptor)super.clone();
        }
    }
}

