/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.config;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;
import org.lsst.ccs.bus.data.ConfigurationInfo;
import org.lsst.ccs.bus.data.DataProviderInfo;
import org.lsst.ccs.bus.states.ConfigurationState;
import org.lsst.ccs.config.BulkSettingException;
import org.lsst.ccs.config.BulkValidationException;
import org.lsst.ccs.config.CategoryHandler;
import org.lsst.ccs.config.ConfigurationDescription;
import org.lsst.ccs.config.ConfigurationHandler;
import org.lsst.ccs.config.ConfigurationHandlerBuilder;
import org.lsst.ccs.config.ConfigurationParameterHandler;
import org.lsst.ccs.config.ConfigurationView;
import org.lsst.ccs.utilities.logging.Logger;
import org.lsst.ccs.utilities.structs.ParameterPath;
import org.lsst.ccs.utilities.taitime.CCSTimeStamp;

public class ConfigurationHandlerSet {
    private static final Logger log = Logger.getLogger((String)"org.lsst.ccs.config");
    private final List<DataProviderInfo> list = new ArrayList<DataProviderInfo>();
    private static final Pattern categoryPattern = Pattern.compile("^[a-zA-Z0-9]+$");
    private final Map<String, ConfigurationHandler> componentParameterHandlers = new LinkedHashMap<String, ConfigurationHandler>();
    private final Map<String, CategoryHandler> parametersByCategories = new HashMap<String, CategoryHandler>();
    private ConfigurationView initialView;
    private final Set<String> categories = new HashSet<String>();
    private final Map<String, String> componentToPath = new HashMap<String, String>();
    private final boolean checkConfigView;
    private final boolean failOnViewProblems;
    private boolean failForBuildParameters = false;
    private boolean failForFinalParameters = false;
    private static Comparator<DataProviderInfo> comparator = new Comparator<DataProviderInfo>(){

        @Override
        public int compare(DataProviderInfo o1, DataProviderInfo o2) {
            return o1.getFullPath().compareTo(o2.getFullPath());
        }
    };

    public ConfigurationHandlerSet(boolean checkConfigView, boolean failOnViewProblems) {
        this.checkConfigView = checkConfigView;
        this.failOnViewProblems = failOnViewProblems;
    }

    public ConfigurationHandlerSet() {
        this(true, false);
    }

    public ConfigurationHandler addConfigurationHandlerForObject(String componentName, String componentPath, Object component) {
        ConfigurationHandler handler = ConfigurationHandlerBuilder.buildParameterSetterFromObject(componentName, component);
        this.componentToPath.put(componentName, componentPath);
        if (handler == null) {
            return null;
        }
        this.componentParameterHandlers.put(componentName, handler);
        for (ConfigurationParameterHandler cph : handler.getConfigurationParameterHandlers()) {
            String category;
            if (cph.isBuild()) {
                if (cph.getCategory() != null && !cph.getCategory().equals("build")) {
                    log.log(Level.WARNING, "Changing assigned category {0} for isBuild parameter {1} to \"build\".\n To get rid of this warning remove \"isBuild=true\" in your ConfigurationParameter annotation and specify \"category=\"build\"\" instead.", new Object[]{cph.getCategory(), cph.getParameterPath()});
                }
                cph.setCategory("build");
            }
            if (!categoryPattern.matcher(category = cph.getCategory()).matches()) {
                throw new RuntimeException("Illegal category name: \"" + category + "\" for parameter " + cph.getParameterPath() + ". Category names can only contain letters or digits.");
            }
            CategoryHandler set = this.parametersByCategories.get(category);
            if (set == null) {
                this.categories.add(category);
                set = new CategoryHandler(category);
                this.parametersByCategories.put(category, set);
            }
            set.addParameterHandler(cph);
        }
        return handler;
    }

    public ConfigurationInfo initialize(String descriptionName, String agentName) {
        return this.initialize(descriptionName, new ConfigurationView(ConfigurationDescription.initialDefaultConfiguration(this.categories)), agentName, false, false);
    }

    public ConfigurationInfo initialize(String descriptionName, ConfigurationView safeView, String agentName, boolean isBuild, boolean isInit) {
        this.failForBuildParameters = !isBuild;
        this.failForFinalParameters = !isBuild && !isInit;
        this.initialView = new ConfigurationView(ConfigurationDescription.initialDefaultConfiguration(this.categories));
        this.initialView.putAll(this.getLiveConfigurationView());
        if (isInit && !isBuild) {
            ArrayList<ParameterPath> missingMaxLength = new ArrayList<ParameterPath>();
            ArrayList<ParameterPath> missingVolatile = new ArrayList<ParameterPath>();
            for (ConfigurationHandler handler : this.componentParameterHandlers.values()) {
                for (ConfigurationParameterHandler configHandler : handler.getConfigurationParameterHandlers()) {
                    boolean mustBeVolatile;
                    boolean bl = mustBeVolatile = !configHandler.isBuild() && !configHandler.isFinal();
                    if (mustBeVolatile && !ConfigurationHandlerSet.isVolatile(configHandler)) {
                        missingVolatile.add(configHandler.getParameterPath());
                    }
                    if (!configHandler.hasLength() || configHandler.getMaxLength() != 0) continue;
                    missingMaxLength.add(configHandler.getParameterPath());
                }
            }
            if (missingMaxLength.size() > 0) {
                log.log(Level.WARNING, "Collections or Arrays annotated as Configuration Parameters must provide the \"maxLength\" argument.\nPlease update your code to specify the maximum allowed length for the following parameters: \n{0}", missingMaxLength);
            }
            if (missingVolatile.size() > 0) {
                log.log(Level.WARNING, "Fields annotated as Configuration Parameters must be declared as \"volatile\".\nPlease update your code for the following parameters:\n{0}", missingVolatile);
            }
        }
        try {
            safeView = this.loadCategories(safeView, isBuild, isInit);
            this.initialView.putAll(safeView);
        }
        catch (Exception ex) {
            throw new RuntimeException("could not load initial configuration.", ex);
        }
        ConfigurationInfo.Builder ciBuilder = new ConfigurationInfo.Builder().setDescription(descriptionName).updateConfigurationDescription(safeView.getConfigurationDescription().getFullDescriptionName(), safeView.getConfigurationDescription().getDescriptionName());
        for (CategoryHandler ch : this.parametersByCategories.values()) {
            String category = ch.getCategory();
            for (ConfigurationParameterHandler cph : ch.getParameters()) {
                ParameterPath pp = new ParameterPath(cph.getComponentName(), cph.getParameterName());
                ciBuilder.addParameter(pp, cph.getType(), cph.getCategory(), cph.getDescription(), cph.isFinal(), cph.isReadOnly(), cph.isBuild());
                DataProviderInfo dataProviderInfo = new DataProviderInfo(this.componentToPath.get(pp.getComponentName()), DataProviderInfo.Type.CONFIGURATION, pp.getParameterName());
                if (!cph.getUnits().isEmpty()) {
                    dataProviderInfo.addAttribute(DataProviderInfo.Attribute.UNITS, cph.getUnits());
                }
                dataProviderInfo.addAttribute(DataProviderInfo.Attribute.TYPE, cph.getType().getTypeName());
                if (!cph.getDescription().isEmpty()) {
                    dataProviderInfo.addAttribute(DataProviderInfo.Attribute.DESCRIPTION, cph.getDescription());
                }
                dataProviderInfo.addAttribute(DataProviderInfo.Attribute.CONFIG_TYPE, cph.getParameterType().name());
                dataProviderInfo.addAttribute(DataProviderInfo.Attribute.CONFIG_CATEGORY, cph.getCategory());
                String range = cph.getRange();
                if (range != null && !range.isEmpty()) {
                    dataProviderInfo.addAttribute(DataProviderInfo.Attribute.CONFIG_RANGE, range);
                }
                if (cph.hasLength() && cph.getMaxLength() != 0) {
                    dataProviderInfo.addAttribute(DataProviderInfo.Attribute.CONFIG_MAX_LENGTH, String.valueOf(cph.getMaxLength()));
                }
                this.list.add(dataProviderInfo);
                ciBuilder.updateParameter(pp, this.initialView.getPathValue(pp), this.initialView.getPathValue(pp), false);
            }
        }
        Collections.sort(this.list, comparator);
        this.failForBuildParameters = true;
        this.failForFinalParameters = true;
        return ciBuilder.setConfigurationState(ConfigurationState.UNCONFIGURED).setCCSTimeStamp(CCSTimeStamp.currentTime()).build();
    }

    public ConfigurationParameterHandler getConfigurationParameterHandler(ParameterPath pp) {
        return this.componentParameterHandlers.get(pp.getComponentName()).getConfigurationParameterHandler(pp.getParameterName());
    }

    private static boolean isVolatile(ConfigurationParameterHandler parameterHandler) {
        return Modifier.isVolatile(parameterHandler.getField().getModifiers()) || Modifier.isFinal(parameterHandler.getField().getModifiers());
    }

    public List<DataProviderInfo> getDataPoviderInfoList() {
        return this.list;
    }

    public ConfigurationHandler getConfigurationHandlerForGroovy(String componentName) {
        try {
            return this.getParameterSet(componentName);
        }
        catch (Exception e) {
            return null;
        }
    }

    public ConfigurationHandler getParameterSet(String componentName) {
        ConfigurationHandler res = this.componentParameterHandlers.get(componentName);
        if (res == null) {
            throw new IllegalArgumentException("no such component : " + componentName);
        }
        return res;
    }

    public CategoryHandler getCategoryHandler(String category) {
        CategoryHandler res = this.parametersByCategories.get(category);
        if (res == null) {
            log.info((Object)("no such category : \"" + category + "\""));
            throw new RuntimeException("Category \"" + category + "\" does not exist");
        }
        return res;
    }

    public boolean isBuildParameter(String componentName, String parameterName) {
        ConfigurationHandler ch = this.componentParameterHandlers.get(componentName);
        return ch == null ? false : ch.isBuildParameter(parameterName);
    }

    public boolean isFinalParameter(String componentName, String parameterName) {
        ConfigurationHandler ch = this.componentParameterHandlers.get(componentName);
        return ch == null ? false : ch.isFinalParameter(parameterName);
    }

    public boolean isParameterConfigurable(String componentName, String parameterName) {
        ConfigurationHandler ch = this.componentParameterHandlers.get(componentName);
        return ch == null ? false : ch.isParameterConfigurable(parameterName);
    }

    public boolean isParameterReadOnly(String componentName, String parameterName) {
        ConfigurationHandler ch = this.componentParameterHandlers.get(componentName);
        return ch == null ? false : ch.isParameterReadOnly(parameterName);
    }

    public Set<String> getCategorySet() {
        return Collections.unmodifiableSet(this.parametersByCategories.keySet());
    }

    public ConfigurationView loadCategories(ConfigurationView cv) {
        return this.loadCategories(cv, false, false);
    }

    private boolean isValueEqualToLoadedValue(String componentName, String parameterName, Object value) {
        ConfigurationParameterHandler cph = this.getParameterSet(componentName).getConfigurationParameterHandler(parameterName);
        Object inputValue = value instanceof String ? cph.convert((String)value).getValue() : value;
        Object currentValue = cph.getObjectValue();
        if (inputValue == null) {
            return currentValue == null;
        }
        return Objects.deepEquals(inputValue, currentValue);
    }

    private ConfigurationView loadCategories(ConfigurationView cv, boolean isBuild, boolean isInit) {
        ConfigurationDescription configDesc = cv.getConfigurationDescription();
        StringBuilder unexpectedParms = new StringBuilder("");
        for (Map.Entry<ParameterPath, String> entry : cv.getAsParameterPathMap().entrySet()) {
            String parameterName;
            ParameterPath parm = entry.getKey();
            String componentName = parm.getComponentName();
            if (this.isParameterReadOnly(componentName, parameterName = parm.getParameterName())) continue;
            if (this.isParameterConfigurable(componentName, parameterName) && !this.isParameterReadOnly(componentName, parameterName)) {
                if (!isInit && this.isValueEqualToLoadedValue(componentName, parameterName, entry.getValue())) continue;
                Object newValue = this.submitChange(componentName, parameterName, entry.getValue());
                cv.putParameterValue(componentName, parameterName, (String)newValue);
                continue;
            }
            if (!cv.containsPath(parm)) continue;
            unexpectedParms.append(parm).append(" ");
        }
        if (configDesc != null) {
            HashMap<String, String> missingParmsDigest = new HashMap<String, String>();
            for (String category : configDesc.getCategoriesSet()) {
                StringBuilder missingParms = new StringBuilder("");
                CategoryHandler ch = this.getCategoryHandler(category);
                for (ConfigurationParameterHandler cph : ch.getParameters()) {
                    boolean isMissingBuild;
                    String parameterName;
                    String componentName = cph.getComponentName();
                    ParameterPath parm = new ParameterPath(componentName, parameterName = cph.getParameterName());
                    if (cv.containsPath(parm)) continue;
                    boolean isRuntime = !cph.isReadOnly() && !cph.isFinal() && !cph.isBuild();
                    boolean isMissingFinal = cph.isFinal() && (isInit || isBuild);
                    boolean bl = isMissingBuild = cph.isBuild() && isBuild;
                    if (!isRuntime && !isMissingFinal && !isMissingBuild) continue;
                    missingParms.append(new ParameterPath(componentName, parameterName).toString()).append(" ");
                }
                if (missingParms.toString().isEmpty()) continue;
                missingParmsDigest.put("\"" + configDesc.getCategoryTag(category) + "\"", missingParms.toString());
            }
            if (!(!this.checkConfigView || unexpectedParms.toString().isEmpty() && missingParmsDigest.isEmpty())) {
                StringBuilder diag = new StringBuilder("the following problems occured when reading the configuration : ").append(configDesc.toString()).append("\n");
                if (!unexpectedParms.toString().isEmpty()) {
                    diag.append("\t unexpected parameters : ").append(unexpectedParms.toString()).append("\n");
                }
                if (!missingParmsDigest.isEmpty()) {
                    for (Map.Entry e : missingParmsDigest.entrySet()) {
                        diag.append("\t missing values for configuration ").append((String)e.getKey()).append(" : ").append((String)e.getValue()).append("\n");
                    }
                }
                log.warn((Object)(diag.toString() + "Saving the problematic configurations once they are loaded will fix them."));
                if (BootstrapResourceUtils.getBootstrapSystemProperties().getOrDefault((Object)"org.lsst.ccs.config.require_complete_configurations", "false").equals("true") || this.failOnViewProblems && !System.getProperty("org.lsst.ccs.testcontext", "false").equals("true")) {
                    throw new RuntimeException(diag.append("Load aborted.").toString());
                }
            }
        }
        return this.commitBulkChange(configDesc, isInit, isBuild);
    }

    public void dropAllSubmittedChanges() {
        this.componentParameterHandlers.values().stream().forEach(ConfigurationHandler::dropSubmittedChanges);
    }

    public void dropSubmittedChangesForComponent(String name) {
        this.getParameterSet(name).dropSubmittedChanges();
    }

    public Map<String, String> getSubmittedChangesForComponent(String name) {
        return this.getParameterSet(name).getSubmittedChanges().entrySet().stream().collect(Collectors.toMap(entry -> (String)entry.getKey(), entry -> (String)entry.getValue()));
    }

    public Map<String, Map<String, String>> getAllSubmittedChanges() {
        TreeMap<String, Map<String, String>> res = new TreeMap<String, Map<String, String>>();
        for (Map.Entry<String, ConfigurationHandler> entry : this.componentParameterHandlers.entrySet()) {
            Map<String, String> submittedChanges = this.getSubmittedChangesForComponent(entry.getKey());
            if (submittedChanges.isEmpty()) continue;
            res.put(entry.getKey(), new TreeMap<String, String>(submittedChanges));
        }
        return res;
    }

    public Object submitChange(String componentName, String parameterName, Object value, boolean readOnlyOk) {
        if (!this.isParameterConfigurable(componentName, parameterName)) {
            throw new IllegalArgumentException(componentName + "/" + parameterName + " is not a valid configuration parameter.");
        }
        if (this.isParameterReadOnly(componentName, parameterName) && !readOnlyOk) {
            throw new IllegalArgumentException(componentName + "/" + parameterName + " is a read-only configuration parameter.");
        }
        if (this.isBuildParameter(componentName, parameterName) && this.failForBuildParameters) {
            if (!this.isValueEqualToLoadedValue(componentName, parameterName, value)) {
                throw new IllegalArgumentException(componentName + "/" + parameterName + " is a build configuration parameter and cannot be modified at runtime");
            }
        } else if (this.isFinalParameter(componentName, parameterName) && this.failForFinalParameters && !this.isValueEqualToLoadedValue(componentName, parameterName, value)) {
            throw new IllegalArgumentException(componentName + "/" + parameterName + " is a final configuration parameter and cannot be modified at runtime");
        }
        return this.getParameterSet(componentName).submitChange(parameterName, value);
    }

    public Object submitChange(String componentName, String parameterName, Object value) {
        return this.submitChange(componentName, parameterName, value, false);
    }

    public boolean hasSubmittedChanges() {
        for (Map.Entry<String, ConfigurationHandler> e1 : this.componentParameterHandlers.entrySet()) {
            if (!e1.getValue().hasSubmittedChanges()) continue;
            return true;
        }
        return false;
    }

    public ConfigurationView commitBulkChange(ConfigurationDescription categoriesToCommit) {
        return this.commitBulkChange(categoriesToCommit, false, false);
    }

    public ConfigurationView commitBulkChange(ConfigurationDescription categoriesToCommit, String component) {
        return this.commitBulkChange(categoriesToCommit, false, false, component);
    }

    private ConfigurationView commitBulkChange(ConfigurationDescription categoriesToCommit, boolean isInit, boolean isBuild) {
        return this.commitBulkChange(categoriesToCommit, isInit, isBuild, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConfigurationView commitBulkChange(ConfigurationDescription categoriesToCommit, boolean isInit, boolean isBuild, String component) {
        ConfigurationView diff;
        LinkedHashMap<String, ConfigurationHandler> componentHandlers;
        ConfigurationView submittedChanges;
        ConfigurationView before;
        block20: {
            before = this.getLiveConfigurationView();
            submittedChanges = new ConfigurationView();
            componentHandlers = new LinkedHashMap<String, ConfigurationHandler>();
            if (component == null) {
                componentHandlers.putAll(this.componentParameterHandlers);
            } else {
                componentHandlers.put(component, this.componentParameterHandlers.get(component));
            }
            for (Map.Entry<String, ConfigurationHandler> entry : this.componentParameterHandlers.entrySet()) {
                for (Map.Entry<String, String> e : entry.getValue().getSubmittedChanges().entrySet()) {
                    submittedChanges.putParameterValue(entry.getKey(), e.getKey(), e.getValue());
                }
            }
            log.fine((Object)("processing the following submitted changes :" + submittedChanges.getAsParameterPathMap()));
            BulkValidationException excThrown = null;
            if (!isBuild) {
                try {
                    for (ConfigurationHandler ch : this.componentParameterHandlers.values()) {
                        ch.invokeValidateBulkChange(isInit);
                    }
                }
                catch (Exception exception) {
                    excThrown = new BulkValidationException(exception);
                    return excThrown;
                }
                finally {
                    ConfigurationView configurationView = this.getLiveConfigurationView();
                    diff = before.diff(configurationView);
                    if (!diff.isEmpty()) {
                        this.dropAllSubmittedChanges();
                        Set<ParameterPath> suspect = diff.getAsParameterPathMap().keySet();
                        throw new BulkSettingException("some parameters have been modified during the validation step : " + suspect, excThrown);
                    }
                    if (excThrown == null) break block20;
                    throw excThrown;
                }
            }
        }
        for (Map.Entry entry : componentHandlers.entrySet()) {
            ConfigurationHandler ch = (ConfigurationHandler)entry.getValue();
            try {
                ch.invokeSetParameters(before.getValuesForComponent((String)entry.getKey()), isBuild);
            }
            catch (Exception exception) {
                this.dropAllSubmittedChanges();
                throw new BulkSettingException("Problem setting parameter " + (String)entry.getKey() + ": " + exception.getMessage(), exception);
            }
        }
        ConfigurationView configurationView = this.getLiveConfigurationView();
        diff = before.diff(configurationView);
        for (Map.Entry<ParameterPath, String> entry : diff.getAsParameterPathMap().entrySet()) {
            ParameterPath path = entry.getKey();
            if (this.isParameterReadOnly(path.getComponentName(), path.getParameterName())) continue;
            if (!submittedChanges.containsPath(path)) {
                this.dropAllSubmittedChanges();
                throw new BulkSettingException("the parameter " + path + " was not supposed to change from " + before.getPathValue(path) + " to " + entry.getValue());
            }
            if (submittedChanges.getPathValue(path).equals(entry.getValue())) continue;
            this.dropAllSubmittedChanges();
            throw new BulkSettingException("wrong value for parameter : " + path.toString() + ", expected : " + submittedChanges.getPathValue(path) + ", actual : " + entry.getValue());
        }
        for (Map.Entry<Object, String> entry : componentHandlers.entrySet()) {
            ConfigurationHandler ch = (ConfigurationHandler)((Object)entry.getValue());
            try {
                ch.dropSubmittedChanges();
            }
            catch (Exception ex) {
                this.dropAllSubmittedChanges();
                throw new BulkSettingException(ex.getMessage(), ex);
            }
        }
        configurationView.setConfigurationDescription(categoriesToCommit);
        return configurationView;
    }

    public ConfigurationView setSingleParameter(String componentName, String parameterName, Object value) {
        return this.setSingleParameter(componentName, parameterName, value, false);
    }

    public ConfigurationView setSingleParameter(String componentName, String parameterName, Object value, boolean isReadOnlyOk) {
        if (!this.isParameterConfigurable(componentName, parameterName)) {
            log.info((Object)("no such parameter " + new ParameterPath(componentName, parameterName)));
            return new ConfigurationView();
        }
        if (this.hasSubmittedChanges()) {
            throw new RuntimeException("Cannot change single parameter with outstanding submitted changes.");
        }
        ConfigurationView view = null;
        try {
            this.submitChange(componentName, parameterName, value, isReadOnlyOk);
            view = this.commitBulkChange(null);
        }
        catch (Exception e) {
            this.dropAllSubmittedChanges();
            throw e;
        }
        return view;
    }

    public Map<String, String> getCurrentValuesForComponent(String componentName, Set<String> categorySet) {
        return this.getParameterSet(componentName).getCurrentValues(categorySet).entrySet().stream().collect(Collectors.toMap(entry -> ((ParameterPath)entry.getKey()).getParameterName(), entry -> (String)entry.getValue()));
    }

    public ConfigurationView getLiveConfigurationView() {
        ConfigurationView res = new ConfigurationView();
        for (String compName : this.componentParameterHandlers.keySet()) {
            res.putValuesForComponent(compName, this.getCurrentValuesForComponent(compName, this.categories));
        }
        return res;
    }

    public Set<String> getConfigurableComponents() {
        return this.componentParameterHandlers.keySet();
    }
}

