/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.bus.messages;

import org.lsst.ccs.bus.data.RaisedAlertHistory;
import org.lsst.ccs.bus.data.RaisedAlertSummary;
import org.lsst.ccs.bus.messages.StatusAlert;
import org.lsst.ccs.bus.states.AlertState;

public final class StatusClearedAlert
extends StatusAlert<String[], Object> {
    private static final long serialVersionUID = 382404850729235L;

    public StatusClearedAlert(String[] clearAlertIds, RaisedAlertSummary raisedAlertSummary) {
        super(clearAlertIds, raisedAlertSummary);
    }

    public String[] getClearAlertIds() {
        return (String[])this.getObject();
    }

    @Override
    protected Object encodeObject(String[] obj) {
        return null;
    }

    public boolean isPartialClear(String id) {
        for (String clearedId : this.getClearAlertIds()) {
            if (!clearedId.equals(id)) continue;
            return this.getRaisedAlertSummary().getRaisedAlert(clearedId) != null;
        }
        throw new IllegalArgumentException("Alert id = " + id + " was not cleared.");
    }

    public AlertState getStateForClearedAlert(String id) {
        for (String clearedId : this.getClearAlertIds()) {
            if (!clearedId.equals(id)) continue;
            RaisedAlertHistory history = this.getRaisedAlertSummary().getRaisedAlert(clearedId);
            return history == null ? AlertState.NOMINAL : history.getHighestAlertState();
        }
        throw new IllegalArgumentException("Alert id = " + id + " was not cleared.");
    }
}

