/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.focalplane.ui.view;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Map;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import org.lsst.ccs.gconsole.base.Const;
import org.lsst.ccs.gconsole.base.filter.AgentChannelsFilter;
import org.lsst.ccs.gconsole.base.filter.PersistableAgentChannelsFilter;
import org.lsst.ccs.gconsole.plugins.monitor.AbstractMonitorView3;
import org.lsst.ccs.gconsole.plugins.monitor.DisplayChannel;
import org.lsst.ccs.gconsole.plugins.monitor.FormattedValue;
import org.lsst.ccs.gconsole.plugins.monitor.MonitorCell;
import org.lsst.ccs.gconsole.plugins.monitor.MonitorField;
import org.lsst.ccs.gconsole.plugins.monitor.MonitorFormat;
import org.lsst.ccs.gconsole.plugins.monitor.MonitorTableCellRenderer;
import org.lsst.ccs.gconsole.plugins.monitor.PersistableMonitorView;
import org.lsst.ccs.gconsole.plugins.monitor.Updatable;
import org.lsst.ccs.gconsole.services.persist.Persistable;
import org.lsst.ccs.gconsole.util.ThreadUtil;
import org.lsst.ccs.subsystem.focalplane.ui.Segment;

public class FocalPlaneDiagramView
extends AbstractMonitorView3
implements PersistableMonitorView {
    private static final MonitorField DEFAULT_FIELD = MonitorField.AVERAGE_VALUE;
    private static final MonitorField[] AVAILABLE_FIELDS = new MonitorField[]{MonitorField.AVERAGE_VALUE, MonitorField.MAX_VALUE, MonitorField.MIN_VALUE};
    private final Descriptor descriptor = new Descriptor();
    private MonitorField field = MonitorField.AVERAGE_VALUE;
    private ArrayList<MonitorField> filterFields;
    private ArrayList<String> groups;
    private final EnumSet<Segment> hasSegment = EnumSet.noneOf(Segment.class);
    private volatile PersistableAgentChannelsFilter filter;
    private JScrollPane scrollPane;
    private JPanel rootPanel;
    private JButton backButton;
    private JComboBox<String> groupCombo;
    private JComboBox<MonitorField> fieldCombo;
    private Table table;
    private boolean armed = true;
    private Segment level = Segment.RAFT;

    public JComponent getPanel() {
        if (this.scrollPane == null) {
            this.rootPanel = new JPanel(new BorderLayout());
            this.scrollPane = new JScrollPane(this.rootPanel);
            Box top = Box.createHorizontalBox();
            this.rootPanel.add((Component)top, "North");
            top.add(Box.createRigidArea(Const.HDIM));
            this.backButton = new JButton("Back");
            top.add(this.backButton);
            this.backButton.addActionListener(e -> System.out.println("FIXME"));
            top.add(Box.createRigidArea(Const.HDIM));
            top.add(new JLabel("Display channel: "));
            this.groupCombo = new JComboBox();
            this.groupCombo.setPrototypeDisplayValue("123456789012345678901234567890");
            this.groupCombo.addActionListener(e -> {
                int i = this.groupCombo.getSelectedIndex();
                if (this.armed || i >= 0) {
                    this.descriptor.setGroup(this.groups.get(i));
                    if (this.filterFields != null) {
                        this.field = this.filterFields.get(i);
                        this.armed = false;
                        this.fieldCombo.setSelectedItem(this.field);
                        this.armed = true;
                    }
                    this.replaceModel();
                }
            });
            top.add(this.groupCombo);
            top.add(Box.createRigidArea(Const.HDIM));
            top.add(new JLabel("Display field: "));
            this.fieldCombo = new JComboBox<MonitorField>(AVAILABLE_FIELDS);
            this.fieldCombo.setToolTipText("What to display for this channel");
            this.fieldCombo.addActionListener(e -> {
                if (this.armed) {
                    this.field = (MonitorField)this.fieldCombo.getSelectedItem();
                    this.filterFields = null;
                    this.descriptor.setField(this.field.getTitle());
                    this.table.getModel().clear();
                }
            });
            top.add(this.fieldCombo);
            top.add(Box.createRigidArea(Const.HDIM));
            top.add(Box.createHorizontalGlue());
            this.table = new Table();
            this.rootPanel.add((Component)this.table, "Center");
            this.resetChannels();
        }
        return this.scrollPane;
    }

    public PersistableAgentChannelsFilter getFilter() {
        return this.filter;
    }

    public void setFilter(AgentChannelsFilter filter) {
        PersistableAgentChannelsFilter f;
        if (filter instanceof PersistableAgentChannelsFilter && "FocalPlaneFilter".equals((f = (PersistableAgentChannelsFilter)filter).getCategory())) {
            this.filter = f;
            return;
        }
        throw new IllegalArgumentException("FocalPlaneDiagramView only accepts filters from FocalPlaneFilter category.");
    }

    public void install() {
        ThreadUtil.invokeLater(this::start);
        super.install();
    }

    public void uninstall() {
        super.uninstall();
        ThreadUtil.invokeLater(this::stop);
    }

    private void start() {
        if (this.filter == null) {
            throw new IllegalStateException("Trying to initialize SummaryTableView without a filter.");
        }
    }

    private void stop() {
        if (this.table != null) {
            this.table.getModel().destroy();
            this.table = null;
        }
    }

    protected void resetChannels() {
        this.armed = false;
        this.groups = this.getGroups();
        this.groupCombo.setModel(new DefaultComboBoxModel<String>(this.groups.toArray(new String[0])));
        if (this.groups.isEmpty()) {
            this.groupCombo.setEnabled(false);
        } else {
            this.groupCombo.setEnabled(true);
            this.groupCombo.setSelectedItem(this.descriptor.getGroup());
            if (this.groupCombo.getSelectedIndex() == -1) {
                this.groupCombo.setSelectedIndex(0);
                this.descriptor.setGroup(this.groups.get(0));
            }
        }
        String selectedField = this.descriptor.getField();
        if (selectedField == null) {
            this.filterFields = this.getGroupFields();
            if (this.filterFields == null || this.filterFields.size() != this.groups.size()) {
                this.filterFields = null;
                this.field = DEFAULT_FIELD;
            }
        } else {
            this.field = this.stringToField(selectedField);
        }
        this.fieldCombo.setSelectedItem(this.field);
        this.hasSegment.clear();
        for (String path : this.data.keySet()) {
            int[] indices = Segment.getIndices(path);
            if (indices[0] != -1) {
                this.hasSegment.add(Segment.RAFT);
            }
            if (indices[2] != -1 && indices[3] == -1) {
                this.hasSegment.add(Segment.REB);
            }
            if (indices[3] != -1) {
                this.hasSegment.add(Segment.CCD);
            }
            if (indices[4] == -1) continue;
            this.hasSegment.add(Segment.AMP);
        }
        this.replaceModel();
        this.armed = true;
    }

    protected void update() {
        if (this.table != null) {
            this.table.getModel().fireTableDataChanged();
        }
    }

    private void replaceModel() {
        this.table.getModel().destroy();
        Model model = new Model();
        this.table.setModel(model);
    }

    public Descriptor getDescriptor() {
        return this.descriptor;
    }

    private Integer encodeSegment(int[] indices) {
        int out = 0;
        int shift = 0;
        for (int i = 0; i < 4; ++i) {
            int k = indices[i];
            if (k == -1) {
                k = 9;
            }
            out += k * 10 * shift++;
        }
        return out == 9999 ? null : Integer.valueOf(out);
    }

    private int[] decodeSegment(Integer code) {
        int[] out = new int[]{-1, -1, -1, -1, -1, -1};
        if (code == null) {
            return out;
        }
        for (int i = 0; i < 4; ++i) {
            int k = code % 10;
            if (k != 9) {
                out[i] = k;
            }
            code = code / 10;
        }
        return out;
    }

    public static class Descriptor
    extends Persistable.Descriptor {
        private String group;
        private String field;
        private Integer segment;

        public String getGroup() {
            return this.group;
        }

        public void setGroup(String group) {
            this.group = group;
        }

        public String getField() {
            return this.field;
        }

        public void setField(String field) {
            this.field = field;
        }

        public Integer getSegment() {
            return this.segment;
        }

        public void setSegment(Integer segment) {
            this.segment = segment;
        }
    }

    private class Cell
    implements MonitorCell,
    Updatable {
        private final ArrayList<DisplayChannel> channels;
        private FormattedValue formattedValue;

        Cell(ArrayList<DisplayChannel> channels) {
            this.channels = channels;
        }

        Cell() {
            this.channels = new ArrayList();
        }

        public ArrayList<DisplayChannel> getChannels() {
            return this.channels;
        }

        public MonitorField getField() {
            return FocalPlaneDiagramView.this.field;
        }

        public FormattedValue getFormattedValue() {
            return this.formattedValue;
        }

        public void setFormattedValue(FormattedValue formattedValue) {
            this.formattedValue = formattedValue;
        }

        public void update(DisplayChannel channelHandle) {
            this.formattedValue = null;
        }
    }

    private class Model
    extends AbstractTableModel {
        int nRows;
        int nColumns;
        Cell[][] cells;

        Model(boolean empty) {
            this.nRows = 0;
            this.nColumns = 0;
            this.cells = new Cell[0][0];
        }

        Model() {
            int[] indices = FocalPlaneDiagramView.this.decodeSegment(FocalPlaneDiagramView.this.descriptor.getSegment());
            if (indices[0] == -1) {
                this.nRows = 3;
                this.nColumns = 3;
                FocalPlaneDiagramView.this.level = Segment.RAFT;
            } else if (indices[2] == -1 && FocalPlaneDiagramView.this.hasSegment.contains((Object)Segment.REB)) {
                this.nRows = 3;
                this.nColumns = 1;
                FocalPlaneDiagramView.this.level = Segment.REB;
            } else if (indices[2] == -1 || indices[3] == -1) {
                this.nRows = 3;
                this.nColumns = 3;
                FocalPlaneDiagramView.this.level = Segment.CCD;
                indices[2] = -1;
            } else {
                this.nRows = 2;
                this.nColumns = 8;
                FocalPlaneDiagramView.this.level = Segment.AMP;
            }
            String prefix = Segment.getPathPrefix(indices);
            this.cells = new Cell[this.nRows][this.nColumns];
            for (int row = 0; row < this.nRows; ++row) {
                for (int col = 0; col < this.nColumns; ++col) {
                    this.cells[row][col] = new Cell();
                }
            }
            for (Map.Entry e : FocalPlaneDiagramView.this.data.entrySet()) {
                int[] ii;
                String path = (String)e.getKey();
                if (!path.startsWith(prefix) || (ii = Segment.getIndices(path)) == null) continue;
                try {
                    Cell cell = null;
                    switch (FocalPlaneDiagramView.this.level) {
                        case RAFT: {
                            cell = this.cells[ii[0]][ii[1]];
                            break;
                        }
                        case REB: {
                            cell = this.cells[ii[2]][0];
                            break;
                        }
                        case CCD: {
                            cell = this.cells[ii[2]][ii[3]];
                            break;
                        }
                        case AMP: {
                            cell = this.cells[ii[4]][ii[5]];
                        }
                    }
                    DisplayChannel dc = (DisplayChannel)e.getValue();
                    ((ArrayList)cell.getChannels()).add(dc);
                    dc.setTarget((Updatable)cell);
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
            }
            for (int row = 0; row < this.nRows; ++row) {
                for (int col = 0; col < this.nColumns; ++col) {
                    ((ArrayList)this.cells[row][col].getChannels()).trimToSize();
                }
            }
        }

        @Override
        public int getRowCount() {
            return this.nRows;
        }

        @Override
        public int getColumnCount() {
            return this.nColumns;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            Cell cell = this.cells[rowIndex][columnIndex];
            FormattedValue fv = cell.getFormattedValue();
            if (fv == null) {
                MonitorFormat.DEFAULT.format((MonitorCell)cell);
                fv = cell.getFormattedValue();
            }
            return fv;
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return FormattedValue.class;
        }

        void destroy() {
            for (int row = 0; row < this.nRows; ++row) {
                for (int col = 0; col < this.nColumns; ++col) {
                    Cell cell = this.cells[row][col];
                    for (DisplayChannel dc : cell.getChannels()) {
                        dc.setTarget(null);
                    }
                }
            }
        }

        void clear() {
            for (int row = 0; row < this.nRows; ++row) {
                for (int col = 0; col < this.nColumns; ++col) {
                    this.cells[row][col].setFormattedValue(null);
                }
            }
            this.fireTableDataChanged();
        }
    }

    private final class Table
    extends JTable {
        Table() {
            super(new Model(true));
            this.setDefaultRenderer(FormattedValue.class, (TableCellRenderer)new MonitorTableCellRenderer());
            this.setRowSelectionAllowed(true);
            this.setColumnSelectionAllowed(false);
            this.setShowGrid(true);
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    Table.this.mouseClick(e);
                }
            });
        }

        @Override
        public Model getModel() {
            return (Model)super.getModel();
        }

        private void mouseClick(MouseEvent e) {
            int nClick = e.getClickCount();
            Point point = e.getPoint();
            Table table = (Table)e.getSource();
            int row = table.rowAtPoint(point);
            int column = table.columnAtPoint(point);
            if (nClick == 2) {
                int[] indices = FocalPlaneDiagramView.this.decodeSegment(FocalPlaneDiagramView.this.descriptor.getSegment());
                switch (FocalPlaneDiagramView.this.level) {
                    case RAFT: {
                        indices[0] = row;
                        indices[1] = column;
                        break;
                    }
                    case REB: {
                        indices[2] = row;
                        break;
                    }
                    case CCD: {
                        indices[2] = row;
                        indices[3] = column;
                        break;
                    }
                    default: {
                        return;
                    }
                }
                FocalPlaneDiagramView.this.descriptor.setSegment(FocalPlaneDiagramView.this.encodeSegment(indices));
                FocalPlaneDiagramView.this.replaceModel();
            }
        }
    }
}

