/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.focalplane.ui.fpmap;

import java.awt.Color;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.data.ConfigurationParameterInfo;
import org.lsst.ccs.bus.states.DataProviderState;
import org.lsst.ccs.gconsole.base.filter.AgentChannelsFilter;
import org.lsst.ccs.gconsole.plugins.monitor.AbstractMonitorView2;
import org.lsst.ccs.gconsole.plugins.monitor.DefaultMonitorCell;
import org.lsst.ccs.gconsole.plugins.monitor.DisplayChannel;
import org.lsst.ccs.gconsole.plugins.monitor.MonitorField;
import org.lsst.ccs.gconsole.plugins.monitor.MonitorFormat;
import org.lsst.ccs.gconsole.plugins.monitor.Updatable;
import org.lsst.ccs.gconsole.services.aggregator.AgentChannel;
import org.lsst.ccs.gconsole.services.aggregator.AgentStatusEvent;
import org.lsst.ccs.gconsole.services.persist.Persistable;
import org.lsst.ccs.subsystem.focalplane.ui.Segment;
import org.lsst.ccs.subsystem.focalplane.ui.filter.TemplateFilter;
import org.lsst.ccs.subsystem.focalplane.ui.fpmap.AbstractFocalPlaneMapModel;
import org.lsst.ccs.subsystem.focalplane.ui.fpmap.FocalPlaneMapModel;
import org.lsst.ccs.subsystem.focalplane.ui.fpmap.FocalPlaneMapModelEvent;
import org.lsst.ccs.subsystem.focalplane.ui.fpmap.FocalPlaneMapModelListener;
import org.lsst.ccs.subsystem.focalplane.ui.fpmap.FocalPlaneMapValue;

public class MonitorViewModel
extends AbstractMonitorView2 {
    private Persistable.Descriptor descriptor = new Persistable.Descriptor();
    private final Model model = new Model();
    private Cell root;
    private static final Color COLOR_ALARM = Color.RED;
    private static final Color COLOR_WARNING = Color.ORANGE;
    private static final Color COLOR_NOMINAL = new Color(0, 200, 0);
    private static final int RGB_WARNING = COLOR_WARNING.getRGB() & 0xFFFFFF;
    private static final int RGB_NOMINAL = COLOR_NOMINAL.getRGB() & 0xFFFFFF;

    protected void disconnect(AgentInfo agent) {
        super.disconnect(agent);
        this.model.notifyListeners(new FocalPlaneMapModelEvent(this.model));
    }

    public void statusChanged(AgentStatusEvent event) {
        super.statusChanged(event);
        SwingUtilities.invokeLater(() -> this.model.notifyListeners(new FocalPlaneMapModelEvent(this.model)));
    }

    protected void resetChannels() {
        this.root = new Cell();
        this.root.setFormattedValue(FocalPlaneMapValue.NONE);
        Iterator it = this.path2data.entrySet().iterator();
        while (it.hasNext()) {
            DisplayChannel ch = (DisplayChannel)it.next().getValue();
            AgentChannel channel = ch.getChannel();
            int[] indices = Segment.getIndices(channel);
            if (indices == null) {
                it.remove();
                continue;
            }
            Cell cell = this.addOrGetChild(indices);
            cell.add(ch);
            ch.setTarget((Updatable)cell);
        }
        this.root.trim();
        this.model.notifyListeners(new FocalPlaneMapModelEvent(this.model));
    }

    private Cell addOrGetChild(int ... indices) {
        Cell cell = this.root;
        for (int i = 0; i < indices.length; ++i) {
            Cell child;
            int index = indices[i];
            if (index == -1) {
                return cell;
            }
            if (cell.children == null) {
                cell.children = new Cell[Segment.N[i]];
            }
            if ((child = cell.children[index]) == null) {
                child = new Cell();
                child.parent = cell;
                cell.children[index] = child;
            }
            cell = child;
        }
        return cell;
    }

    public JComponent getPanel() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public FocalPlaneMapModel getFocalPlaneMapModel() {
        return this.model;
    }

    private void format(Cell cell) {
        if (cell.getChannels().isEmpty()) {
            cell.setFormattedValue(FocalPlaneMapValue.NONE);
            return;
        }
        FocalPlaneMapValue parentValue = FocalPlaneMapValue.NONE;
        Cell parent = cell.parent;
        while (parentValue == FocalPlaneMapValue.NONE && parent != null) {
            parentValue = parent.getFormattedValue();
            if (parentValue == null) {
                this.format(parent);
                parentValue = parent.getFormattedValue();
            }
            parent = parent.parent;
        }
        FocalPlaneMapValue fv = new FocalPlaneMapValue();
        fv.setSplit(cell.children != null);
        Color color = fv.bgColor = parentValue == FocalPlaneMapValue.NONE ? null : parentValue.getBgColor();
        if (fv.bgColor == null && cell.getChannels().size() == 1) {
            AgentChannel channel = ((DisplayChannel)cell.getChannels().get(0)).getChannel();
            if (channel == null) {
                fv.bgColor = MonitorFormat.COLOR_OFF;
            } else {
                fv.toolTip = "<html>" + channel.getPath() + "<br>" + channel.get();
                fv.bgColor = this.computeColor(channel);
            }
        } else {
            for (DisplayChannel ch : cell.getChannels()) {
                Color c = this.computeColor(ch.getChannel());
                fv.bgColor = this.mergeColor(c, fv.bgColor);
            }
        }
        cell.setFormattedValue(fv);
    }

    private Color computeColor(AgentChannel channel) {
        DataProviderState state = (DataProviderState)channel.get((Object)"state");
        Color color = Color.LIGHT_GRAY;
        if (state != null) {
            switch (state) {
                case ALARM: {
                    return Color.RED;
                }
                case WARNING: {
                    color = COLOR_WARNING;
                    break;
                }
                case NOMINAL: {
                    int alpha = 255;
                    try {
                        double high;
                        double low;
                        double v = this.getDouble(channel, "value");
                        try {
                            low = this.getDouble(channel, "dbandLo");
                            low = this.getDouble(channel, "limitLo") + low;
                        }
                        catch (RuntimeException x) {
                            low = this.getDouble(channel, "limitLo");
                        }
                        try {
                            high = this.getDouble(channel, "dbandHi");
                            high = this.getDouble(channel, "limitHi") - high;
                        }
                        catch (RuntimeException x) {
                            high = this.getDouble(channel, "limitHi");
                        }
                        double d = (high - low) / 4.0;
                        double a = Math.min((v - low) / d, (high - v) / d);
                        alpha = (int)(a * 255.0);
                        if (alpha >= 255) {
                            return COLOR_NOMINAL;
                        }
                        if (alpha < 70) {
                            alpha = 70;
                        }
                        return new Color(RGB_NOMINAL | alpha << 24, true);
                    }
                    catch (RuntimeException x) {
                        return COLOR_NOMINAL;
                    }
                }
                default: {
                    color = (Color)MonitorFormat.COLOR_STATE.get(state);
                }
            }
        }
        return color;
    }

    private Color mergeColor(Color c1, Color c2) {
        if (c2 == null) {
            return c1;
        }
        if (COLOR_ALARM.equals(c1) || COLOR_ALARM.equals(c2)) {
            return COLOR_ALARM;
        }
        int rgb1 = c1.getRGB() & 0xFFFFFF;
        int rgb2 = c2.getRGB() & 0xFFFFFF;
        if (rgb1 != RGB_WARNING && rgb1 != RGB_NOMINAL) {
            return c2;
        }
        if (rgb2 != RGB_WARNING && rgb2 != RGB_NOMINAL) {
            return c1;
        }
        if (rgb1 == RGB_NOMINAL) {
            if (rgb2 == RGB_NOMINAL) {
                return c1.getAlpha() < c2.getAlpha() ? c1 : c2;
            }
            return c2;
        }
        if (rgb2 == RGB_NOMINAL) {
            return c1;
        }
        return c1.getAlpha() > c2.getAlpha() ? c1 : c2;
    }

    private double getDouble(AgentChannel channel, String key) {
        Object o = channel.get((Object)key);
        if (o == null) {
            throw new RuntimeException();
        }
        if (o instanceof ConfigurationParameterInfo) {
            o = ((ConfigurationParameterInfo)o).getCurrentValue();
        }
        double value = o instanceof Double ? (Double)o : Double.parseDouble(o.toString());
        return value;
    }

    public Persistable.Descriptor getDescriptor() {
        return this.descriptor;
    }

    private static class Cell
    extends DefaultMonitorCell
    implements Updatable {
        Cell parent;
        Cell[] children;

        Cell() {
            super(new ArrayList(1), MonitorField.NULL);
        }

        void add(DisplayChannel channelHandle) {
            this.items.add(channelHandle);
        }

        Cell getChild(int ... indices) {
            Cell cell = this;
            for (int i = 0; i < indices.length; ++i) {
                int index = indices[i];
                if (index == -1) {
                    return cell;
                }
                if (cell.children == null) {
                    return null;
                }
                cell = cell.children[index];
                if (cell != null) continue;
                return null;
            }
            return cell;
        }

        void trim() {
            if (this.items.isEmpty()) {
                this.items = Collections.emptyList();
            } else {
                ((ArrayList)this.items).trimToSize();
            }
            if (this.children != null) {
                for (Cell c : this.children) {
                    if (c == null) continue;
                    c.trim();
                }
            }
        }

        public void update(DisplayChannel channelHandle, List<MonitorField> fields) {
            this.update(channelHandle);
        }

        public void update(DisplayChannel channelHandle) {
            if (!this.items.isEmpty()) {
                this.setFormattedValue(null);
            }
            if (this.children != null) {
                for (Cell c : this.children) {
                    if (c == null) continue;
                    c.update(channelHandle);
                }
            }
        }

        public FocalPlaneMapValue getFormattedValue() {
            return (FocalPlaneMapValue)super.getFormattedValue();
        }
    }

    private class Model
    extends AbstractFocalPlaneMapModel {
        private Model() {
        }

        @Override
        public String getTitle() {
            AgentChannelsFilter filter = MonitorViewModel.this.getFilter();
            return filter == null ? null : filter.getName();
        }

        @Override
        public void addFocalPlaneMapModelListener(FocalPlaneMapModelListener listener) {
            if (this.listeners.isEmpty()) {
                MonitorViewModel.this.install();
            }
            super.addFocalPlaneMapModelListener(listener);
        }

        @Override
        public void removeFocalPlaneMapModelListener(FocalPlaneMapModelListener listener) {
            super.removeFocalPlaneMapModelListener(listener);
            if (this.listeners.isEmpty()) {
                MonitorViewModel.this.uninstall();
            }
        }

        @Override
        public FocalPlaneMapValue getValue() {
            return FocalPlaneMapValue.EMPTY;
        }

        @Override
        public FocalPlaneMapValue getValue(int raftX, int raftY) {
            return this.get(raftX, raftY);
        }

        @Override
        public FocalPlaneMapValue getValue(int raftX, int raftY, int reb) {
            return this.get(raftX, raftY, reb);
        }

        @Override
        public FocalPlaneMapValue getValue(int raftX, int raftY, int reb, int ccdY) {
            return this.get(raftX, raftY, reb, ccdY);
        }

        @Override
        public FocalPlaneMapValue getValue(int raftX, int raftY, int reb, int ccdY, int ampX, int ampY) {
            return this.get(raftX, raftY, reb, ccdY, ampX, ampY);
        }

        private FocalPlaneMapValue get(int ... indices) {
            if (MonitorViewModel.this.root == null) {
                return null;
            }
            try {
                Cell cell = MonitorViewModel.this.root.getChild(indices);
                if (cell == null) {
                    return null;
                }
                FocalPlaneMapValue fv = cell.getFormattedValue();
                if (fv == null) {
                    MonitorViewModel.this.format(cell);
                }
                return cell.getFormattedValue();
            }
            catch (ArrayIndexOutOfBoundsException x) {
                return null;
            }
        }

        public Serializable save() {
            try {
                TemplateFilter filter = (TemplateFilter)MonitorViewModel.this.getFilter();
                return filter == null ? null : filter.save();
            }
            catch (ClassCastException x) {
                return null;
            }
        }
    }
}

