package org.lsst.ccs.subsystem.focalplane.ui.filter;

import java.util.*;
import org.lsst.ccs.bus.data.DataProviderInfo;
import org.lsst.ccs.gconsole.base.filter.AbstractChannelsFilter;
import org.lsst.ccs.gconsole.plugins.monitor.MonitorField;
import org.lsst.ccs.subsystem.focalplane.data.FocalPlaneDataGroup;

/**
 * Filter that selects channels that belong to a certain {@code FocalPlaneDataGroup}.
 *
 * @author The LSST CCS Team
 */
public class DataGroupFilter extends AbstractChannelsFilter {

    private final FocalPlaneDataGroup dataGroup;
    private String agentName;

    public final static List<String> FIELDS = new ArrayList<>();
    static {
        FIELDS.add(MonitorField.VALUE.getKey());
        FIELDS.add(MonitorField.UNITS.getKey());
        FIELDS.add(MonitorField.LOW_ALARM.getKey());
        FIELDS.add(MonitorField.LOW_WARN.getKey());
        FIELDS.add(MonitorField.ALERT_LOW.getKey());
        FIELDS.add(MonitorField.HIGH_WARN.getKey());
        FIELDS.add(MonitorField.HIGH_ALARM.getKey());
        FIELDS.add(MonitorField.ALERT_HIGH.getKey());
        FIELDS.add(MonitorField.NAME.getKey());
        FIELDS.add(MonitorField.DESCR.getKey());
                
    }

    public DataGroupFilter(String agents, FocalPlaneDataGroup dataGroup) {
        this.dataGroup = dataGroup;
        this.agentName = (agents == null || agents.isEmpty()) ? null : agents;
    }

    @Override
    public String getName() {
        return "FP:"+ dataGroup;
    }
    
    @Override
    public List<String> getAgents() {
        return agentName == null ? null : Collections.singletonList(agentName);
    }

    @Override
    public List<String> getFields(boolean compact) {
        return FIELDS;
    }

    @Override
    public List<String> getOriginChannels() {
        return Collections.singletonList("agent."+DataProviderInfo.Attribute.DATA_GROUP.getName()+"="+dataGroup.getName());
    }
    
    @Override
    public String getDisplayPath(String originPath) {
        int i = originPath.indexOf("/");
        if (agentName == null) {
            agentName = originPath.substring(0,i);
        }
        return originPath.substring(i+1);
    }

    @Override
    public String getOriginPath(String displayPath) {
        return agentName +"/"+ displayPath;
    }
    
}
