/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.focalplane.ui;

import org.lsst.ccs.bus.data.DataProviderInfo;
import org.lsst.ccs.gconsole.services.aggregator.AgentChannel;

public enum Segment {
    RAFT(3, 3, DataProviderInfo.Attribute.RAFT_ID.getName(), "R"){

        @Override
        public int[] parseIndices(int[] indices, String s) {
            int n = s.length();
            if (n != this.path.length() + 2) {
                return null;
            }
            try {
                int x = Integer.parseInt(s.substring(n - 2, n - 1));
                int y = Integer.parseInt(s.substring(n - 1));
                if (x < 0 || x > 2 || y < 0 || y > 2) {
                    return null;
                }
                indices[0] = x;
                indices[1] = y;
            }
            catch (NumberFormatException e) {
                return null;
            }
            return indices;
        }
    }
    ,
    REB(3, 1, DataProviderInfo.Attribute.REB_ID.getName(), "Reb"){

        @Override
        public int[] parseIndices(int[] indices, String s) {
            int n = s.length();
            if (n != this.path.length() + 1) {
                return null;
            }
            try {
                int x = Integer.parseInt(s.substring(n - 1));
                if (x < 0 || x > 2) {
                    return null;
                }
                indices[2] = x;
            }
            catch (NumberFormatException e) {
                return null;
            }
            return indices;
        }
    }
    ,
    CCD(1, 3, DataProviderInfo.Attribute.SENSOR_ID.getName(), "S"){

        @Override
        public int[] parseIndices(int[] indices, String s) {
            int n = s.length();
            if (n != this.path.length() + 2) {
                return null;
            }
            try {
                int x = Integer.parseInt(s.substring(n - 2, n - 1));
                int y = Integer.parseInt(s.substring(n - 1));
                if (x < 0 || x > 2 || y < 0 || y > 2) {
                    return null;
                }
                indices[2] = x;
                indices[3] = y;
            }
            catch (NumberFormatException e) {
                return null;
            }
            return indices;
        }
    }
    ,
    SEGMENT(2, 8, DataProviderInfo.Attribute.AMPLIFIER_ID.getName(), "Segment"){

        @Override
        public int[] parseIndices(int[] indices, String s) {
            int n = s.length();
            if (n != this.path.length() + 2) {
                return null;
            }
            try {
                int x = Integer.parseInt(s.substring(n - 2, n - 1));
                int y = Integer.parseInt(s.substring(n - 1));
                if (x < 0 || x > 1 || y < 0 || y > 7) {
                    return null;
                }
                indices[4] = x;
                indices[5] = y;
            }
            catch (NumberFormatException e) {
                return null;
            }
            return indices;
        }
    };

    final int nX;
    final int nY;
    final String key;
    final String path;
    public static final int[] N;

    private Segment(int nX, int nY, String key, String path) {
        this.nX = nX;
        this.nY = nY;
        this.key = key;
        this.path = path;
    }

    public int getNX() {
        return this.nX;
    }

    public int getNY() {
        return this.nY;
    }

    public String getKey() {
        return this.key;
    }

    public String toString() {
        return this.path;
    }

    public abstract int[] parseIndices(int[] var1, String var2);

    public static int[] getIndices(AgentChannel channel) {
        int[] indices = new int[]{-1, -1, -1, -1, -1, -1};
        try {
            String ID = (String)channel.get((Object)DataProviderInfo.Attribute.RAFT_ID.getName());
            int raftX = Integer.parseInt(ID.substring(1, 2));
            int raftY = Integer.parseInt(ID.substring(2, 3));
            if (raftX < 0 || raftX > 2 || raftY < 0 || raftY > 2) {
                return null;
            }
            indices[0] = raftX;
            indices[1] = raftY;
            ID = (String)channel.get((Object)DataProviderInfo.Attribute.REB_ID.getName());
            int reb = -1;
            if (ID != null) {
                reb = Integer.parseInt(ID.substring(3, 4));
                if (reb < 0 || reb > 2) {
                    return null;
                }
                indices[2] = reb;
            }
            if ((ID = (String)channel.get((Object)DataProviderInfo.Attribute.SENSOR_ID.getName())) != null) {
                int ccdX = Integer.parseInt(ID.substring(1, 2));
                int ccdY = Integer.parseInt(ID.substring(2, 3));
                if (ccdX < 0 || ccdX > 2 || ccdY < 0 || ccdY > 2 || reb != -1 && reb != ccdX) {
                    return null;
                }
                indices[2] = ccdX;
                indices[3] = ccdY;
                ID = (String)channel.get((Object)DataProviderInfo.Attribute.AMPLIFIER_ID.getName());
                if (ID != null) {
                    int ampX = Integer.parseInt(ID.substring(0, 1));
                    int ampY = Integer.parseInt(ID.substring(1, 2));
                    if (ampX < 0 || ampX > 1 || ampY < 0 || ampY > 8) {
                        return null;
                    }
                    indices[4] = ampX;
                    indices[5] = ampY;
                }
            }
            return indices;
        }
        catch (IndexOutOfBoundsException | NullPointerException | NumberFormatException x) {
            return null;
        }
    }

    public static int[] getIndices(String path) {
        String[] ss = path.split("/");
        if (ss.length < 2) {
            return null;
        }
        int[] indices = new int[]{-1, -1, -1, -1, -1, -1};
        int[] out = RAFT.parseIndices(indices, ss[1]);
        if (out == null) {
            return null;
        }
        out = REB.parseIndices(indices, ss[2]);
        int last = out == null ? 2 : 3;
        out = CCD.parseIndices(indices, ss[last]);
        if (out != null) {
            SEGMENT.parseIndices(indices, ss[2]);
        }
        return indices;
    }

    public static String getPathPrefix(int[] indices) {
        StringBuilder sb = new StringBuilder();
        if (indices[0] != -1) {
            sb.append((Object)RAFT).append(indices[0]).append(indices[1]).append("/");
            if (indices[2] != -1) {
                if (indices[3] == -1) {
                    sb.append((Object)REB).append(indices[2]).append("/");
                } else {
                    sb.append((Object)CCD).append(indices[2]).append(indices[3]).append("/");
                    if (indices[4] != -1) {
                        sb.append((Object)SEGMENT).append(indices[4]).append(indices[5]).append("/");
                    }
                }
            }
        }
        return sb.toString();
    }

    static {
        N = new int[]{5, 5, 3, 3, 2, 8};
    }
}

