package org.lsst.ccs.subsystem.focalplane.ui.filter;

import java.util.*;
import org.lsst.ccs.gconsole.services.aggregator.AgentChannel;
import org.lsst.ccs.gconsole.base.filter.AbstractChannelsFilter;
import org.lsst.ccs.gconsole.base.filter.AgentChannelsFilter;
import org.lsst.ccs.gconsole.services.persist.Persistable;
import org.lsst.ccs.subsystem.focalplane.ui.Segment;

/**
 * {@link AgentChannelsFilter} based on a list of {@link Template}s.
 * To be used by {@link FocalPlaneMapView}.
 *
 * @author onoprien
 */
public final class TemplateFilter extends AbstractChannelsFilter {

// -- Fields : -----------------------------------------------------------------
    
    static public final String CATEGORY = "FocalPlaneTemplateFilter";
    
    private final ArrayList<Template> templates;
    
    private final HashSet<String> accept = new HashSet<>();
    private final HashSet<String> reject = new HashSet<>();

// -- Life cycle : -------------------------------------------------------------
    
    public TemplateFilter(Descriptor descriptor) {
        this.descriptor = descriptor;
        String[] tt = descriptor.getTemplates();
        templates = new ArrayList<>(tt.length);
        for (String s : tt) {
            templates.add(Template.valueOf(s));
        }
    }
    
    public TemplateFilter(String title, List<Template> templates, Segment granularity) {
        descriptor = new Descriptor();
        getDescriptor().setName(title);
        String[] tt = new String[templates.size()];
        int i=0;
        for (Template template : templates) {
            tt[i++] = template.toString();
        }
        getDescriptor().setTemplates(tt);
        this.templates = new ArrayList<>(templates);
    }
    
// -- Implementing AgentChannelsFilter : ---------------------------------------
    
    @Override
    public String getName() {
        return descriptor.getName();
    }

    @Override
    public List<String> getAgents() {
        LinkedHashSet<String> aa = new LinkedHashSet<>(getDescriptor().getTemplates().length * 2);
        for (Template t : templates) {
            aa.add(t.code.substring(0, t.code.indexOf("/")));
        }
        return new ArrayList<>(aa);
    }

    @Override
    public String getOriginPath(String displayPath) {
        return displayPath;
    }

    @Override
    public String getDisplayPath(AgentChannel channel) {
        if (channel == null) return null;
        String path = channel.getPath();
        if (accept.contains(path)) return path;
        if (reject.contains(path)) return null;
        Template t = Template.valueOf(channel);
        if (templates.contains(t)) {
            accept.add(path);
            return path;
        } else {
            reject.add(path);
            return null;
        }
    }

 
// -- Saving : -----------------------------------------------------------------

    @Override
    public Descriptor getDescriptor() {
        return (Descriptor) descriptor;
    }
    
    static public class Descriptor extends Persistable.Descriptor {

        private String granularity;
        private String[] templates;

        public String getGranularity() {
            return granularity;
        }

        public void setGranularity(String granularity) {
            this.granularity = granularity;
        }

        public String[] getTemplates() {
            return templates;
        }

        public void setTemplates(String[] templates) {
            this.templates = templates;
        }

    }


}
