/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.focalplane.ui.fpmap;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.io.Serializable;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import org.lsst.ccs.gconsole.agent.AgentChannelsFilter;
import org.lsst.ccs.gconsole.agent.filter.AbstractChannelsFilter;
import org.lsst.ccs.gconsole.base.Console;
import org.lsst.ccs.gconsole.base.Const;
import org.lsst.ccs.gconsole.services.persist.Persistable;
import org.lsst.ccs.gconsole.services.persist.PersistenceService;
import org.lsst.ccs.gconsole.services.persist.Savable;
import org.lsst.ccs.subsystem.focalplane.data.FocalPlaneDataGroup;
import org.lsst.ccs.subsystem.focalplane.ui.FocalPlaneMonitorFilter;
import org.lsst.ccs.subsystem.focalplane.ui.fpmap.ChannelSelectorDialog;
import org.lsst.ccs.subsystem.focalplane.ui.fpmap.FocalPlaneMap;
import org.lsst.ccs.subsystem.focalplane.ui.fpmap.MonitorViewModel;
import org.lsst.ccs.subsystem.focalplane.ui.fpmap.TemplateFilter;

public final class FocalPlaneMapRegion
extends JPanel
implements Savable {
    private static final String CUSTOM = "Custom...";
    private static final String LOAD = "Load...";
    private static final String[] modelFactories;
    private final Descriptor descriptor = new Descriptor();
    private final FocalPlaneMap map;
    private final JLabel titleLabel;
    private final JComboBox<String> comboBox;
    private boolean restoring = false;

    public FocalPlaneMapRegion(Descriptor desc) {
        super(new BorderLayout());
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1), BorderFactory.createLineBorder(Color.BLACK, 1, true)));
        this.map = new FocalPlaneMap();
        this.add((Component)this.map, "Center");
        Box header = Box.createHorizontalBox();
        this.add((Component)header, "North");
        this.comboBox = new JComboBox<String>(modelFactories);
        header.add(this.comboBox);
        this.comboBox.addActionListener(e -> {
            String f = (String)this.comboBox.getSelectedItem();
            if (!this.restoring) {
                this.setCurrentFactory(f);
            }
        });
        header.add(Box.createRigidArea(Const.HDIM));
        this.titleLabel = new JLabel();
        header.add(this.titleLabel);
        header.add(Box.createHorizontalGlue());
        this.restore(desc);
    }

    public void opened() {
    }

    public void closed() {
        this.map.setModel(null);
    }

    public JPopupMenu modifyPopupMenu(JPopupMenu menu) {
        if (this.descriptor.getModel() instanceof TemplateFilter.Descriptor && CUSTOM.equals(this.descriptor.getSelection())) {
            JMenuItem it = new JMenuItem("Save region...");
            it.addActionListener(e -> {
                try {
                    TemplateFilter.Descriptor f = (TemplateFilter.Descriptor)((Object)((Object)this.descriptor.getModel()));
                    f.setCategory("FocalPlaneTemplateFilter");
                    PersistenceService serv = (PersistenceService)Console.getConsole().getSingleton(PersistenceService.class);
                    serv.saveAs((Persistable.Descriptor)f, "Save focal plane map settings", (Component)this);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            });
            menu.insert(it, 0);
        }
        return menu;
    }

    private void setTitle() {
        String title = this.map.getName();
        if (title == null || this.comboBox.getSelectedIndex() > 2) {
            title = "";
        }
        this.titleLabel.setText(title.isEmpty() ? "" : "<html><b>" + title);
    }

    private void setCurrentFactory(String factory) {
        try {
            AbstractChannelsFilter filter = null;
            TemplateFilter.Descriptor d = null;
            if (factory == null || factory.isEmpty()) {
                this.descriptor.setSelection(null);
                this.descriptor.setModel(null);
                this.map.setModel(null);
                return;
            }
            if (CUSTOM.equals(factory)) {
                d = this.descriptor.getModel() instanceof TemplateFilter.Descriptor ? (TemplateFilter.Descriptor)((Object)this.descriptor.getModel()) : null;
                if ((d = ChannelSelectorDialog.show(d, this)) != null) {
                    filter = new TemplateFilter(d);
                }
            } else if (LOAD.equals(factory)) {
                PersistenceService serv = (PersistenceService)Console.getConsole().getSingleton(PersistenceService.class);
                d = (TemplateFilter.Descriptor)serv.load("FocalPlaneTemplateFilter", "Select saved filter", (Component)this);
                if (d != null) {
                    filter = new TemplateFilter(d);
                }
            } else {
                FocalPlaneDataGroup g = FocalPlaneDataGroup.forName((String)factory);
                filter = new FocalPlaneMonitorFilter(this.descriptor.getAgent(), g);
            }
            if (filter == null) {
                throw new RuntimeException();
            }
            MonitorViewModel model = new MonitorViewModel();
            model.setFilter((AgentChannelsFilter)filter);
            this.map.setModel(model.getFocalPlaneMapModel());
            this.descriptor.setSelection(factory);
            this.descriptor.setModel((Serializable)((Object)d));
        }
        catch (Exception x) {
            this.restoring = true;
            this.comboBox.setSelectedItem(this.descriptor.getSelection());
            this.restoring = false;
        }
        this.setTitle();
    }

    public Descriptor save() {
        return this.descriptor;
    }

    public void restore(Serializable bean) {
        if (bean == null) {
            bean = new Descriptor();
        }
        try {
            Descriptor desc = (Descriptor)bean;
            this.descriptor.setAgent(desc.getAgent());
            this.restoring = true;
            this.comboBox.setSelectedIndex(0);
            this.comboBox.setSelectedItem(desc.getSelection());
            AbstractChannelsFilter filter = null;
            if (this.comboBox.getSelectedIndex() != 0) {
                String select = (String)this.comboBox.getSelectedItem();
                this.descriptor.setSelection(select);
                if (desc.getModel() instanceof TemplateFilter.Descriptor) {
                    filter = new TemplateFilter((TemplateFilter.Descriptor)((Object)desc.getModel()));
                    this.descriptor.setModel((Serializable)filter.save());
                } else {
                    try {
                        FocalPlaneDataGroup group = FocalPlaneDataGroup.forName((String)select);
                        filter = new FocalPlaneMonitorFilter(desc.getAgent(), group);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                }
            }
            if (filter == null) {
                this.descriptor.setSelection(null);
                this.descriptor.setModel(null);
                this.map.setModel(null);
            } else {
                MonitorViewModel model = new MonitorViewModel();
                model.setFilter((AgentChannelsFilter)filter);
                this.map.setModel(model.getFocalPlaneMapModel());
            }
            this.setTitle();
        }
        catch (ClassCastException | NullPointerException runtimeException) {
            // empty catch block
        }
        this.restoring = false;
    }

    static {
        FocalPlaneDataGroup[] groups = FocalPlaneDataGroup.values();
        int n = groups.length;
        modelFactories = new String[n + 3];
        FocalPlaneMapRegion.modelFactories[0] = "";
        FocalPlaneMapRegion.modelFactories[1] = CUSTOM;
        FocalPlaneMapRegion.modelFactories[2] = LOAD;
        for (int i = 0; i < n; ++i) {
            FocalPlaneMapRegion.modelFactories[i + 3] = groups[i].getName();
        }
    }

    public static class Descriptor
    implements Serializable {
        private String selection;
        private Serializable model;
        private String agent;

        public String getSelection() {
            return this.selection;
        }

        public void setSelection(String selection) {
            this.selection = selection;
        }

        public Serializable getModel() {
            return this.model;
        }

        public void setModel(Serializable model) {
            this.model = model;
        }

        public String getAgent() {
            return this.agent;
        }

        public void setAgent(String agent) {
            this.agent = agent;
        }
    }
}

