package org.lsst.ccs.subsystem.focalplane.ui.fpmap;

import org.lsst.ccs.bus.data.DataProviderInfo;
import org.lsst.ccs.gconsole.agent.AgentChannel;

/**
 * Enumeration of Focal Plane hardware segments.
 *
 * @author onoprien
 */
public enum Segment {
    
// -- Enum constants : ---------------------------------------------------------
    
    RAFT(3,3, DataProviderInfo.Attribute.RAFT_ID.getName(), "R"),
    REB(3,1, DataProviderInfo.Attribute.REB_ID.getName(), "Reb"),
    CCD(1,3, DataProviderInfo.Attribute.SENSOR_ID.getName(), "S"),
    AMP(2,8, DataProviderInfo.Attribute.AMPLIFIER_ID.getName(), "Amp");
    
// -- Fields : -----------------------------------------------------------------
    
    private final int nX, nY;
    private final String key;
    private final String path;
    
// -- Life cycle : -------------------------------------------------------------
    
    private Segment(int nX, int nY, String key, String path) {
        this.nX = nX;
        this.nY = nY;
        this.key = key;
        this.path = path;
    }

// -- Getters : ----------------------------------------------------------------
    
    public int getNX() {
        return nX;
    }
    
    public int getNY() {
        return nY;
    }

    public String getKey() {
        return key;
    }

    public String getPathPrefix() {
        return path;
    }
    
    
// -- Utility methods : --------------------------------------------------------
    
    static public int[] getIndices(AgentChannel channel) {
        int[] indices = {-1, -1, -1, -1, -1, -1};
        int raftX, raftY;
        String ID;
        try {
            ID = channel.get(DataProviderInfo.Attribute.RAFT_ID.getName());
            raftX = Integer.parseInt(ID.substring(1, 2));
            raftY = Integer.parseInt(ID.substring(2, 3));
            if (raftX < 0 || raftX > 2 || raftY < 0 || raftY > 2) return null;
            indices[0] = raftX;
            indices[1] = raftY;
            ID = channel.get(DataProviderInfo.Attribute.REB_ID.getName());
            int reb = -1;
            if (ID != null) {
                reb = Integer.parseInt(ID.substring(3, 4));
                if (reb < 0 || reb > 2) return null;
                indices[2] = reb;
            }
            ID = channel.get(DataProviderInfo.Attribute.SENSOR_ID.getName());
            if (ID != null) {
                int ccdX = Integer.parseInt(ID.substring(1, 2));
                int ccdY = Integer.parseInt(ID.substring(2, 3));
                if (ccdX < 0 || ccdX > 2 || ccdY < 0 || ccdY > 2 || (reb != -1 && reb != ccdX)) return null;
                indices[2] = ccdX;
                indices[3] = ccdY;
                ID = channel.get(DataProviderInfo.Attribute.AMPLIFIER_ID.getName());
                if (ID != null) {
                    int ampX = Integer.parseInt(ID.substring(0, 1));
                    int ampY = Integer.parseInt(ID.substring(1, 2));
                    if (ampX < 0 || ampX > 1 || ampY < 0 || ampY > 8) return null;
                    indices[4] = ampX;
                    indices[5] = ampY;
                }
            }
            return indices;
        } catch (IndexOutOfBoundsException | NullPointerException | NumberFormatException x) {
            return null;
        }
    }
    
// -- Static constants : -------------------------------------------------------
    
    static public final int[] N = {5,5,3,3,2,8};
    
}
