package org.lsst.ccs.subsystem.focalplane.ui.fpmap;

import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Point;
import java.io.Serializable;
import java.util.*;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import org.freehep.swing.popup.HasPopupItems;
import org.lsst.ccs.gconsole.base.Const;
import org.lsst.ccs.gconsole.services.persist.DataPanelDescriptor;

/**
 * Graphic component that holds a grid of {@link FocalPlaneMapRegion}.
 *
 * @author onoprien
 */
public final class FocalPlaneMapPage extends JPanel implements HasPopupItems {

// -- Fields : -----------------------------------------------------------------
    
    private final Descriptor descriptor;
    private final ArrayList<FocalPlaneMapRegion> regions;

// -- Life cycle : -------------------------------------------------------------

    public FocalPlaneMapPage(Descriptor desc) {
        descriptor = desc == null ? new Descriptor() : desc;
        setLayout(new GridLayout(descriptor.getRows(), descriptor.getColumns(), Const.HSPACE, Const.VSPACE));
        FocalPlaneMapRegion.Descriptor[] regionDescriptors = descriptor.getRegions();
        int n = descriptor.getRows() * descriptor.getColumns();
        regions = new ArrayList<>(n);
        for (int i=0; i<n; i++) {
            FocalPlaneMapRegion.Descriptor regionDesc = regionDescriptors == null ? null : regionDescriptors[i];
            if (regionDesc == null) {
                regionDesc = new FocalPlaneMapRegion.Descriptor();
                regionDesc.setAgent(descriptor.getAgent());
            }
            FocalPlaneMapRegion region = new FocalPlaneMapRegion(regionDesc);
            add(region);
            regions.add(region);
        }
    }
    
    public void opened() {
        regions.forEach(region -> region.opened());
    }
    
    public void closed() {
        regions.forEach(region -> region.closed());
    }

    
// -- Pop-up menu : ------------------------------------------------------------
    
    /**
     * Forwards the call to a {@code FocalPlaneMapRegion}, if any, allowing it to modify the menu.
     * 
     * @param menu Original menu
     * @param component Component.
     * @param point Position.
     * @return Modified menu.
     */
    @Override
    public JPopupMenu modifyPopupMenu(JPopupMenu menu, Component component, Point point) {
        Component c = getComponentAt(point);
        if (c instanceof FocalPlaneMapRegion) {
            ((FocalPlaneMapRegion)c).modifyPopupMenu(menu);
        }
        return menu;
    }
    
    
// -- Saving : -----------------------------------------------------------------
    
    public Descriptor save() {
        int n = regions.size();
        FocalPlaneMapRegion.Descriptor[] regionDescriptors = new FocalPlaneMapRegion.Descriptor[n];
        for (int i = 0; i < n; i++) {
            regionDescriptors[i] = regions.get(i).save();
        }
        descriptor.setRegions(regionDescriptors);
        descriptor.setPage(DataPanelDescriptor.get(this));
        return descriptor;
    }
    
    static public class Descriptor implements Serializable {
        
        public Descriptor() {
            this(null, 1,1);
        }
        
        public Descriptor(String agentName, int nRows, int nColumns) {
            agent = agentName;
            rows = nRows;
            columns = nColumns;
        }

        private String name;
        private String agent;
        private int rows;
        private int columns;
        private FocalPlaneMapRegion.Descriptor[] regions;
        private DataPanelDescriptor page;

        public String getName() {
            return name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getAgent() {
            return agent;
        }

        public void setAgent(String agent) {
            this.agent = agent;
        }
        
        public int getRows() {
            return rows;
        }

        public void setRows(int rows) {
            this.rows = rows;
        }

        public int getColumns() {
            return columns;
        }

        public void setColumns(int columns) {
            this.columns = columns;
        }

        public FocalPlaneMapRegion.Descriptor[] getRegions() {
            return regions;
        }

        public void setRegions(FocalPlaneMapRegion.Descriptor[] regions) {
            this.regions = regions;
        }

        public DataPanelDescriptor getPage() {
            return page;
        }

        public void setPage(DataPanelDescriptor page) {
            this.page = page;
        }
        
    }
    
    
    
    
}
