package org.lsst.ccs.subsystem.focalplane.ui.fpmap;

/**
 * 
 *
 * @author onoprien
 */
public class FocalPlane {

// -- Fields : -----------------------------------------------------------------

// -- Life cycle : -------------------------------------------------------------

    
// -- Conversions between RAFT/CCD indices and IDs : ---------------------------
    
    /**
     * Returns RAFT type for the given CCD ID.
     * @param ccdID CCD ID.
     * @return RAFT type.
     */
    static public CCDType getRaftTypeForCcd(int ccdID) {
        throw new UnsupportedOperationException();
    }
    
    /**
     * Returns RAFT type for the specified RAFT.
     * @param raftX RAFT X index.
     * @param raftY RAFT Y index.
     * @return RAFT type.
     */
    static public CCDType getType(int raftX, int raftY) {
        return (raftX%4 == 0 && raftY%4 == 0) ? CCDType.CORNER : CCDType.SCIENCE;
    }
    
    /**
     * Returns CCD type for the specified CCD.
     * @param raftX RAFT X index.
     * @param raftY RAFT Y index.
     * @param ccdX CCD X index.
     * @param ccdY CCD Y index.
     * @return CCD type.
     */
    static public CCDType getType(int raftX, int raftY, int ccdX, int ccdY) {
        if (getType(raftX, raftY).equals(CCDType.CORNER)) {
            return (raftX == raftY ^ ccdX == ccdY) ? CCDType.GUIDE : CCDType.WAVEFRONT;
        } else {
            return CCDType.SCIENCE;
        }
    }
    
    static public int getRaftIdForCcd(int ccdID) {
        throw new UnsupportedOperationException();
    }
    
    static public int toCcdId(int raftX, int raftY, int ccdX, int ccdY) {
        throw new UnsupportedOperationException();
    }
    
    static public int[] toCcdIndices(int ccdID) {
        throw new UnsupportedOperationException();
    }
}
