package org.lsst.ccs.subsystem.focalplane.ui.fpmap;

import java.util.concurrent.CopyOnWriteArrayList;

/**
 * Adapter class to simplify implementing {@link FocalPlaneMapModel}.
 * Implements handling of listeners.
 *
 * @author onoprien
 */
abstract public class AbstractFocalPlaneMapModel implements FocalPlaneMapModel {

// -- Fields : -----------------------------------------------------------------
    
    protected final CopyOnWriteArrayList<FocalPlaneMapModelListener> listeners = new CopyOnWriteArrayList<>();
    
// -- Handling listeners : -----------------------------------------------------

    @Override
    public void addFocalPlaneMapModelListener(FocalPlaneMapModelListener listener) {
        listeners.addIfAbsent(listener);
    }

    @Override
    public void removeFocalPlaneMapModelListener(FocalPlaneMapModelListener listener) {
        listeners.remove(listener);
    }
    
    protected void notifyListeners(FocalPlaneMapModelEvent event) {
        listeners.forEach(listener -> listener.valueChanged(event));
    }
    
}
