/*
 * Decompiled with CFR 0.152.
 */
package com.l2fprod.common.demo;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.filechooser.FileSystemView;

public class FakeFileSystemView
extends FileSystemView {
    private Map files = new HashMap();

    public FakeFileSystemView() {
        this.files.put("desktop", new FakeFile("Desktop"));
        this.files.put("computer", new FakeFile("My Computer"));
        this.files.put("A", new FakeFile("A"));
        this.files.put("C", new FakeFile("C"));
        this.files.put("D", new FakeFile("D"));
        this.files.put("getFiles(My Computer)", new File[]{(File)this.files.get("A"), (File)this.files.get("C"), (File)this.files.get("D")});
        this.files.put("network", new FakeFile("My Network Places"));
        this.files.put("getRoots", new File[]{(File)this.files.get("desktop")});
        this.files.put("getFiles(Desktop)", new File[]{(File)this.files.get("computer"), (File)this.files.get("network")});
        FakeFile[] folders = new FakeFile[]{new FakeFile("Folder 1"), new FakeFile("Folder 2"), new FakeFile("Folder 3")};
        this.files.put("getFiles(C)", folders);
        this.files.put("getFiles(D)", folders);
    }

    public File createNewFolder(File containingDir) {
        return null;
    }

    public File createFileObject(File dir, String filename) {
        return super.createFileObject(dir, filename);
    }

    public File createFileObject(String path) {
        return super.createFileObject(path);
    }

    protected File createFileSystemRoot(File f) {
        return super.createFileSystemRoot(f);
    }

    public File getChild(File parent, String fileName) {
        return super.getChild(parent, fileName);
    }

    public File getDefaultDirectory() {
        return new FakeFile("Default");
    }

    public File[] getFiles(File dir, boolean useFileHiding) {
        if (dir.getName().startsWith("Folder")) {
            return new FakeFile[]{new FakeFile(dir.getName() + ".1"), new FakeFile(dir.getName() + ".2"), new FakeFile(dir.getName() + ".3")};
        }
        File[] children = (File[])this.files.get("getFiles(" + dir.getName() + ")");
        if (children == null) {
            return new File[0];
        }
        return children;
    }

    public File getHomeDirectory() {
        return new FakeFile("Home");
    }

    public File getParentDirectory(File dir) {
        return null;
    }

    public File[] getRoots() {
        return (File[])this.files.get("getRoots");
    }

    public String getSystemDisplayName(File f) {
        return f.getName();
    }

    public Icon getSystemIcon(File f) {
        return null;
    }

    public String getSystemTypeDescription(File f) {
        return "Description";
    }

    public boolean isComputerNode(File dir) {
        return this.files.get("computer") == dir;
    }

    public boolean isDrive(File dir) {
        return "C".equals(dir.getName()) || "D".equals(dir.getName());
    }

    public boolean isFileSystem(File f) {
        return false;
    }

    public boolean isFileSystemRoot(File dir) {
        return false;
    }

    public boolean isFloppyDrive(File dir) {
        return "A".equals(dir.getName());
    }

    public boolean isHiddenFile(File f) {
        return false;
    }

    public boolean isParent(File folder, File file) {
        return false;
    }

    public boolean isRoot(File f) {
        return this.files.get("desktop") == f;
    }

    public Boolean isTraversable(File f) {
        return Boolean.TRUE;
    }

    static class FakeFile
    extends File {
        public FakeFile(String s) {
            super(s);
        }

        public boolean isDirectory() {
            return true;
        }
    }
}

