/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.functions;

import java.io.StringWriter;
import java.util.Properties;
import javax.xml.transform.stream.StreamResult;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMinor;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.functions.XSLTFunction;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.style.ExpressionContext;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.StaticError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.StringValue;

public class Serialize
extends SystemFunction
implements XSLTFunction {
    Properties outputProperties;
    private transient boolean checked = false;

    public void checkArguments(StaticContext staticContext) throws XPathException {
        if (this.checked) {
            return;
        }
        this.checked = true;
        super.checkArguments(staticContext);
        if (staticContext instanceof ExpressionContext) {
            if (!(this.argument[1] instanceof StringValue)) {
                throw new StaticError("Second argument of saxon:serialize must be known at compile time");
            }
            String string = ((StringValue)this.argument[1]).getStringValue();
            int n = -1;
            if (!string.equals("") && (n = ((ExpressionContext)staticContext).getFingerprint(string, false)) == -1) {
                throw new StaticError("Output format '" + string + "' has not been defined");
            }
            this.outputProperties = ((ExpressionContext)staticContext).getXSLStylesheet().gatherOutputProperties(n);
        } else {
            this.outputProperties = new Properties();
            if (!(this.argument[1] instanceof StringValue)) {
                throw new StaticError("Second argument of saxon:serialize must be known at compile time");
            }
            this.outputProperties.setProperty("method", ((StringValue)this.argument[1]).getStringValue());
        }
    }

    public Item evaluateItem(XPathContext xPathContext) throws XPathException {
        NodeInfo nodeInfo = (NodeInfo)this.argument[0].evaluateItem(xPathContext);
        if (nodeInfo == null) {
            return StringValue.EMPTY_STRING;
        }
        try {
            StringWriter stringWriter = new StringWriter();
            XPathContextMinor xPathContextMinor = xPathContext.newMinorContext();
            xPathContext.setOriginatingConstructType(2053);
            xPathContextMinor.changeOutputDestination(this.outputProperties, new StreamResult(stringWriter), false, this.getHostLanguage(), 3, null);
            SequenceReceiver sequenceReceiver = xPathContextMinor.getReceiver();
            sequenceReceiver.open();
            nodeInfo.copy(sequenceReceiver, 2, true, this.locationId);
            sequenceReceiver.close();
            return new StringValue(stringWriter.toString());
        }
        catch (XPathException xPathException) {
            throw new DynamicError(xPathException);
        }
    }
}

