/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.IntegerValue;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.StringValue;

public class FilterIterator
implements SequenceIterator {
    protected SequenceIterator base;
    protected Expression filter;
    private int position = 0;
    private Item current = null;
    protected XPathContext filterContext;

    public FilterIterator(SequenceIterator sequenceIterator, Expression expression, XPathContext xPathContext) {
        this.base = sequenceIterator;
        this.filter = expression;
        this.filterContext = xPathContext.newMinorContext();
        this.filterContext.setCurrentIterator(sequenceIterator);
        this.filterContext.setOriginatingConstructType(2024);
    }

    public Item next() throws XPathException {
        this.current = this.getNextMatchingItem();
        this.position = this.current == null ? -1 : ++this.position;
        return this.current;
    }

    protected Item getNextMatchingItem() throws XPathException {
        Item item;
        do {
            if ((item = this.base.next()) != null) continue;
            return null;
        } while (!this.matches());
        return item;
    }

    protected boolean matches() throws XPathException {
        SequenceIterator sequenceIterator = this.filter.iterate(this.filterContext);
        Item item = sequenceIterator.next();
        if (item == null) {
            return false;
        }
        if (item instanceof NodeInfo) {
            return true;
        }
        if (item instanceof BooleanValue) {
            if (sequenceIterator.next() != null) {
                ExpressionTool.ebvError("sequence of two or more items starting with a boolean");
            }
            return ((BooleanValue)item).getBooleanValue();
        }
        if (item instanceof StringValue) {
            if (sequenceIterator.next() != null) {
                ExpressionTool.ebvError("sequence of two or more items starting with a string");
            }
            return item.getStringValueCS().length() != 0;
        }
        if (item instanceof NumericValue) {
            if (sequenceIterator.next() != null) {
                ExpressionTool.ebvError("sequence of two or more items starting with a numeric value");
            }
            IntegerValue integerValue = new IntegerValue(this.base.position());
            return item.equals(integerValue);
        }
        ExpressionTool.ebvError("sequence starting with an atomic value other than a boolean, number, or string");
        return false;
    }

    public Item current() {
        return this.current;
    }

    public int position() {
        return this.position;
    }

    public SequenceIterator getAnother() throws XPathException {
        return new FilterIterator(this.base.getAnother(), this.filter, this.filterContext);
    }

    public int getProperties() {
        return 0;
    }

    public static final class Leading
    extends FilterIterator {
        public Leading(SequenceIterator sequenceIterator, Expression expression, XPathContext xPathContext) {
            super(sequenceIterator, expression, xPathContext);
        }

        protected boolean matches() throws XPathException {
            return this.filter.effectiveBooleanValue(this.filterContext);
        }

        protected Item getNextMatchingItem() throws XPathException {
            Item item = this.base.next();
            if (item == null) {
                return null;
            }
            if (this.matches()) {
                return item;
            }
            return null;
        }

        public SequenceIterator getAnother() throws XPathException {
            return new Leading(this.base.getAnother(), this.filter, this.filterContext);
        }
    }

    public static final class NonNumeric
    extends FilterIterator {
        public NonNumeric(SequenceIterator sequenceIterator, Expression expression, XPathContext xPathContext) {
            super(sequenceIterator, expression, xPathContext);
        }

        protected boolean matches() throws XPathException {
            return this.filter.effectiveBooleanValue(this.filterContext);
        }

        public SequenceIterator getAnother() throws XPathException {
            return new NonNumeric(this.base.getAnother(), this.filter, this.filterContext);
        }
    }
}

