/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.daq.ims.channel;

import java.io.File;
import java.io.IOException;
import java.nio.IntBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import nom.tam.fits.BasicHDU;
import nom.tam.fits.Data;
import nom.tam.fits.FitsException;
import nom.tam.fits.FitsFactory;
import nom.tam.fits.FitsUtil;
import nom.tam.fits.Header;
import nom.tam.fits.TruncatedFileException;
import nom.tam.fits.header.Standard;
import nom.tam.image.compression.hdu.CompressedImageHDU;
import nom.tam.util.BufferedFile;
import org.lsst.ccs.daq.ims.channel.Compress18BitChannel;
import org.lsst.ccs.daq.ims.channel.IntBufferReader;
import org.lsst.ccs.daq.ims.channel.IntFileChannelReader;
import org.lsst.ccs.daq.ims.channel.MultiplexingIntChannel;
import org.lsst.ccs.daq.ims.channel.ReadableIntChannel;
import org.lsst.ccs.daq.ims.channel.ReadoutConfig;
import org.lsst.ccs.daq.ims.channel.SubtractingReadableIntChannel;
import org.lsst.ccs.daq.ims.channel.XORReadableIntChannel;
import org.lsst.ccs.utilities.location.Location;

public class FitsIntReader
implements ReadableIntChannel {
    private final Compress18BitChannel input;
    private final List<Segment> segments;

    public FitsIntReader(Location.LocationType sourceType, File ... files) throws IOException, TruncatedFileException {
        ReadoutConfig config = new ReadoutConfig(sourceType, false);
        List<String> segmentNames = Arrays.asList(config.getDataSegmentNames());
        int[] dataSegmentMap = config.getDataSegmentMap();
        int[] inverseSegmentMap = new int[dataSegmentMap.length];
        int nSegmentsPerCCD = dataSegmentMap.length;
        for (int i = 0; i < dataSegmentMap.length; ++i) {
            inverseSegmentMap[dataSegmentMap[i]] = i;
        }
        this.segments = new ArrayList<Segment>();
        for (File file : files) {
            FitsIntReader.openFITSFile(this.segments, file);
        }
        ReadableIntChannel[] inputs = new ReadableIntChannel[this.segments.size()];
        int j = 0;
        for (Segment segment : this.segments) {
            String extName = segment.getExtensionName();
            int index = segmentNames.indexOf(extName);
            if (index < 0) {
                throw new IOException("Invalid segment name " + extName);
            }
            int channelNumber = inverseSegmentMap[index] + nSegmentsPerCCD * config.getDataSensorMap()[j / nSegmentsPerCCD];
            inputs[channelNumber] = segment.getIntChannel();
            ++j;
        }
        MultiplexingIntChannel multiplex = new MultiplexingIntChannel(inputs);
        XORReadableIntChannel xor = new XORReadableIntChannel(multiplex, config.getXor());
        this.input = new Compress18BitChannel(xor);
    }

    @Override
    public void close() throws IOException {
        this.input.close();
        for (Segment segment : this.segments) {
            segment.close();
        }
    }

    private static void openFITSFile(List<Segment> segments, File file) throws IOException, TruncatedFileException {
        BufferedFile bf = new BufferedFile(file, "r");
        for (int i = 0; i < 17; ++i) {
            Header header = new Header(bf);
            String ccdSlot = null;
            if (i == 0) {
                ccdSlot = header.getStringValue("CCDSLOT");
            }
            if (i <= 0) continue;
            Segment segment = new Segment(header, bf, bf.getFilePointer(), ccdSlot);
            int dataSize = segment.getSizeToSkip();
            int pad = FitsUtil.padding(dataSize);
            bf.skip(dataSize + pad);
            segments.add(segment);
        }
    }

    @Override
    public int read() throws IOException {
        return this.input.read();
    }

    @Override
    public int read(IntBuffer buffer) throws IOException {
        return this.input.read(buffer);
    }

    @Override
    public boolean isOpen() {
        return this.input.isOpen();
    }

    static {
        FitsFactory.setUseHierarch(true);
        FitsFactory.setLongStringsEnabled(true);
    }

    private static class Segment {
        private final Header header;
        private final BufferedFile bf;
        private final long filePointer;
        private final String ccdSlot;
        private final int nAxis1;
        private final int nAxis2;
        private final FileChannel channel;
        private final int bzero;
        private final int rawDataLength;
        private final boolean isCompressed;

        public Segment(Header header, BufferedFile bf, long filePointer, String ccdSlot) {
            this.header = header;
            this.bf = bf;
            this.channel = bf.getChannel();
            this.filePointer = filePointer;
            this.ccdSlot = ccdSlot;
            this.isCompressed = header.getBooleanValue("ZIMAGE");
            if (this.isCompressed) {
                this.nAxis1 = header.getIntValue("ZNAXIS1");
                this.nAxis2 = header.getIntValue("ZNAXIS2");
                this.rawDataLength = header.getIntValue(Standard.NAXIS1) * header.getIntValue(Standard.NAXIS2) + header.getIntValue("PCOUNT");
            } else {
                this.nAxis1 = header.getIntValue(Standard.NAXIS1);
                this.nAxis2 = header.getIntValue(Standard.NAXIS2);
                this.rawDataLength = this.nAxis1 * this.nAxis2 * 4;
            }
            this.bzero = header.getIntValue(Standard.BZERO);
        }

        private String getExtensionName() {
            return this.header.getStringValue(Standard.EXTNAME);
        }

        private int getDataSize() {
            return this.nAxis1 * this.nAxis2 * 4;
        }

        private FileChannel getChannel() {
            return this.channel;
        }

        private long getSeekPosition() {
            return this.filePointer;
        }

        private void close() throws IOException {
            this.channel.close();
        }

        private int getBZero() {
            return this.bzero;
        }

        private int getSizeToSkip() {
            return this.rawDataLength;
        }

        private ReadableIntChannel getIntChannel() throws IOException {
            ReadableIntChannel result;
            if (this.isCompressed) {
                try {
                    Data data = this.header.makeData();
                    this.bf.seek(this.filePointer);
                    data.read(this.bf);
                    BasicHDU<Data> compressedImageHDU = FitsFactory.hduFactory(this.header, data);
                    IntBuffer intBuffer = (IntBuffer)((CompressedImageHDU)compressedImageHDU).getUncompressedData();
                    result = new IntBufferReader(intBuffer);
                }
                catch (FitsException x) {
                    throw new IOException("Error uncompressing FITS file", x);
                }
            } else {
                result = new IntFileChannelReader(this.getChannel(), this.getSeekPosition(), this.getDataSize());
            }
            if (this.getBZero() != 0) {
                result = new SubtractingReadableIntChannel(result, this.getBZero());
            }
            return result;
        }
    }
}

