/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.client;

import java.util.concurrent.ExecutorService;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.RxInvoker;
import javax.ws.rs.client.SyncInvoker;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.Response;

public abstract class AbstractRxInvoker<T>
implements RxInvoker<T> {
    private final SyncInvoker syncInvoker;
    private final ExecutorService executorService;

    public AbstractRxInvoker(SyncInvoker syncInvoker, ExecutorService executor) {
        if (syncInvoker == null) {
            throw new IllegalArgumentException("Invocation builder cannot be null.");
        }
        this.syncInvoker = syncInvoker;
        this.executorService = executor;
    }

    protected SyncInvoker getSyncInvoker() {
        return this.syncInvoker;
    }

    protected ExecutorService getExecutorService() {
        return this.executorService;
    }

    public T get() {
        return this.method("GET");
    }

    public <R> T get(Class<R> responseType) {
        return this.method("GET", responseType);
    }

    public <R> T get(GenericType<R> responseType) {
        return this.method("GET", responseType);
    }

    public T put(Entity<?> entity) {
        return this.method("PUT", entity);
    }

    public <R> T put(Entity<?> entity, Class<R> clazz) {
        return (T)this.method("PUT", entity, clazz);
    }

    public <R> T put(Entity<?> entity, GenericType<R> type) {
        return (T)this.method("PUT", entity, type);
    }

    public T post(Entity<?> entity) {
        return this.method("POST", entity);
    }

    public <R> T post(Entity<?> entity, Class<R> clazz) {
        return (T)this.method("POST", entity, clazz);
    }

    public <R> T post(Entity<?> entity, GenericType<R> type) {
        return (T)this.method("POST", entity, type);
    }

    public T delete() {
        return this.method("DELETE");
    }

    public <R> T delete(Class<R> responseType) {
        return this.method("DELETE", responseType);
    }

    public <R> T delete(GenericType<R> responseType) {
        return this.method("DELETE", responseType);
    }

    public T head() {
        return this.method("HEAD");
    }

    public T options() {
        return this.method("OPTIONS");
    }

    public <R> T options(Class<R> responseType) {
        return this.method("OPTIONS", responseType);
    }

    public <R> T options(GenericType<R> responseType) {
        return this.method("OPTIONS", responseType);
    }

    public T trace() {
        return this.method("TRACE");
    }

    public <R> T trace(Class<R> responseType) {
        return this.method("TRACE", responseType);
    }

    public <R> T trace(GenericType<R> responseType) {
        return this.method("TRACE", responseType);
    }

    public T method(String name) {
        return this.method(name, Response.class);
    }

    public <R> T method(String name, Class<R> responseType) {
        return (T)this.method(name, null, responseType);
    }

    public <R> T method(String name, GenericType<R> responseType) {
        return (T)this.method(name, null, responseType);
    }

    public T method(String name, Entity<?> entity) {
        return (T)this.method(name, entity, Response.class);
    }
}

