/*
 * Decompiled with CFR 0.152.
 */
package hep.aida.ref.plotter.style.registry;

import hep.aida.ref.plotter.style.registry.JELRule;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import org.freehep.application.Application;

public class JELRuleEditorPanel
extends JPanel {
    private String title;
    private JTextField field;
    private JPanel actionsPanel;
    private JComboBox qualifiers;
    private JComboBox logics;
    private JComboBox operations;
    private DefaultComboBoxModel noneModel;
    private DefaultComboBoxModel intModel;
    private DefaultComboBoxModel logicModel;
    private DefaultComboBoxModel stringModel;
    private DefaultComboBoxModel objectModel;
    private JButton ok;
    private JButton cancel;
    private String oldText;
    private JELRule rule;

    public JELRuleEditorPanel() {
        this((JELRule)null);
    }

    public JELRuleEditorPanel(JELRule rule) {
        this("JEL Rule Editor", rule);
    }

    public JELRuleEditorPanel(String title, JELRule rule) {
        this.title = title;
        this.createActionsPanel();
        this.initComponents();
        if (rule != null) {
            this.setRule(rule);
        }
    }

    private void initComponents() {
        this.field = new JTextField(40);
        this.ok = new JButton("Set Rule");
        this.ok.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                JELRuleEditorPanel.this.okAction();
            }
        });
        this.cancel = new JButton("Cancel");
        this.cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                JELRuleEditorPanel.this.cancelAction();
            }
        });
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.insets = new Insets(2, 2, 2, 2);
        JPanel rulePanel = new JPanel();
        rulePanel.setLayout(new GridBagLayout());
        gbc.gridy = 0;
        gbc.gridx = 0;
        rulePanel.add((Component)new JLabel("Rule: "), gbc);
        gbc.gridx = 1;
        rulePanel.add((Component)this.field, gbc);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new GridBagLayout());
        gbc.gridy = 0;
        gbc.gridx = 0;
        buttonPanel.add((Component)this.cancel, gbc);
        gbc.gridy = 0;
        gbc.gridx = 1;
        buttonPanel.add((Component)this.ok, gbc);
        this.setLayout(new BoxLayout(this, 1));
        this.setBorder(new TitledBorder(new EtchedBorder(), this.title));
        if (this.actionsPanel != null) {
            this.add(this.actionsPanel);
        }
        this.add(rulePanel);
        this.add(buttonPanel);
    }

    private void createActionsPanel() {
        String[] qual = new String[]{"[NONE]", "OverlayIndex", "OverlayTotal", "RegionIndex", "RegionTotal", "Path", "Object", "ObjectAIDAType", "attribute(\"\")"};
        String[] none = new String[]{"[NONE]"};
        String[] logic = new String[]{"[NONE]", " && ", " || ", " ( ", " ) "};
        String[] integ = new String[]{"[NONE]", " == ", " != ", " >= ", " <= ", " > ", " < "};
        String[] str = new String[]{"[NONE]", ".equals(\"\")", ".equalsIgnoreCase(\"\")", ".startsWith(\"\")", ".endsWith(\"\")", ".contains(\"\")", ".indexOf(\"\")", ".lastIndexOf(\"\")", ".toLowerCase(\"\")", ".toUpperCase(\"\")"};
        String[] objm = new String[]{"[NONE]", ".getClass()", ".toString()"};
        this.noneModel = new DefaultComboBoxModel<String>(none);
        this.intModel = new DefaultComboBoxModel<String>(integ);
        this.logicModel = new DefaultComboBoxModel<String>(logic);
        this.stringModel = new DefaultComboBoxModel<String>(str);
        this.objectModel = new DefaultComboBoxModel<String>(objm);
        this.qualifiers = new JComboBox<String>(qual);
        this.qualifiers.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                System.out.println("Qualifiers : " + e.getStateChange());
                if (e.getStateChange() == 1) {
                    String message = e.getItem() instanceof String ? (String)e.getItem() : e.getItem().toString();
                    System.out.println("Qualifiers Selected: " + message);
                    if (!message.equals("[NONE]")) {
                        if (message.equals("OverlayIndex") || message.equals("OverlayTotal") || message.equals("RegionIndex") || message.equals("RegionTotal")) {
                            JELRuleEditorPanel.this.setIntModel();
                        } else if (message.equals("Object")) {
                            JELRuleEditorPanel.this.setObjectModel();
                        } else {
                            JELRuleEditorPanel.this.setStringModel();
                        }
                        JELRuleEditorPanel.this.addTextToTheRule(message);
                    } else {
                        JELRuleEditorPanel.this.setNoneModel();
                    }
                }
            }
        });
        this.logics = new JComboBox(this.logicModel);
        this.logics.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    String message = e.getItem() instanceof String ? (String)e.getItem() : e.getItem().toString();
                    System.out.println("Logics Selected: " + message);
                    if (!message.equals("[NONE]")) {
                        JELRuleEditorPanel.this.addTextToTheRule(message);
                        JELRuleEditorPanel.this.logics.setSelectedIndex(0);
                    }
                }
            }
        });
        this.operations = new JComboBox(this.intModel);
        this.operations.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    String message = e.getItem() instanceof String ? (String)e.getItem() : e.getItem().toString();
                    System.out.println("Qualifiers Selected: " + message);
                    if (!message.equals("[NONE]")) {
                        JELRuleEditorPanel.this.addTextToTheRule(message);
                        JELRuleEditorPanel.this.operations.setSelectedIndex(0);
                        JELRuleEditorPanel.this.qualifiers.setSelectedIndex(0);
                    }
                }
            }
        });
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 17;
        gbc.insets = new Insets(2, 2, 2, 2);
        this.actionsPanel = new JPanel();
        this.actionsPanel.setLayout(new GridBagLayout());
        gbc.gridy = 0;
        gbc.gridx = 0;
        this.actionsPanel.add((Component)new JLabel(" Qualifiers: "), gbc);
        gbc.gridx = 1;
        this.actionsPanel.add((Component)this.qualifiers, gbc);
        gbc.gridx = 2;
        this.actionsPanel.add((Component)new JLabel(" Logics: "), gbc);
        gbc.gridx = 3;
        this.actionsPanel.add((Component)this.logics, gbc);
        gbc.gridx = 4;
        this.actionsPanel.add((Component)new JLabel(" Operations: "), gbc);
        gbc.gridx = 5;
        this.actionsPanel.add((Component)this.operations, gbc);
    }

    public JELRule getRule() {
        return this.rule;
    }

    public void setRule(JELRule rule) {
        this.rule = rule;
        this.oldText = rule.getDescription();
        if (this.oldText == null) {
            this.oldText = "";
        }
        this.field.setText(this.oldText);
    }

    public boolean isModified() {
        if (this.rule.getDescription() != null) {
            if (!this.rule.getDescription().equals(this.field.getText())) {
                return true;
            }
            if (!this.rule.getDescription().equals(this.oldText)) {
                return true;
            }
        }
        return this.rule.getDescription() == null && this.field.getText() != null && !this.field.getText().trim().equals("");
    }

    void okAction() {
        try {
            String tmp = this.field.getText();
            this.rule.setDescription(tmp);
            this.oldText = tmp;
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    void cancelAction() {
        try {
            this.rule.setDescription(this.oldText);
            this.field.setText(this.oldText);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    private void setNoneModel() {
        this.operations.setModel(this.noneModel);
    }

    private void setIntModel() {
        this.operations.setModel(this.intModel);
    }

    private void setStringModel() {
        this.operations.setModel(this.stringModel);
    }

    private void setObjectModel() {
        this.operations.setModel(this.objectModel);
    }

    private void addTextToTheRule(String text) {
        String tmp = this.field.getText();
        tmp = tmp + text;
        this.field.setText(tmp);
    }

    private void handleException(Exception e) {
        this.handleException("", e);
    }

    private void handleException(String message, Exception e) {
        if (Application.getApplication() != null) {
            Application.error((Component)Application.getApplication(), (String)message, (Throwable)e);
        }
        System.out.println("ERROR: " + message + "\n");
        if (e != null) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame("TesT");
        frame.setDefaultCloseOperation(3);
        JELRuleEditorPanel panel = new JELRuleEditorPanel(new JELRule());
        frame.getContentPane().add(panel);
        frame.pack();
        frame.setVisible(true);
    }
}

