/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.focalplane.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.function.Consumer;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.lsst.ccs.bus.data.AgentCategory;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.gconsole.agent.AgentChannelsFilter;
import org.lsst.ccs.gconsole.agent.AgentStatusEvent;
import org.lsst.ccs.gconsole.agent.AgentStatusListener;
import org.lsst.ccs.gconsole.annotations.Plugin;
import org.lsst.ccs.gconsole.base.ComponentDescriptor;
import org.lsst.ccs.gconsole.base.Console;
import org.lsst.ccs.gconsole.base.ConsolePlugin;
import org.lsst.ccs.gconsole.base.OptionalPage;
import org.lsst.ccs.gconsole.base.panel.Panel;
import org.lsst.ccs.gconsole.base.panel.PanelManager;
import org.lsst.ccs.gconsole.plugins.monitor.SectionedTableView;
import org.lsst.ccs.gconsole.services.persist.DataPanelDescriptor;
import org.lsst.ccs.subsystem.focalplane.data.FocalPlaneDataGroup;
import org.lsst.ccs.subsystem.focalplane.ui.FocalPlaneMonitorFilter;
import org.lsst.ccs.subsystem.focalplane.ui.fpmap.FocalPlaneMapPage;
import org.lsst.ccs.subsystem.focalplane.ui.fpmap.FocalPlaneMapPageDialog;
import org.lsst.ccs.subsystem.focalplane.ui.fpmap.Segment;

@Plugin(name="LSST CCS Focal Plane GUI", id="focal-plane-gui", description="LSST CCS Focal Plane Subsystem GUI")
public class FocalPlanePlugin
extends ConsolePlugin {
    private final String DEFAULT_FOCAL_PLANE_MAP_PAGE_NAME = "Focal Plane";
    private final ArrayList<FocalPlaneMapPage> focalPlaneMapPages = new ArrayList();
    private AgentStatusListener statusListener;

    public void initialize() {
        OptionalPage.getService().add((OptionalPage)new FocalPlaneMonitoringOptionalPage());
    }

    public void start() {
        this.initFocalPlaneMaps();
    }

    public void stop() {
        this.getConsole().getStatusAggregator().removeListener(this.statusListener);
        this.statusListener = null;
    }

    private void initFocalPlaneMaps() {
        this.statusListener = new AgentStatusListener(){

            public void connect(AgentStatusEvent event) {
                AgentInfo agent = event.getSource();
                if (agent.getAgentProperty("agentCategory", "").equals(AgentCategory.FOCAL_PLANE.name())) {
                    SwingUtilities.invokeLater(() -> {
                        final String agentName = agent.getName();
                        AbstractAction act = new AbstractAction("Custom..."){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                FocalPlaneMapPage.Descriptor d = FocalPlaneMapPageDialog.show(null, "Focal Plane");
                                if (d != null) {
                                    d.setAgent(agentName);
                                    FocalPlanePlugin.this.openFocalPlaneMap(d);
                                }
                            }
                        };
                        FocalPlanePlugin.this.getServices().addMenu((Action)act, new String[]{"CCS Subsystems", agentName, "Map"});
                        FocalPlanePlugin.this.addFocalPlaneMapMenu(agentName, 1, 1);
                        FocalPlanePlugin.this.addFocalPlaneMapMenu(agentName, 1, 2);
                        FocalPlanePlugin.this.addFocalPlaneMapMenu(agentName, 2, 1);
                        FocalPlanePlugin.this.addFocalPlaneMapMenu(agentName, 2, 2);
                        FocalPlanePlugin.this.addFocalPlaneMapMenu(agentName, 1, 3);
                        FocalPlanePlugin.this.addFocalPlaneMapMenu(agentName, 2, 3);
                        FocalPlanePlugin.this.addFocalPlaneMapMenu(agentName, 3, 3);
                        FocalPlanePlugin.this.addFocalPlaneMapMenu(agentName, 4, 4);
                    });
                }
            }

            public void disconnect(AgentStatusEvent event) {
                SwingUtilities.invokeLater(() -> {
                    String agentName = event.getSource().getName();
                    FocalPlanePlugin.this.getConsole().removeMenu(new String[]{"CCS Subsystems", agentName, "Map"});
                });
            }
        };
        this.getConsole().getStatusAggregator().addListener(this.statusListener, null, Collections.singletonList(Segment.RAFT.getKey()));
    }

    private void openFocalPlaneMap(FocalPlaneMapPage.Descriptor descriptor) {
        String title;
        HashMap data;
        FocalPlaneMapPage page = new FocalPlaneMapPage(descriptor);
        this.focalPlaneMapPages.add(page);
        HashMap<Panel, Object> par = new HashMap<Panel, Object>();
        DataPanelDescriptor panDesc = descriptor.getPage();
        if (panDesc != null && panDesc.isOpen() && (data = panDesc.getData()) != null) {
            par.putAll(data);
        }
        if ((title = descriptor.getName()) == null) {
            title = "Focal Plane";
        }
        par.put(Panel.TITLE, title);
        Consumer<JComponent> onClose = c -> this.onClosingFocalPlaneMap((FocalPlaneMapPage)c);
        par.put(Panel.ON_CLOSE, onClose);
        Console.getConsole().getPanelManager().open((Component)page, par);
        page.opened();
    }

    private void onClosingFocalPlaneMap(FocalPlaneMapPage page) {
        page.closed();
        this.focalPlaneMapPages.remove(page);
    }

    private void addFocalPlaneMapMenu(final String agent, final int rows, final int columns) {
        AbstractAction act = new AbstractAction(columns + " x " + rows){

            @Override
            public void actionPerformed(ActionEvent e) {
                FocalPlanePlugin.this.openFocalPlaneMap(new FocalPlaneMapPage.Descriptor(agent, rows, columns));
            }
        };
        this.getServices().addMenu((Action)act, new String[]{"CCS Subsystems", agent, "Map"});
    }

    public boolean restore(ComponentDescriptor storageBean, boolean lastRound) {
        Descriptor desc;
        FocalPlaneMapPage.Descriptor[] pages;
        if (!this.focalPlaneMapPages.isEmpty()) {
            PanelManager panMan = Console.getConsole().getPanelManager();
            ArrayList<FocalPlaneMapPage> copy = new ArrayList<FocalPlaneMapPage>(this.focalPlaneMapPages);
            for (FocalPlaneMapPage page : copy) {
                panMan.close((Component)page);
            }
        }
        if (storageBean instanceof Descriptor && (pages = (desc = (Descriptor)storageBean).getMapPages()) != null && pages.length != 0) {
            for (FocalPlaneMapPage.Descriptor pageDescriptor : pages) {
                this.openFocalPlaneMap(pageDescriptor);
            }
        }
        return true;
    }

    public Descriptor save() {
        Descriptor desc = new Descriptor(this.getServices().getDescriptor());
        ArrayList<FocalPlaneMapPage.Descriptor> mapPages = new ArrayList<FocalPlaneMapPage.Descriptor>(this.focalPlaneMapPages.size());
        for (FocalPlaneMapPage view : this.focalPlaneMapPages) {
            FocalPlaneMapPage.Descriptor d = view.save();
            if (d == null) continue;
            mapPages.add(d);
        }
        if (!mapPages.isEmpty()) {
            desc.setMapPages(mapPages.toArray(new FocalPlaneMapPage.Descriptor[mapPages.size()]));
        }
        return desc;
    }

    public static class Descriptor
    extends ComponentDescriptor {
        private FocalPlaneMapPage.Descriptor[] mapPages;

        public Descriptor() {
        }

        public Descriptor(ComponentDescriptor seed) {
            super(seed);
        }

        public FocalPlaneMapPage.Descriptor[] getMapPages() {
            return this.mapPages;
        }

        public void setMapPages(FocalPlaneMapPage.Descriptor[] mapPages) {
            this.mapPages = mapPages;
        }
    }

    private static final class DataGroupMonitor
    extends JPanel {
        JComboBox dataSelector = new JComboBox<FocalPlaneDataGroup>(FocalPlaneDataGroup.values());
        SectionedTableView view = new SectionedTableView();
        private final AgentInfo agent;

        DataGroupMonitor(AgentInfo agent) {
            this.agent = agent;
            this.setLayout(new BorderLayout());
            this.add((Component)this.dataSelector, "First");
            this.makeFilteredTable();
            this.dataSelector.addActionListener(e -> {
                this.remove(this.view.getPanel());
                this.view = new SectionedTableView();
                this.makeFilteredTable();
            });
        }

        final void makeFilteredTable() {
            FocalPlaneMonitorFilter monitorFilter = new FocalPlaneMonitorFilter(this.agent.getName(), (FocalPlaneDataGroup)this.dataSelector.getSelectedItem());
            this.view.uninstall();
            this.view.setFilter((AgentChannelsFilter)monitorFilter);
            this.view.install();
            this.add((Component)this.view.getPanel(), "Center");
        }
    }

    static class FocalPlaneMonitoringOptionalPage
    implements OptionalPage {
        FocalPlaneMonitoringOptionalPage() {
        }

        public boolean isAutoOpen() {
            return false;
        }

        public String getPage(AgentInfo agent) {
            if (agent.getAgentProperty("agentCategory", "").equals(AgentCategory.FOCAL_PLANE.name())) {
                return "CCS Subsystems/" + agent.getName() + "/Monitoring";
            }
            return null;
        }

        public JComponent open(AgentInfo agent, JComponent existingComponent) {
            DataGroupMonitor dataSelection = new DataGroupMonitor(agent);
            return dataSelection;
        }
    }
}

