/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.fits.header;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import nom.tam.fits.header.IFitsHeader;
import nom.tam.fits.header.Standard;
import nom.tam.fits.header.extra.NOAOExt;
import nom.tam.fits.header.extra.SBFitsExt;
import nom.tam.fits.header.extra.STScIExt;

public enum Synonyms {
    EQUINOX(Standard.EQUINOX, Standard.EPOCH),
    TIMESYS(NOAOExt.TIMESYS, STScIExt.TIMESYS),
    RADESYS(Standard.RADESYS, Standard.RADECSYS),
    DARKTIME(NOAOExt.DARKTIME, SBFitsExt.DARKTIME);

    private final IFitsHeader primaryKeyword;
    private final IFitsHeader[] synonyms;

    private Synonyms(IFitsHeader primaryKeyword, IFitsHeader ... synonyms) {
        this.primaryKeyword = primaryKeyword;
        this.synonyms = synonyms;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="by convention the array may not be changed.")
    public IFitsHeader[] getSynonyms() {
        return this.synonyms;
    }

    public IFitsHeader primaryKeyword() {
        return this.primaryKeyword;
    }

    public static IFitsHeader primaryKeyword(IFitsHeader header) {
        for (Synonyms synonym : Synonyms.values()) {
            for (IFitsHeader synHeader : synonym.synonyms) {
                if (!synHeader.equals(header)) continue;
                return synonym.primaryKeyword();
            }
        }
        return header;
    }

    public static String primaryKeyword(String header) {
        for (Synonyms synonym : Synonyms.values()) {
            for (IFitsHeader synHeader : synonym.synonyms) {
                if (!synHeader.key().equals(header)) continue;
                return synonym.primaryKeyword().key();
            }
        }
        return header;
    }
}

