/*
 * Decompiled with CFR 0.152.
 */
package jas.hist;

import jas.hist.DataSource;
import jas.hist.DateTransformationConverter;
import jas.hist.Handle;
import jas.hist.HasHandles;
import jas.plot.CoordinateTransformation;
import jas.plot.DateCoordinateTransformation;
import jas.plot.DoubleCoordinateTransformation;
import jas.plot.Overlay;
import jas.plot.OverlayContainer;
import jas.plot.PlotGraphics;
import jas.plot.PrintHelper;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;

public abstract class OverlayWithHandles
implements Overlay,
MouseListener,
MouseMotionListener {
    private Cursor defaultCursor = null;
    private static MouseEvent mouseEvent = null;
    private static boolean changeCursor;
    private boolean handlesPainted = false;
    private static final double handleSize = 2.5;
    private HandleWrapper[] handles = null;
    private HandleWrapper currentHandle = null;
    private HandleWrapper capturedHandle = null;
    private HasHandles hasHandles;
    protected OverlayContainer container;

    protected OverlayWithHandles(DataSource ds) {
        if (ds instanceof HasHandles) {
            this.hasHandles = (HasHandles)((Object)ds);
        }
    }

    public void paint(PlotGraphics g) {
        if (this.handles != null && !PrintHelper.isPrinting()) {
            CoordinateTransformation xt = this.container.getXTransformation();
            CoordinateTransformation yt = this.container.getYTransformation();
            g.clearTransformation();
            for (int i = 0; i < this.handles.length; ++i) {
                this.handles[i].paint(g, xt, yt);
            }
        }
    }

    void paintHandles(MouseEvent e) {
        this.handlesPainted = true;
        CoordinateTransformation xt = this.container.getXTransformation();
        DoubleCoordinateTransformation xp = xt instanceof DateCoordinateTransformation ? new DateTransformationConverter((DateCoordinateTransformation)xt) : (DoubleCoordinateTransformation)xt;
        CoordinateTransformation yt = this.container.getYTransformation();
        DoubleCoordinateTransformation yp = yt instanceof DateCoordinateTransformation ? new DateTransformationConverter((DateCoordinateTransformation)yt) : (DoubleCoordinateTransformation)yt;
        Handle[] temp = this.hasHandles.getHandles(xp.getPlotMin(), xp.getPlotMax(), yp.getPlotMin(), yp.getPlotMax());
        this.handles = new HandleWrapper[temp.length];
        for (int i = 0; i < this.handles.length; ++i) {
            this.handles[i] = new HandleWrapper(temp[i]);
        }
        this.container.repaint();
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.paintHandles(e);
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.handles = null;
        this.container.repaint();
        this.handlesPainted = false;
    }

    @Override
    public void mouseMoved(MouseEvent event) {
        if (!this.handlesPainted) {
            this.paintHandles(event);
        }
        if (mouseEvent == null || mouseEvent != event) {
            mouseEvent = event;
            changeCursor = true;
        }
        if (this.defaultCursor == null) {
            this.defaultCursor = event.getComponent().getCursor();
        }
        Point p = event.getPoint();
        if (this.handles != null) {
            for (int i = 0; i < this.handles.length; ++i) {
                if (!this.handles[i].contains(p)) continue;
                Cursor cursor = this.handles[i].cursor();
                if (cursor != null) {
                    event.getComponent().setCursor(cursor);
                    changeCursor = false;
                }
                this.setCurrentHandle(this.handles[i]);
                return;
            }
            if (event.getComponent().getCursor() != this.defaultCursor && changeCursor) {
                event.getComponent().setCursor(this.defaultCursor);
            }
        }
        this.setCurrentHandle(null);
    }

    @Override
    public void mousePressed(MouseEvent event) {
        if (this.currentHandle != null) {
            this.captureHandle(this.currentHandle);
        }
    }

    @Override
    public void mouseReleased(MouseEvent event) {
        this.captureHandle(null);
    }

    @Override
    public void mouseClicked(MouseEvent event) {
    }

    @Override
    public void mouseDragged(MouseEvent event) {
        if (this.capturedHandle != null) {
            this.capturedHandle.moveTo(event.getPoint());
            this.container.repaint();
        }
    }

    @Override
    public void containerNotify(OverlayContainer c) {
        if (this.container != null) {
            this.container.removeMouseListener(this);
            this.container.removeMouseMotionListener(this);
        }
        this.container = c;
        if (c != null && this.hasHandles != null) {
            c.addMouseListener(this);
            c.addMouseMotionListener(this);
        }
    }

    private void setCurrentHandle(HandleWrapper h) {
        if (this.currentHandle != h) {
            this.currentHandle = h;
            this.container.repaint();
        }
    }

    private void captureHandle(HandleWrapper h) {
        if (this.capturedHandle != h) {
            this.capturedHandle = h;
            this.container.repaint();
        }
    }

    private class HandleWrapper {
        private Handle handle;

        HandleWrapper(Handle h) {
            this.handle = h;
        }

        void paint(PlotGraphics g, CoordinateTransformation xt, CoordinateTransformation yt) {
            DoubleCoordinateTransformation xp = xt instanceof DateCoordinateTransformation ? new DateTransformationConverter((DateCoordinateTransformation)xt) : (DoubleCoordinateTransformation)xt;
            DoubleCoordinateTransformation yp = yt instanceof DateCoordinateTransformation ? new DateTransformationConverter((DateCoordinateTransformation)yt) : (DoubleCoordinateTransformation)yt;
            double x = xp.convert(this.handle.getX());
            double y = yp.convert(this.handle.getY());
            g.setColor(this == OverlayWithHandles.this.currentHandle ? Color.red : Color.black);
            g.fillRect(x - 2.5, y - 2.5, x + 2.5, y + 2.5);
        }

        boolean contains(Point p) {
            CoordinateTransformation xt = OverlayWithHandles.this.container.getXTransformation();
            CoordinateTransformation yt = OverlayWithHandles.this.container.getYTransformation();
            DoubleCoordinateTransformation xp = xt instanceof DateCoordinateTransformation ? new DateTransformationConverter((DateCoordinateTransformation)xt) : (DoubleCoordinateTransformation)xt;
            DoubleCoordinateTransformation yp = yt instanceof DateCoordinateTransformation ? new DateTransformationConverter((DateCoordinateTransformation)yt) : (DoubleCoordinateTransformation)yt;
            double x = xp.convert(this.handle.getX()) - 2.5;
            double y = yp.convert(this.handle.getY()) - 2.5;
            return (double)p.x >= x && (double)p.x <= x + 5.0 && (double)p.y >= y && (double)p.y > y && (double)p.y <= y + 5.0;
        }

        void moveTo(Point p) {
            CoordinateTransformation xt = OverlayWithHandles.this.container.getXTransformation();
            CoordinateTransformation yt = OverlayWithHandles.this.container.getYTransformation();
            DoubleCoordinateTransformation xp = xt instanceof DateCoordinateTransformation ? new DateTransformationConverter((DateCoordinateTransformation)xt) : (DoubleCoordinateTransformation)xt;
            DoubleCoordinateTransformation yp = yt instanceof DateCoordinateTransformation ? new DateTransformationConverter((DateCoordinateTransformation)yt) : (DoubleCoordinateTransformation)yt;
            this.handle.moveTo(xp.unConvert(p.x), yp.unConvert(p.y));
        }

        Cursor cursor() {
            return this.handle.cursor();
        }
    }
}

