/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.daq.ims;

import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import org.lsst.ccs.daq.ims.DAQException;
import org.lsst.ccs.daq.ims.Image;
import org.lsst.ccs.daq.ims.ImageMetaData;
import org.lsst.ccs.daq.ims.Store;
import org.lsst.ccs.utilities.location.Location;

public class Camera {
    private final Store store;
    public static final int OPCODE_STOP = 31;
    private final Map<Location.LocationType, int[]> registerLists = new HashMap<Location.LocationType, int[]>();

    Camera(Store store) {
        this.store = store;
    }

    public void setRegisterList(Location.LocationType rebType, int[] registerAddresses) throws DAQException {
        this.registerLists.put(rebType, registerAddresses);
    }

    public Image triggerImage(ImageMetaData meta) throws DAQException {
        return new Image(this.store, this.store.triggerImage(meta, this.registerLists));
    }

    public Instant startSequencer(int opcode) throws DAQException {
        long timestampNanos = this.store.startSequencer(opcode);
        return Instant.ofEpochSecond(timestampNanos / 1000000000L, timestampNanos % 1000000000L);
    }
}

