/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.localdb.trendserver;

import java.net.NetworkInterface;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bootstrap.BootstrapResourceUtils;
import org.lsst.ccs.bus.data.AgentCategory;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.localdb.statusdb.trendServer.RestServer;
import org.lsst.ccs.messaging.NetworkUtilities;
import org.lsst.ccs.services.AgentPropertiesService;
import org.lsst.ccs.utilities.logging.Logger;

public class RestServerAgent
extends Subsystem
implements HasLifecycle {
    private static final Logger log = Logger.getLogger((String)"org.lsst.ccs.localdb.trendserver");
    private RestServer rs;
    private final String hostAddr;
    private final String port = BootstrapResourceUtils.getBootstrapSystemProperties().getProperty("org.lsst.ccs.rest.server.port", "8080");
    @LookupField(strategy=LookupField.Strategy.TREE)
    AgentPropertiesService agentPropertiesService;

    public RestServerAgent() throws Exception {
        super("rest-server", AgentInfo.AgentType.SERVICE);
        NetworkInterface ne = NetworkInterface.getByName(NetworkUtilities.getMainInterfaceName());
        if (ne.getInterfaceAddresses().size() > 0) {
            this.hostAddr = ne.getInterfaceAddresses().get(0).getAddress().getHostAddress();
            log.info((Object)("trend server accessible through : " + this.hostAddr));
        } else {
            log.warn((Object)"cannot determine which network address to transmit");
            this.hostAddr = null;
        }
    }

    public void build() {
        this.agentPropertiesService.setAgentProperty("rest-service-addr", this.hostAddr);
        this.agentPropertiesService.setAgentProperty("rest-service-port", this.port);
        this.agentPropertiesService.setAgentProperty("rest-service-entrypoint", "/rest/data");
        this.agentPropertiesService.setAgentProperty("agentCategory", AgentCategory.REST_SERVER.name());
    }

    public void startAgent() {
        super.startAgent();
        this.rs = new RestServer(Integer.valueOf(this.port).intValue());
        this.rs.start();
        log.info((Object)("RestServer stated on " + this.hostAddr + ":" + this.port));
    }
}

